#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "lutil.h"
#include "xutil.h"
#include "areas.h"
#include "config.h"

extern area_list *badgroups;
extern areang_list *nglist;

void tidy_arealist(al)
area_list *al;
{
	area_list *tmp;

	for (;al;al=tmp)
	{
		tmp=al->next;
		if (al->name) free(al->name);
		free(al);
	}
}

area_list *areas(ngroups)
char *ngroups;
{
	char *ng,*p,*q;
	area_list *start=NULL,*cur=NULL,*bg;
	areang_list *ngl;
	int forbid=0;

	if (ngroups == NULL) return NULL;
	ng=xstrcpy(ngroups);

	p=strtok(ng," ,\t\n");
	while (p)
	{
		q=NULL;
		for (bg=badgroups;bg;bg=bg->next)
			if (!strncmp(bg->name,p,strlen(bg->name))) forbid=1;
		for (ngl=nglist;ngl;ngl=ngl->next)
			if (!strcmp(ngl->ng,p)) q=ngl->area;
		if (q)
		{
			debug(5,"to area \"%s\"",q);
			if (start == NULL)
			{
				start=(area_list *)xmalloc(sizeof(area_list));
				cur=start;
			}
			else
			{
				cur->next=(area_list *)xmalloc(sizeof(area_list));
				cur=cur->next;
			}
			cur->next=NULL;
			cur->name=xstrcpy(q);
		}
		p=strtok(NULL," ,\t\n");
	}

	free(ng);
	if (forbid)
	{
		log("Message not gated due to forbidden groups in %s",
			ngroups);
		tidy_arealist(start); start=NULL;
		return NULL;
	}
	else return start;
}

void readareas(fn)
char *fn;
{
	areang_list *cur=NULL;
	FILE *fp;
	char buf[128],*p,*q,*r;

	if ((fp=fopen(fn,"r")) == NULL)
	{
		log("$unable to open area file %s",fn);
		return;
	}
	while (fgets(buf,sizeof(buf)-1,fp))
	{
		if (p=strchr(buf,'#')) *p='\0';
		p=strtok(buf," \t\n");
		q=strtok(NULL," \t\n");
		r=strtok(NULL," \t\n");
		if (p && q)
		{
			debug(5,"adding area \"%s\" for ng \"%s\" (dist %s)",
				p,q,r);
			if (nglist == NULL)
			{
				nglist=(areang_list *)xmalloc(sizeof(areang_list));
				cur=nglist;
			}
			else
			{
				cur->next=(areang_list *)xmalloc(sizeof(areang_list));
				cur=cur->next;
			}
			cur->next=NULL;
			cur->area=xstrcpy(p);
			cur->ng=xstrcpy(q);
			if (r) cur->dist=xstrcpy(r);
			else cur->dist=NULL;
		}
	}
}
