#include <stdio.h>
#include <string.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "areas.h"
#include "config.h"

char *configname;
fa_list *whoami = NULL;
fa_list *pwlist = NULL;
char *outbound = NULL;
char *database = NULL;
char *sequence = NULL;
area_list *badgroups=NULL;
areang_list *nglist=NULL;
char *sendmail,*inews;

char outtab[] = {
"\000\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017"
"\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037"
"\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057"
"\060\061\062\063\064\065\066\067\070\071\072\073\074\075\076\077"
"\100\101\102\103\104\105\106\107\110\111\112\113\114\115\116\117"
"\120\121\122\123\124\125\126\127\130\131\132\133\134\135\136\137"
"\140\141\142\143\144\145\146\147\150\151\152\153\154\155\156\157"
"\160\161\162\163\164\165\166\167\170\171\172\173\174\175\176\177"
"\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217"
"\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237"
"\240\241\242\243\244\245\246\247\250\251\252\253\254\255\256\257"
"\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277"
"\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317"
"\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337"
"\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357"
"\360\361\362\363\364\365\366\367\370\371\372\373\374\375\376\377"
};

char intab[] = {
"\000\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017"
"\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037"
"\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057"
"\060\061\062\063\064\065\066\067\070\071\072\073\074\075\076\077"
"\100\101\102\103\104\105\106\107\110\111\112\113\114\115\116\117"
"\120\121\122\123\124\125\126\127\130\131\132\133\134\135\136\137"
"\140\141\142\143\144\145\146\147\150\151\152\153\154\155\156\157"
"\160\161\162\163\164\165\166\167\170\171\172\173\174\175\176\177"
"\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217"
"\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237"
"\240\241\242\243\244\245\246\247\250\251\252\253\254\255\256\257"
"\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277"
"\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317"
"\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337"
"\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357"
"\360\361\362\363\364\365\366\367\370\371\372\373\374\375\376\377"
};


extern int stricmp(char *,char *);
extern void readareas(char *);

static int ctoi(s)
char *s;
{
	int i;

	if (!strncmp(s,"0x",2)) sscanf(s+2,"%x",&i);
	else if (*s == '0') sscanf(s,"%o",&i);
	else if (strspn(s,"0123456789") == strlen(s)) sscanf(s,"%d",&i);
	else i=0;
	return(i);
}

void readctab(fn,table)
char *fn;
char table[];
{
	char buf[128];
	char *p,*q;
	int i,in,on;
	FILE *fp;

	
	if ((fp=fopen(fn,"r")) == NULL)
	{
		log("$Cannot open mapchan file %s",fn);
		return;
	}

	for (i=0;i<256;i++) table[i]=i;
	while (fgets(buf,sizeof(buf)-1,fp))
	{
		p=strtok(buf," \t\n#");
		q=strtok(NULL," \t\n#");
		if (p && q)
		{
			in=ctoi(p);
			on=ctoi(q);
			if (in && on) table[in]=on;
		}
	}
	fclose (fp);
}

int readconfig(void)
{
	FILE *fp;
	char buf[BUFSIZ];
	char *k,*v,*p;
	int linecnt = 0;
	faddr *tmp=NULL;
	fa_list *tmpl=NULL;
	fa_list *tmpp=NULL;
	area_list *tmpa=NULL;
	int rc=0;

	if ((fp=fopen(configname,"r")) == NULL)
	{
		log("$cannot open configuration file %s",configname);
		return(-1);
	}
	while(fgets(buf,sizeof(buf)-1,fp))
	{
		linecnt++;

		if (k=strchr(buf,'#')) *(k--)='\0';
		else k=buf+strlen(buf)-1;
		while ((*k == ' ') || (*k == '\t') || (*k == '\n')) 
			*(k--) = '\0';

		k=buf;
		while ((*k == ' ') || (*k == '\t')) k++;
		if (*k == '\0') continue;

		for (v=k;*v && (*v != ' ') && (*v != '\t') && (*v != '=');v++);
		*(v++)='\0';
		while ((*v == ' ') || (*v == '\t') || (*v == '=')) v++;
		debug(8,"k=\"%s\", v=\"%s\"",k,v);
		if (k && !stricmp(k,"address"))
		{
			tmp=parsefnode(v);
			if (tmp)
			{
				if (!whoami)
				{
					whoami=(fa_list *)
						xmalloc(sizeof(fa_list));
					tmpl=whoami;
				}
				else
				{
					tmpl->next=(fa_list *)
						xmalloc(sizeof(fa_list));
					tmpl=tmpl->next;
				}
				tmpl->next=NULL;
				tmpl->addr=tmp;
				debug(2,"Address %s",ascinode(tmp,0x7f));
			}
			else
			log("%s(%d): invalid node specification skipped",
				configname,linecnt);
		}
		else if (k && !stricmp(k,"password"))
		{
			for (p=v;*p && (*p != ' ') && (*p != '\t') && (*p != '=');p++);
			*(p++)='\0';
			while ((*p == ' ') || (*p == '\t') || (*p == '=')) p++;

			if (*p) tmp=parsefnode(v);
			else tmp=NULL;
			if (tmp)
			{
				tmp->name=xstrcpy(p); 
				/* it cannot be filled after parsefnode() */
				if (!pwlist)
				{
					pwlist=(fa_list *)
						xmalloc(sizeof(fa_list));
					tmpp=pwlist;
				}
				else
				{
					tmpp->next=(fa_list *)
						xmalloc(sizeof(fa_list));
					tmpp=tmpp->next;
				}
				tmpp->next=NULL;
				tmpp->addr=tmp;
				debug(2,"Password for %s is %s",
					ascinode(tmp,0x1f),
					tmp->name);
			}
			else
			log("%s(%d): invalid node or no password, skipped",
				configname,linecnt);
		}
		else if (k && !stricmp(k,"badgroup"))
		{
			if (v)
			{
				if (!badgroups)
				{
					badgroups=(area_list *)
						xmalloc(sizeof(area_list));
					tmpa=badgroups;
				}
				else
				{
					tmpa->next=(area_list *)
						xmalloc(sizeof(area_list));
					tmpa=tmpa->next;
				}
				tmpa->next=NULL;
				tmpa->name=xstrcpy(v);
				debug(4,"Badgroup: %s",tmpa->name);
			}
			else
			log("%s(%d): invalid badgroup specification skipped",
				configname,linecnt);
		}
		else if (k && !stricmp(k,"outbound"))
		{
			debug(2,"Outbound %s",v);
			outbound=xstrcpy(v);
		}
		else if (k && !stricmp(k,"database"))
		{
			debug(2,"Database %s",v);
			database=xstrcpy(v);
		}
		else if (k && !stricmp(k,"sequencer"))
		{
			debug(2,"Sequencer %s",v);
			sequence=xstrcpy(v);
		}
		else if (k && !stricmp(k,"sendmail"))
		{
			debug(2,"Sendmail %s",v);
			sendmail=xstrcpy(v);
		}
		else if (k && !stricmp(k,"inews"))
		{
			debug(2,"Inews %s",v);
			inews=xstrcpy(v);
		}
		else if (k && !stricmp(k,"areas"))
		{
			debug(2,"Areas %s",v);
			readareas(v);
		}
		else if (k && !stricmp(k,"intab"))
		{
			debug(2,"Intab %s",v);
			readctab(v,intab);
		}
		else if (k && !stricmp(k,"outtab"))
		{
			debug(2,"Outtab %s",v);
			readctab(v,outtab);
		}
		else if (k)
		{
			log("%s(%d): invalid line \"%s %s\" skipped",
				configname,linecnt,k,v);
		}
	}

	if (!whoami) 
	{
		rc=-1;
		log("This system address(es) not defined in config file %s",
			configname);
	}
	if (!outbound) 
	{
		rc=-1;
		log("Outbound not defined in config file %s",configname);
	}

	return rc;
}
