#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include "xutil.h"
#include "lutil.h"
#include "bread.h"
#include "ftn.h"
#include "rfcmsg.h"
#include "mkrfcmsg.h"
#include "config.h"

extern time_t getdate(char *,void *);
extern char *rfcdate(time_t);

/* 0-no more messages, 1-more messages, 2-bad file */
int getmessage(pkt,fp,p_from,p_to)
FILE *pkt,*fp;
faddr *p_from,*p_to;
{
	char buf[BUFSIZ];
	char *subj=NULL,*orig=NULL;
	char *p,*l,*r;
	rfcmsg *kmsg=NULL,*tmsg=NULL;
	int tmp;
	faddr f,t,*o;
	int flags;
	int waskluge;
	time_t mdate;
	off_t tear_off,orig_off,via_off;

	switch(tmp=iread(pkt))
	{
	case 0:	debug(3,"zero message type - end of packet?");
		tmp=iread(pkt);
		if (feof(pkt)) return 0;
		else return 2;
	case 2:	break;
	default:log("bad message type: 0x%04x",tmp);
		return 2;
	}

	f.zone=0;
	t.zone=0;
	f.point=0;
	t.point=0;
	f.name=NULL;
	t.name=NULL;
	f.domain=NULL;
	t.domain=NULL;

	f.node=iread(pkt);
	t.node=iread(pkt);
	f.net=iread(pkt);
	t.net=iread(pkt);
	flags=iread(pkt);
	tmp=iread(pkt);
	if (aread(buf,sizeof(buf)-1,pkt))
		mdate=getdate(buf,NULL);
	if (aread(buf,sizeof(buf)-1,pkt)) log("date not null-terminated");
	if (aread(buf,sizeof(buf)-1,pkt))
		t.name=xstrcpy(buf);
	if (aread(buf,sizeof(buf)-1,pkt)) log("toname not null-terminated");
	if (aread(buf,sizeof(buf)-1,pkt))
		f.name=xstrcpy(buf);
	if (aread(buf,sizeof(buf)-1,pkt)) log("fromname not null-terminated");
	if (aread(buf,sizeof(buf)-1,pkt))
		subj=xstrcpy(buf);
	if (aread(buf,sizeof(buf)-1,pkt)) log("subj not null-terminated");

	f.zone=p_from->zone;
	t.zone=p_to->zone;

	debug(3,"message from %s",ascfnode(&f,0x7f));
	debug(3,"message to   %s",ascfnode(&t,0x7f));
	debug(3,"message subj \"%s\"",subj);
	debug(3,"message date \"%s\"",rfcdate(mdate));

	tear_off=0L;
	orig_off=0L;
	via_off=0L;
	waskluge=0;
	rewind(fp);
	while (aread(buf,sizeof(buf)-1,pkt))
	if ((buf[0] == '\1') ||
	    !strncmp(buf,"AREA:",5) ||
	    !strncmp(buf,"SEEN-BY",7)) /* This is a kluge line */
	{
		waskluge=1;
		if (buf[0] == '\1') l=buf+1;
		else l=buf;
		while (*l == ' ') l++;
		p=strchr(l,':');
		r=strchr(l,' ');
		if (p && (!r || (r > p))) r=p;
		if (r) *r++='\0';
		if (r) while (*r == ' ') r++;
		if (kmsg)
		{
			tmsg->next=(rfcmsg *)xmalloc(sizeof(rfcmsg));
			tmsg=tmsg->next;
		}
		else
		{
			kmsg=(rfcmsg *)xmalloc(sizeof(rfcmsg));
			tmsg=kmsg;
		}
		tmsg->next=NULL;
		tmsg->key=xstrcpy(l);
		tmsg->val=xstrcpy(r);
		if (!strcmp(l,"Via") && (via_off == 0L)) via_off=ftell(fp);
	}
	else /* this is not a kluge line */
	{
		if (waskluge && ((buf[0] == ' ') || (buf[0] == '\t'))) 
			fputs("\n",fp); /* first body line is not RFC hdr */
		waskluge=0;
		fputs(buf,fp);
		if (!strncmp(buf,"---",3))
		{
			tear_off=ftell(fp);
		}
		else if (!strncmp(buf," * Origin:",10))
		{
			orig_off=ftell(fp);
			p=buf+10;
			while (*p == ' ') p++;
			if ((l=strrchr(p,'(')) && (r=strrchr(p,')')) &&
			    (l < r))
			{
				*r='\0';
				l++;
				if (o=parsefnode(l))
				{
					f.point=o->point;
					f.node=o->node;
					f.net=o->net;
					f.zone=o->zone;
					if (o->domain) f.domain=o->domain;
					o->domain=NULL;
					tidy_faddr(o);
					debug(3,"Origin from: %s",
						ascfnode(&f,0x7f));
				}
			}
			else if (*(l=buf+strlen(buf)-1) == '\n') *l='\0';
			orig=xstrcpy(p);
		}
	}
	rewind(fp);

	if (tear_off > orig_off) tear_off=orig_off;
	mkrfcmsg(&f,&t,subj,orig,mdate,flags,fp,tear_off?tear_off:via_off,kmsg);

	tidyrfc(kmsg);
	if(f.name) free(f.name); f.name=NULL;
	if(t.name) free(t.name); t.name=NULL;
	if(f.domain) free(f.domain); f.domain=NULL;
	if(t.domain) free(t.domain); t.domain=NULL;

	if (feof(pkt) || ferror(pkt)) return 2;
	return 1;
}
