#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <time.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "ftnmsg.h"
#include "rfcmsg.h"
#include "config.h"

#define PID "IFmail"

int newsmode=0;
extern char *version;

extern time_t getdate(char *,void *);
extern void registrate(char *,char *);

extern long atol(char *);
extern int stricmp(char *,char *);
extern int strincmp(char *,char *,int);
extern unsigned long sequencer(void);
extern unsigned long crc(char *);

static char *flnm[] = {
	"PVT","CRS","RCV","SNT","ATT","TRN","ORP","K/S",
	"LOC","HLD","RSV","FRQ","RRQ","RRC","ARQ","FUP"
};

void setflags(tmsg,s)
ftnmsg *tmsg;
char *s;
{
	char *buf,*p;
	int i;

	buf=xstrcpy(s);
	p=strtok(buf," ,\t\n");
	while (p)
	{
		for (i=0;i<16;i++)
			if (!stricmp(p,flnm[i]))
				tmsg->flags |= (1 << i);
		p=strtok(NULL," ,\t\n");
	}
	free(buf);
}

char *months[] = {
"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
};

char *ftndate(t)
time_t t;
{
	static char buf[32];
	struct tm *ptm;

	ptm=localtime(&t);
	sprintf(buf,"%2d %s %2d  %02d:%02d:%02d",ptm->tm_mday,
		months[ptm->tm_mon],ptm->tm_year%100,
		ptm->tm_hour,ptm->tm_min,ptm->tm_sec);
	return xstrcpy(buf);
}

char *ftnmsgid(msgid)
char *msgid;
{
	char *buf,*l,*r;
	faddr *tmp;

	if (msgid)
	{
		buf=xmalloc(strlen(msgid)+65);
		strcpy(buf,msgid);
		if (l=strchr(buf,'<')) l++;
		else l=buf;
		while (*l == ' ') l++;
		if (r=strchr(l,'>')) *r='\0';
		if (*(r=l+strlen(l)-1) == '\n') *r='\0';
		if (tmp=parsefaddr(l))
		{
			if (strspn(tmp->name,"0123456789") == strlen(tmp->name))
				sprintf(buf,"%s %08lx",ascfnode(tmp,0x1f),
					atol(tmp->name));
			else
				sprintf(buf,"%s %08lx",ascfnode(tmp,0x1f),
					crc(tmp->name));
			tidy_faddr(tmp);
			r=xstrcpy(buf);
		}
		else
		{
			if ((r=strchr(l,'@')) == NULL)
			{
				sprintf(buf,"%s %08lx",
					ascfnode(whoami->addr,0x1f),
					crc(l));
				r=xstrcpy(buf);
			}
			else
			{
				*r++='\0';
				if (strspn(l,"0123456789") == strlen(l))
					sprintf(r+strlen(r)," %08lx",atol(l));
				else 
					sprintf(r+strlen(r)," %08lx",crc(l));
				r=xstrcpy(r);
			}
		}
	}
	else
	{
		buf=xmalloc(64); /* is it really enough for normal msgid ?*/
		sprintf(buf,"%s %08lx",ascfnode(whoami->addr,0x1f),
			sequencer());
		r=xstrcpy(buf);
	}

	free(buf);
	return r;
}

void tidy_ftnmsg(tmsg)
ftnmsg *tmsg;
{
	if (tmsg == NULL) return;

	tmsg->flags=0;
	if (tmsg->to) tidy_faddr(tmsg->to); tmsg->to=NULL;
	if (tmsg->from) tidy_faddr(tmsg->from); tmsg->from=NULL;
	if (tmsg->date) free(tmsg->date); tmsg->date=NULL;
	if (tmsg->subj) free(tmsg->subj); tmsg->subj=NULL;
	if (tmsg->msgid) free(tmsg->msgid); tmsg->msgid=NULL;
	if (tmsg->reply) free(tmsg->reply); tmsg->reply=NULL;
	if (tmsg->pid) free(tmsg->pid); tmsg->pid=NULL;
	if (tmsg->origin) free(tmsg->origin); tmsg->origin=NULL;
	if (tmsg->area) free(tmsg->area); tmsg->area=NULL;
	free(tmsg);
}

ftnmsg *mkftnhdr(msg)
rfcmsg *msg;
{
	char buf[64];
	char *freename,*rfcfrom,*p,*l,*r;
	char *fbuf=NULL;
	ftnmsg *tmsg;

	tmsg=(ftnmsg *)xmalloc(sizeof(ftnmsg));

	tmsg->flags=0;
	tmsg->to=NULL;
	tmsg->from=NULL;
	tmsg->date=NULL;
	tmsg->subj=NULL;
	tmsg->msgid=NULL;
	tmsg->reply=NULL;
	tmsg->pid=NULL;
	tmsg->origin=NULL;
	tmsg->area=NULL;

	if (newsmode)
	{
		if ((p=xstrcpy(hdr("Comment-To",msg))) == NULL)
			p=xstrcpy(hdr("X-Comment-To",msg));
		if (p)
		{
			tmsg->to=parsefaddr(p);
			free(p);
		}
		else
		{
			tmsg->to=parsefaddr("All@p0.f0.n0.z0");
			tmsg->to->point=whoami->addr->point;
			tmsg->to->node=whoami->addr->node;
			tmsg->to->net=whoami->addr->net;
			tmsg->to->zone=whoami->addr->zone;
			tmsg->to->domain=xstrcpy(whoami->addr->domain);
			/* we are sure that domain was NULL */
		}
	}

	p=fbuf=xstrcpy(hdr("From",msg));
	if (fbuf == NULL)
	{
		p=fbuf=xstrcpy(hdr("X-UUCP-From",msg));
		if (p) 
		{
			while (*p == ' ') p++;
			if (l=strchr(p,' ')) *l='\0'; 
		}
	}
	if (fbuf == NULL) p=fbuf=xstrcpy("Unidentified User <postmaster>");
	if ((l=strchr(p,'<')) && (r=strchr(p,'>')) && (l < r))
	{
		*l++ = '\0';
		*r++ = '\0';
		rfcfrom=l;
		freename=p;
		debug(6,"From address: \"%s\", name: \"%s\" (angle brackets)",
			rfcfrom,freename);
	}
	else if ((l=strchr(p,'(')) && (r=strrchr(p,')')) && (l < r))
	{
		*l++ = '\0';
		*r++ = '\0';
		rfcfrom=p;
		freename=l;
		debug(6,"From address: \"%s\", name: \"%s\" (round brackets)",
			rfcfrom,freename);
	}
	else
	{
		rfcfrom=p;
		freename=p;
		debug(6,"From address: \"%s\", name: \"%s\" (no brackets)",
			rfcfrom,freename);
	}
	if (rfcfrom)
	{
		while (*rfcfrom == ' ') rfcfrom++;
		p=rfcfrom+strlen(rfcfrom)-1;
		while ((*p == ' ') || (*p == '\n')) *(p--)='\0';
	}
	if (freename)
	{
		while (*freename == ' ') freename++;
		p=freename+strlen(freename)-1;
		while ((*p == ' ') || (*p == '\n')) *(p--)='\0';
		if ((*freename == '\"') && (*(p=freename+strlen(freename)-1) == '\"'))
		{
			freename++;
			*p='\0';
		}
	}
	if (*freename == '\0') freename=rfcfrom;

	if (newsmode) debug(1,"FROM: %s <%s>",freename,rfcfrom);
	else log("from: %s <%s>",freename,rfcfrom);

	if ((tmsg->from=parsefaddr(rfcfrom)) == NULL);
	{
		if (freename && rfcfrom)
		if (!strchr(freename,'@') && 
		    !strchr(freename,'%') && 
		    stricmp(freename,rfcfrom) &&
		    strincmp(freename,"uucp",4) &&
		    strincmp(freename,"news",4) &&
		    strincmp(freename,"super",5) &&
		    strincmp(freename,"system",6)) 
			registrate(freename,rfcfrom);
	}

	debug(6,"From address was%s distinguished as ftn",
		tmsg->from ? "" : " not");

	if ((tmsg->from == NULL) && (whoami->addr))
	{
		tmsg->from=(faddr *)xmalloc(sizeof(faddr));
		tmsg->from->name=xstrcpy(freename);
		tmsg->from->point=whoami->addr->point;
		tmsg->from->node=whoami->addr->node;
		tmsg->from->net=whoami->addr->net;
		tmsg->from->zone=whoami->addr->zone;
		tmsg->from->domain=xstrcpy(whoami->addr->domain);
	}

	if (fbuf) free(fbuf); fbuf=NULL;

	p=hdr("Subject",msg);
	if (p)
	{
		while (*p == ' ') p++;
		tmsg->subj=xstrcpy(p);
		if (*(p=tmsg->subj+strlen(tmsg->subj)-1) == '\n') *p='\0';
		if (strlen(tmsg->subj) > MAXSUBJ) tmsg->subj[MAXSUBJ]='\0';
	}
	else tmsg->subj=xstrcpy(" ");

	debug(1,"SUBJ: \"%s\"",tmsg->subj);

	if (p=hdr("X-FTN-FLAGS",msg)) setflags(tmsg,p);
	if (hdr("Return-Receipt-To",msg)) tmsg->flags |= RRQ;

	tmsg->msgid=ftnmsgid(hdr("Message-ID",msg));

	if ((p=hdr("In-Reply-To",msg)) == NULL)
		p=hdr("References",msg);
	if (p) tmsg->reply=ftnmsgid(p);

	if (p=hdr("Date",msg)) 
		tmsg->date=ftndate(getdate(p,NULL));
	else tmsg->date=ftndate(time((time_t *)NULL));

	p=hdr("X-FTN-Pid",msg);
	if (p == NULL) p=hdr("Mailer",msg);
	if (p == NULL) p=hdr("X-Mailer",msg);
	if (p == NULL) p=hdr("Newsreader",msg);
	if (p == NULL) p=hdr("X-Newsreader",msg);
	if (p)
	{
		while (*p == ' ') p++;
		tmsg->pid=xstrcpy(p);
		if (*(p=tmsg->pid+strlen(tmsg->pid)-1) == '\n') *p=0;
	}
	else
	{
		sprintf(buf,"%s %s",PID,version);
		tmsg->pid=xstrcpy(buf);
	}

	debug(1,"DATE: %s, MSGID: %s, REPLY: %s, PID: %s",
		tmsg->date,tmsg->msgid,tmsg->reply,tmsg->pid);

	if (p=hdr("Organization",msg))
	{
		while (*p == ' ') p++;
		tmsg->origin=xstrcpy(p);
		if (*(p=tmsg->origin+strlen(tmsg->origin)-1) == '\n') *p='\0';
		if (strlen(tmsg->origin) > MAXORIGIN) 
			tmsg->origin[MAXORIGIN]='\0';
	}

	debug(1,"ORIGIN: %s",tmsg->origin);

	return tmsg;
}
