#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <time.h>
#include "lutil.h"
#include "xutil.h"
#include "mkrfcmsg.h"
#include "rfcmsg.h"
#include "areas.h"
#include "falists.h"
#include "config.h"

#define BOUNDARY 79

int num_echo=0,num_mail=0;
extern char *version;
extern areang_list *nglist;
extern int verbose;

extern int atoi(char *);
extern int stricmp(char *,char *);
extern int strincmp(char *,char *,int);
extern char *rfcdate(time_t);
extern long sequencer(void);
extern char *lookup(char *);

char *rfcmsgid(msgid)
char *msgid;
{
	static char buf[128],*p,*q;
	unsigned long id;
	faddr *ta=NULL;

	if (p=strrchr(msgid,' '))
	{
		*p='\0';
		sscanf(p+1,"%lx",&id);
		ta=parsefnode(msgid);
		*p=' ';
	}
	if (id != 0L)
	{
		if (ta)
		{
			if (ta->zone == 0) ta->zone=whoami->addr->zone;
			if (ta->domain == NULL) 
				ta->domain=xstrcpy(whoami->addr->domain);
			sprintf(buf,"<%lu@%s>",id,ascinode(ta,0x3f));
		}
		else
		{
			p=xstrcpy(msgid);
			if (q=strchr(p,' ')) *q='\0';
			sprintf(buf,"<%lu@%s>",id,p);
			free(p);
		}
	}
	else
	{
		sprintf(buf,"<%lu@%s>",sequencer(),ascinode(whoami->addr,0x3f));
	}
	tidy_faddr(ta);
	return buf;
}

/* check address for localness, substitute alises and replace it *in place* */

void substitute(buf)
char *buf;
{
	faddr *fa;
	fa_list *me;
	char *l,*r,*p=NULL;
	int local=0;
	int inquotes,inbrackets;

	debug(2,"to address before subst: \"%s\"",buf);
	if ((l=strchr(buf,'<')) && (r=strchr(buf,'>')) && (l < r))
	{
		l++;
		*r='\0';
	}
	else l=buf;
	while (*l == ' ') l++;
	/*if (r=strchr(l,' ')) *r='\0';*/
	for (r=l,inquotes=0,inbrackets=0;*r;r++) switch (*r)
	{
	case '"':	inquotes=(!inquotes); break;
	case ',':
	case ' ':	if (!inquotes && !inbrackets) *p='\0'; break;
	case '(':	if (!inquotes) inbrackets++; break;
	case ')':	if (!inquotes && inbrackets) inbrackets--; break;
	default:	break;
	}
	if (fa=parsefaddr(l))
	{
		for (me=whoami;me;me=me->next)
		if (	(!fa->domain || !stricmp(fa->domain,me->addr->domain)) &&
			(!fa->zone   || (fa->zone == me->addr->zone)) &&
			(fa->net == me->addr->net) &&
			(fa->node == me->addr->node) &&
			(fa->point == me->addr->point)	)
				local=1;

		if (local)
		{
			sprintf(buf,"%s",fa->name);
			if (!strchr(buf,'@') && (p=strrchr(buf,'%')))
				*p='@';
			if (!strchr(buf,'@'))
				if (p=lookup(buf))
					strcpy(buf,p);
			if (p=strchr(buf,' ')) *p='\0';
			if (!stricmp(buf,"sysop")) strcpy(buf,"postmaster");
		}
		else
		{
			sprintf(buf,"%s",ascinode(fa,0x7f));
		}
		tidy_faddr(fa);
	}
	else 
	{
		for (r=buf;*l;l++,r++) *r=*l;
		*(r+1)='\0';
	}
	if (buf[0] == '\0') strcpy(buf,"postmaster");
	debug(2,"to address after  subst: \"%s\"",buf);
	return;
}

static char *flnm[] = {
        "PVT","CRS","RCV","SNT","ATT","TRN","ORP","K/S",
        "LOC","HLD","RSV","FRQ","RRQ","RRC","ARQ","FUP"
};

/* from, to, subj, orig, mdate, flags, file, offset, kluges */

int mkrfcmsg(f,t,subj,orig,mdate,flags,fp,endoff,kmsg)
faddr *f,*t;
char *subj,*orig;
time_t mdate;
int flags;
FILE *fp;
off_t endoff;
rfcmsg *kmsg;
{
	char buf[BUFSIZ];
	char cmd[BUFSIZ];
	char *p,*l,*r,*b;
	char *newsgroup=NULL,*distribution=NULL;
	char c;
	int count,i,rrq;
	rfcmsg *msg=NULL,*tmsg;
	FILE *pip;
	int newsmode,pass,rc;
	faddr *ta;
	fa_list *ftnpath=NULL,*tfa;
	areang_list *ang;
	time_t now;

	msg=parsrfc(fp);

	if (kmsg && !strcmp(kmsg->key,"AREA"))
	{
		newsgroup=NULL;
		distribution=NULL;
		for (ang=nglist;ang && !newsgroup;ang=ang->next)
		if (!strincmp(kmsg->val,ang->area,strlen(ang->area)))
		{
			newsgroup=ang->ng;
			distribution=ang->dist;
		}
		if (!newsgroup)
		{
			log("No newsgroup for area tag %s",kmsg->val);
			tidyrfc(msg);
			return 0;
		}
		newsmode=1;
	}
	else newsmode=0;
	debug(2,"Got %s message",newsmode?"echo":"netmail");

	if (p=hdr("INTL",kmsg))
	{
		strncpy(buf,p,sizeof(buf)-1);
		l=strtok(buf," \n");
		r=strtok(NULL," \n");
		if (ta=parsefnode(l))
		{
			t->point=ta->point;
			t->node=ta->node;
			t->net=ta->net;
			t->zone=ta->zone;
			if (ta->domain);
			{
				if (t->domain) free(t->domain);
				t->domain=ta->domain;
				ta->domain=NULL;
			}
		}
		tidy_faddr(ta);
		if (ta=parsefnode(r))
		{
			f->point=ta->point;
			f->node=ta->node;
			f->net=ta->net;
			f->zone=ta->zone;
			if (ta->domain);
			{
				if (f->domain) free(f->domain);
				f->domain=ta->domain;
				ta->domain=NULL;
			}
		}
		tidy_faddr(ta);
	}

	if (p=hdr("FMPT",kmsg)) f->point=atoi(p);
	if (f->domain == NULL) f->domain=xstrcpy(whoami->addr->domain);
	if (p=hdr("TOPT",kmsg)) t->point=atoi(p);
	if (t->domain == NULL) t->domain=xstrcpy(whoami->addr->domain);

	if (!newsmode)
	{
		p=hdr("Resend-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if (p == NULL) p=hdr("RFC-Resend-To",kmsg);
		if (p == NULL) p=hdr("RFC-To",kmsg);
		if (p)
		{
			while (*p == ' ') p++;
			strncpy(buf,p,sizeof(buf)-1);
			if (*(p=buf+strlen(buf)-1) == '\n') *p='\0';
		}
		else sprintf(buf,"%s",ascinode(t,0x7f));
		substitute(buf);
		log("mail from %s to %s",ascfnode(f,0x7f),buf);
	}

	if (newsmode)
	{
		if (verbose) pip=fopen(tempnam("/tmp/ifmail","N."),"w");
		else pip=popen(inews,"w");
	}
	else
	{
		sprintf(cmd,"%s %s",sendmail,buf);
		debug(4,"popen(\"%s\",\"w\")",cmd);
		if (verbose) pip=fopen(tempnam("/tmp/ifmail","M."),"w");
		else pip=popen(cmd,"w");
	}

	if (pip == NULL)
	{
		log("$Could non popen(\"%s\",\"w\")",
			newsmode?inews:sendmail);
		tidyrfc(msg);
		return 2;
	}

	if (newsmode)
	{
		num_echo++;
		fill_list(&ftnpath,hdr("PATH",kmsg));
		fprintf(pip,"Path: ");
		if (ftnpath)
			for (tfa=ftnpath;tfa;tfa=tfa->next)
				fprintf(pip,"%s!",ascinode(tfa->addr,0x06));
		else
		{
			fprintf(pip,"%s!",ascinode(whoami->addr,0x06));
			fprintf(pip,"%s!",ascinode(f,0x06));
		}
		tidy_list(&ftnpath);
		if ((p=hdr("Path",msg)) == NULL)
			p=hdr("RFC-Path",kmsg);
		if (p)
		{
			while (*p == ' ') p++;
			fprintf(pip,"%s",p);
		}
		fprintf(pip,"%s\n",ascinode(f,0x40));

		fprintf(pip,"Newsgroups: %s\n",newsgroup);
		if (distribution)
			fprintf(pip,"Distribution: %s\n",distribution);
		if (t->name == NULL) t->name=xstrcpy("All");
		p=hdr("Comment-To",msg);
		if (p == NULL) p=hdr("X-Comment-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if (p == NULL) p=hdr("RFC-X-Comment-To",kmsg);
		if (p == NULL) p=hdr("RFC-Comment-To",kmsg);
		if (p == NULL) p=hdr("RFC-To",kmsg);
		if (p) fprintf(pip,"Comment-To:%s",p);
		else fprintf(pip,"Comment-To: %s\n",ascinode(t,0xff));
	}
	else
	{
		num_mail++;
		time(&now);
		fprintf(pip,"From %s!",ascinode(f,0x3f));
		fprintf(pip,"%s %s",ascinode(f,0x40),ctime(&mdate));
		fprintf(pip,"Received: from %s ",ascinode(f,0x3f));
		fprintf(pip,"by %s\n",ascinode(t,0x3f));
		fprintf(pip,"\twith FTN (IFmail v.%s) id AA%u; %s\n",version,
			getpid(),rfcdate(now));
		for (tmsg=msg;tmsg;tmsg=tmsg->next)
			if (!stricmp(tmsg->key,"Received"))
				fprintf(pip,"%s:%s",tmsg->key,tmsg->val);
		fprintf(pip,"Apparently-To: %s\n",buf);
		if (t->name == NULL) t->name=xstrcpy("Sysop");
		p=hdr("Resend-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if (p == NULL) p=hdr("RFC-Resend-To",kmsg);
		if (p == NULL) p=hdr("RFC-To",kmsg);
		if (p) fprintf(pip,"To:%s",p);
		else fprintf(pip,"To: %s\n",ascinode(t,0xff));
	}

	if (p=hdr("From",msg)) fprintf(pip,"From:%s",p);
	else if (p=hdr("RFC-From",kmsg)) fprintf(pip,"From: %s",p);
	else if (p=hdr("REPLYADDR",kmsg)) fprintf(pip,"From: %s",p);
	else fprintf(pip,"From: %s\n",ascinode(f,0xff));

	if (p=hdr("Date",msg)) fprintf(pip,"Date:%s",p);
	else if (p=hdr("RFC-Date",kmsg)) fprintf(pip,"Date: %s",p);
	else fprintf(pip,"Date: %s\n",rfcdate(mdate));

	if (p=hdr("Subject",msg)) fprintf(pip,"Subject:%s",p);
	else if (p=hdr("RFC-Subject",kmsg)) fprintf(pip,"Subject: %s",p);
	else fprintf(pip,"Subject: %s\n",subj);

	if (p=hdr("Message-ID",msg)) fprintf(pip,"Message-ID:%s",p);
	else if (p=hdr("RFC-Message-ID",kmsg)) fprintf(pip,"Message-ID: %s",p);
	else if (p=hdr("MSGID",kmsg)) fprintf(pip,"Message-ID: %s\n",rfcmsgid(p));
	else fprintf(pip,"Message-ID: <%lu@%s>\n",mdate,
			ascinode(f,0x3f));

	if (newsmode)
	{
		p=hdr("References",msg);
		if (p == NULL) p=hdr("RFC-References",kmsg); 
		if (p) fprintf(pip,"References:%s",p);
		else 
		{
			if (p=hdr("REPLY",kmsg))
				fprintf(pip,"References: %s\n",rfcmsgid(p));
		}
	}
	else
	{
		p=hdr("In-Reply-To",msg);
		if (p == NULL) p=hdr("RFC-In-Reply-To",kmsg);
		if (p) fprintf(pip,"In-Reply-To:%s",p);
		else 
		{
			if (p=hdr("REPLY",kmsg))
				fprintf(pip,"In-Reply-To: %s\n",rfcmsgid(p));
		}
	}

	for (tmsg=msg;tmsg;tmsg=tmsg->next)
	{
		if (stricmp(tmsg->key,"X-Body-Start") &&
		    stricmp(tmsg->key,"Path") &&
		    stricmp(tmsg->key,"Received") &&
		    stricmp(tmsg->key,"From") &&
		    stricmp(tmsg->key,"To") &&
		    stricmp(tmsg->key,"Comment-To") &&
		    stricmp(tmsg->key,"Date") &&
		    stricmp(tmsg->key,"Subject") &&
		    stricmp(tmsg->key,"In-Reply-To") &&
		    stricmp(tmsg->key,"Message-ID"))
			fprintf(pip,"%s:%s",tmsg->key,tmsg->val);
	}

	if (p=hdr("X-FTN-FLAGS",msg)) strncpy(buf,p,sizeof(buf)-(4*16)-1);
	else buf[0]='\0';
	if (*(p=buf+strlen(buf)-1) == '\n') *p='\0';
	for (i=0;i<16;i++) if (flags & (1 << i))
	{
		for (p=buf;*p;p++) if (!strincmp(p,flnm[i],3)) break;
		if (*p == '\0') sprintf(p," %s",flnm[i]);
	}
	if (buf[0]) fprintf(pip,"X-FTN-FLAGS:%s\n",buf);
	rrq=0;
	for (p=buf;*p;p++) if (!strincmp(p,flnm[12],3)) rrq=1;
	if (rrq && !hdr("RFC-Return-Receipt-To",kmsg) && 
	    !hdr("Return-Receipt-To",msg))
	{
		if (p=hdr("REPLYADDR",kmsg)) fprintf(pip,"Return-Receipt-To:%s",p);
		else fprintf(pip,"Return-Receipt-To: %s\n",ascinode(f,0x7f));
	}

	for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
	{
		if (stricmp(tmsg->key,"INTL") &&
		    stricmp(tmsg->key,"FMPT") &&
		    stricmp(tmsg->key,"TOPT") &&
		    stricmp(tmsg->key,"REPLY") &&
		    stricmp(tmsg->key,"MSGID") &&
		    stricmp(tmsg->key,"FLAGS") &&
		    stricmp(tmsg->key,"RFC-Path") &&
		    stricmp(tmsg->key,"RFC-Received") &&
		    stricmp(tmsg->key,"RFC-From") &&
		    stricmp(tmsg->key,"RFC-To") &&
		    stricmp(tmsg->key,"RFC-Comment-To") &&
		    stricmp(tmsg->key,"RFC-Date") &&
		    stricmp(tmsg->key,"RFC-Subject") &&
		    stricmp(tmsg->key,"RFC-In-Reply-To") &&
		    stricmp(tmsg->key,"RFC-Message-ID"))
			if (!strncmp(tmsg->key,"RFC-",4))
				fprintf(pip,"%s: %s",tmsg->key+4,tmsg->val);
			else
				fprintf(pip,"X-FTN-%s: %s",tmsg->key,tmsg->val);
	}

	fprintf(pip,"\n");
	if (p=hdr("X-Body-Start",msg)) fputs(p,pip);
	pass=1;
	count=0;
	b=NULL;
	while(fgets(buf,sizeof(buf)-1,fp))
	{
		if (!strncmp(buf,"--- ",4) ||
		    !strncmp(buf," * Origin:",10) ||
		    !strncmp(buf,"Via:",4))
			if (ftell(fp) >= endoff) pass=0;
		if (pass)
		{
			p=buf;
			while (c=*p++)
			{
				switch (c)
				{
				case ' ':	b=p-1; break;
				case '\n':	count=0; break;
				}
				if (count++ > BOUNDARY)
				{
					if (b) 
					{
						*b='\n';
						p=b+1;
						b=NULL;
					}
					count=0;
				}
			}
			fputs(buf,pip);
		}
	}

	if (rc=fclose(pip))
	{
		log("$fclose of transport pipe returned %d",rc);
	}
	tidyrfc(msg);
	return rc;
}
