#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#define LCK "/usr/spool/uucp/LCK.."
#define TMP "/usr/spool/uucp/TMP."

extern int verbose;

lock(line)
char *line;
{
	int	mypid,rempid;
	char	tmpname[256],lckname[256];
	char	*p;
	int	i,rc;
	FILE	*f;

	rc=-1;
	if ((p=strrchr(line,'/')) == NULL) p=line; else p++;
	mypid=getpid();
	sprintf(tmpname,"%s%d",TMP,mypid);
	if ((f=fopen(tmpname,"w")) == NULL)
	{
		debug(2,"lock cannot create %s");
		return(-1);
	}
	fprintf(f,"%10d\n",mypid);
	fclose(f);
	chmod(tmpname,0444);
	sprintf(lckname,"%s%s",LCK,p);
	p=lckname+strlen(lckname)-1;
	*p=tolower(*p);
	debug(4,"Trying to create %s for %d",lckname,mypid);
	for (i=0; (i++<5) && ((rc=link(tmpname,lckname)) != 0) && 
				(errno == EEXIST); )
	{
		if ((f=fopen(lckname,"r")) == NULL)
		{
			debug(2,"cannot open existing lock file");
		}
		else
		{
			fscanf(f,"%d",&rempid);
			fclose(f);
			debug(2,"lock file read for process %d",rempid);
		}
		if (kill(rempid,0) && (errno ==  ESRCH))
		{
			debug(2,"process inactive, unlink file");
			unlink(lckname);
		}
		else
		{
			debug(2,"process active, sleep a bit");
			sleep(2);
		}
	}
	unlink(tmpname);
	debug(2,"lock result %d (errno %d)",rc,errno);
	return(rc);
}

ulock(line)
char *line;
{
	int	mypid,rempid;
	char	tmpmane[256],lckname[256];
	char	*p;
	int	rc;
	FILE	*f;

	rc=-1;
	if ((p=strrchr(line,'/')) == NULL) p=line; else p++;
	mypid=getpid();
	sprintf(lckname,"%s%s",LCK,p);
	p=lckname+strlen(lckname)-1;
	*p=tolower(*p);
	f=fopen(lckname,"r");
	fscanf(f,"%d",&rempid);
	fclose(f);
	if (rempid ==  mypid)
		rc=unlink(lckname);
	return(rc);
}
