
/*
** Copyright 1992
** Patrick Sweeney
*/
#ifndef define_SCRIPT
#define define_SCRIPT

#include <stdio.h>
#include "ll2.h"
#ifndef _POSIX_SOURCE
#include "nonposix.h"
#endif

#define MAX_SYSNAME	15
#define MAX_PHONE	80
#define MAX_MODEMSTR	80
#define MAX_DIALER	80

typedef enum {
    ENTRY_EXPECT,
    ENTRY_LOCAL,
    ENTRY_REMOTE
} script_t;

typedef struct {
    script_t type;
    union {
	struct {
	    char *recv;
	    char *send;
	    char *err_send;
	}
	expect;
	struct {
	    int wait;
	    char *cmd;
	}
	exec;
    }
    v;
}

Scriptentry;

typedef struct {
    char system_name[MAX_SYSNAME];
    char phone1[MAX_PHONE];
    char phone2[MAX_PHONE];
    int baudrate;
    char dialer[MAX_DIALER];
    int timeout;		/* timeout in seconds */
    int retries;		/* number of times to rety */
    Scriptentry *entries;
    int nentries;
    int maxentries;
}

System;

typedef struct {
    char name[MAX_DIALER];
    char dialstr[MAX_MODEMSTR];
    char dialstr_r[MAX_MODEMSTR];
    char resetstr[MAX_MODEMSTR];
    char resetstr_r[MAX_MODEMSTR];
    char hangupstr[MAX_MODEMSTR];
    char hangupstr_r[MAX_MODEMSTR];
    int stopbits;
    int databits;
    char device[FILENAME_MAX];
}

Modem;

typedef struct {
    Ll2 *syslist;
    Ll2 *modems;
} Systeminfo;

#define SCRIPT_NAME "fetrc"
#define SCRIPT_ENTRIES 10	/* initial number of script entries */

extern int script_parse(char *fn, Systeminfo * info);

#endif				/* define_SCRIPT */
