/* make_database.c */

/* make_database() - called when user clicks "Conferences" button on
 *                   main xnetlib form
 * Popup_database() -
 * Popupdown_database() -
 * databaseCancel() -
 * databaseCleanup() -
 */

#include "database.h"

char DATABASE_INTRO[] = "\n\
Welcome to the Xnetlib database of conferences.\n\n\
You may submit information about an upcoming conference, or you\n\
may search for information about conferences in the database. \n\n\
When you submit a conference, information in the title,\n\
description, and location fields will automatically be\n\
added to a keyword index. \n\n\
You may search by entering a combination of zero or more of\n\
the following types of search strings:\n\n\
  - a boolean keyword string using the operators & (for and)\n\
    | (for or) and ! (for not) and parentheses for precedence,\n\
    for searching the title and description fields.  Blanks and\n\
    commas are interpreted as logical and.\n\n\
  - from and to dates in the form mmm dd yyyy (example - Jan 1 1993)\n\
    (Most other date formats are also acceptable).\n\n\
  - a boolean keyword string for searching the location field\n\
    (Note that it does not make sense to use & in a location search.)\n\n\
Conditions entered simultaneously for different types of queries\n\
will be logically anded.  Specifying nothing will retrieve all\n\
records in the database.\n\n\
Send comments, suggestions, and bug reports to conferences@netlib.ornl.gov\n\n\
-SVB\n\
";

char SEARCH_HELP[] = "\n\
You may search by entering a combination of zero or more of\n\
the following types of search strings:\n\n\
  - a boolean keyword expression using the operators & (for and)\n\
    | (for or) and ! (for not) and parentheses for precedence,\n\
    for searching the title and description fields.  Blanks and\n\
    commas are interpreted as logical and.  You may restrict the\n\
    keyword search to only the title field or only the description\n\
    field by using the \"Modify Search\" button.\n\n\
    examples: parallel | network\n\
              parallel !(linear algebra)\n\n\
  - from and to dates in the form mmm dd yyyy (example - Jan 1 1993)\n\
    (Most other date formats are also acceptable).\n\
    If the from date is null, it will default to the earliest\n\
    possible date.  Likewise, a null to date defaults to the\n\
    latest possible date.\n\n\
  - a boolean keyword expression for searching the location field\n\
    (Note that it does not make sense to use & in a location search.)\n\n\
    examples: !usa | california) \n\
              europe | north america\n\n\
Keyword searching is case-insensitive.\n\
Conditions entered simultaneously for different types of queries\n\
will be logically anded.  Specifying nothing will retrieve all\n\
records in the database.\n\n\
After executing a search, you may select conferences by clicking\n\
on their file icons.  Descriptions for the selected conferences\n\
may be retrieved by clicking on the \"Retrieve conference descriptions\"\n\
button.  Alternatively, conference descriptions may be downloaded\n\
in the usual xnetlib manner by clicking on the \"Download\" button.\n\n\
-SVB\n\
";

char databaseValue[MAXLINE];
char DATABASE_FILE[MAXLINE], TMP[MAXLINE];

Widget searchToggles[2];

Boolean search_mask[2][2];

Widget databaseLabel, enterText,
	databaseSaveDialog, databaseReadDialog,
        descsaveSaveDialog,
        databaseChangeDialog,
        databaseSubmitOkDialog,
        databaseSubmitFailedDialog,
	saveButton, addButton, searchhelpButton,readButton,
        changeButton,
        executeButton, clearButton, modifyButton,
        descrecvButton, nextdescButton,
	toText, fromText, locationText,
        cancelButton,
        databaseDisplayView;
Widget typeLabel, normalAndButton, normalOrButton, literalButton,
    literalCaseButton, fuzzyButton;
XtTranslations trans;
char text_trans[] = "<Btn1Down>,<Btn1Up>:  set() notify()";

Boolean click = True;
int databaseSocket;
XtInputId databaseInput = (XtInputId) NULL;

void databaseCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_DATABASE;
}

make_database(w)
Widget w;
{
    static char text_translations[] = "<Key>Return: do_database() ";
    Arg args[20];
    XtTranslations translations;
    register int n;
    Dimension height;
	Widget last, dateLabel;

	strcpy(DatabaseServer, DATABASESERVER);

    con_help[MODE_DATABASE] = DATABASE_INTRO;

    strcpy(databaseValue, " ");

    nextdescButton = NULL;

    databaseInput = (XtIntervalId)NULL;
    databaseSocket =  (int) NULL;
    search_mask[SEARCH][TITLE] = True;
    search_mask[SEARCH][DESCRIPTION] = True;

    trans = XtParseTranslationTable(text_trans);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(exitButton, args, 1);

    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, height*5 +10); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNallowResize, True); n++;
    databaseForm = XtCreateManagedWidget("searchForm", formWidgetClass,
        topPane, args, n);

 /*   XtSetArg(args[n], XtNbottom, XtChainTop); n++;
    XtSetArg(args[n], XtNtop, XtChainTop); n++;   
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainRight); n++; */

    n = 0;
    XtSetArg(args[n], XtNlabel, "Keyword expression:  "); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    typeLabel = XtCreateManagedWidget("searchTypeLabel",
        labelWidgetClass, databaseForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, typeLabel); n++;
    XtSetArg(args[n], XtNwidth,
       MAX(10, XNL_WIDTH - 3*(xtw(databaseButton,"Search for:") +9))); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);            n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;

    enterText = XtCreateManagedWidget("enterText",
        asciiTextWidgetClass, databaseForm, args, n);

    translations = XtParseTranslationTable(text_translations);
    XtOverrideTranslations(enterText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, enterText); n++;
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNlabel, "Cancel"); n++;
    cancelButton = XtCreateManagedWidget("cancel",
        commandWidgetClass, databaseForm, args, n);
    setfasthelpmessage( cancelButton, "cancel database request");

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, cancelButton); n++;
    XtSetArg(args[n], XtNlabel, "Help"); n++;
    searchhelpButton = XtCreateManagedWidget("searchhelp",
        commandWidgetClass, databaseForm, args, n);
    setfasthelpmessage( searchhelpButton, "instructions on how to enter search criteria");

	n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Dates:  from "); n++;
    last = XtCreateManagedWidget("Dates", labelWidgetClass, databaseForm,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNwidth, 100); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                 n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    fromText = last = XtCreateManagedWidget("fromText", asciiTextWidgetClass, 
		databaseForm, args, n);
    XtOverrideTranslations(fromText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, " to "); n++;
    dateLabel = XtCreateManagedWidget("DatesTo", labelWidgetClass, databaseForm,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, dateLabel); n++;
    XtSetArg(args[n], XtNwidth, 100); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);             n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    toText = last = XtCreateManagedWidget("toText", asciiTextWidgetClass, 
        databaseForm, args, n);
    XtOverrideTranslations(toText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Location: "); n++;
    last = XtCreateManagedWidget("Location", labelWidgetClass,
           databaseForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNwidth, 250); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);             n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    locationText = last = XtCreateManagedWidget("locationText", 
                asciiTextWidgetClass, 
		databaseForm, args, n);
    XtOverrideTranslations(locationText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, dateLabel); n++;
    executeButton = last = XtCreateManagedWidget("Execute search",
                commandWidgetClass, 
		databaseForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, dateLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, executeButton); n++;
    clearButton = last = XtCreateManagedWidget("Clear",commandWidgetClass, 
		databaseForm, args, n);
    setfasthelpmessage( clearButton, "reset all search fields to null");

    n = 0;
    XtSetArg(args[n], XtNfromVert, dateLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, clearButton); n++;
    modifyButton = last = XtCreateManagedWidget("Modify search",
                commandWidgetClass, 
		databaseForm, args, n);
    setfasthelpmessage( modifyButton, "change keyword search fields");

    n = 0;
    XtSetArg(args[n], XtNfromVert, dateLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, modifyButton); n++;
    XtSetArg(args[n], XtNx, 30); n++;
    saveButton = last = XtCreateManagedWidget("Save", commandWidgetClass, 
		databaseForm, args, n);
    setfasthelpmessage( saveButton, "save window contents to a file");


    n = 0;
    XtSetArg(args[n], XtNfromVert, dateLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, saveButton); n++;
 /*   XtSetArg(args[n], XtNsensitive, False); n++;  */
    XtSetArg(args[n], XtNlabel, "Retrieve conference descriptions"); n++;
    descrecvButton= last = XtCreateManagedWidget("descrecvButton",
                commandWidgetClass, databaseForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, clearButton); n++;
    XtSetArg(args[n], XtNlabel, "Add a conference to the database"); n++;
    addButton= last = XtCreateManagedWidget("addButton", 
                commandWidgetClass, 
		databaseForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, clearButton); n++;
    XtSetArg(args[n], XtNfromHoriz, addButton); n++;
    XtSetArg(args[n], XtNlabel, "Modify a conference listing"); n++;
	changeButton= last = XtCreateManagedWidget("changeButton", 
                commandWidgetClass, 
		databaseForm, args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(databaseForm, args, 1);

    XawPanedSetMinMax(databaseForm, height, height);

    n = 0;
    XtSetArg(args[n], XtNstring, DATABASE_INTRO); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
    databaseDisplayText = XtCreateManagedWidget("searchText",
            utkasciiTextWidgetClass, topPane, args, n);


    XtAddCallback(cancelButton, XtNcallback, databaseCancel, 
                  (XtPointer)NULL);
    XtAddCallback(saveButton, XtNcallback, saveButtonCB, (XtPointer)NULL);
    XtAddCallback(clearButton, XtNcallback, clearButtonCB, 
                  (XtPointer)NULL);
    XtAddCallback(changeButton, XtNcallback, changeButtonCB, 
                  (XtPointer)NULL);
    XtAddCallback(modifyButton, XtNcallback, modifyButtonCB, 
                  (XtPointer)NULL);
    XtAddCallback(executeButton, XtNcallback, do_database, 
                  (XtPointer)NULL);
    XtAddCallback(addButton, XtNcallback, addButtonCB, (XtPointer)NULL);
    XtAddCallback(descrecvButton, XtNcallback, descrecvCB, 
                  (XtPointer)NULL);
    XtAddCallback(searchhelpButton, XtNcallback, searchhelpButtonCB, 
                  (XtPointer)NULL);

    strcpy(DATABASE_FILE, tmpnam(NULL));

    return 1;
}

Popdown_database(w)
Widget w;
{
    grey_the_button(databaseButton, True);
    grey_the_button(receiveButton, True);

    XtUnmanageChild(databaseForm);
    XtUnmanageChild(databaseDisplayText);

    currentDisplayText = NULL;

    if (databaseSocket)
        netlib_abort(databaseSocket);
    return 1;
}

Popup_database(w)
Widget w;
{
    Arg args[20];

    register int n;
    FILE *fp;

    LibOrClass = Mode = MODE_DATABASE;

    grey_the_button(databaseButton, False);


    XtManageChild(databaseForm);

    /* first destroy the old child */
    XtManageChild(databaseDisplayText);

    currentDisplayText = databaseDisplayText;

    if (!(DONT_WARP))
      XWarpPointer(XtDisplay(toplevel), None, XtWindow(enterText),
        0,0,0,0, 5,5);

    set_status(DATABASE_HEADER, GREEN);

    return 1;

}

void
databaseCancel(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[4];

	if (databaseInput) {
        XtRemoveInput(databaseInput);
        databaseInput = (XtInputId)NULL;

        /* put things back in place */
        XtSetArg(args[0], XtNeditType, XawtextEdit);
        XtSetArg(args[1], XtNinsertPosition, 0);
        XtSetValues(databaseDisplayText, args, 2);

        grey_the_button(cancelButton, False);
        set_cursor(CURSOR_NORMAL, 0);
        set_cursor(CURSOR_NORMAL_XTERM, enterText);
        set_cursor(CURSOR_NORMAL_XTERM, databaseDisplayText);
        set_cursor(CURSOR_NORMAL_XTERM, fromText);
        set_cursor(CURSOR_NORMAL_XTERM, toText);
        set_cursor(CURSOR_NORMAL_XTERM, locationText);
        grey_the_bar(True);
        close(databaseSocket);
        databaseSocket = (int) NULL;

        set_status("done", GREEN);

        set_cursor(CURSOR_NORMAL, 0);
        set_cursor(CURSOR_NORMAL_XTERM, enterText);
        grey_the_bar(True);
        grey_the_button(cancelButton, False);
        grey_the_button(databaseButton, False);
	}
}

databaseCleanup()
{
    unlink(DATABASE_FILE);
}

