/*
** Chronology exam grading program.
** owen astrachan (i/o adapted from richard hipp's program)
** 1991 November 20
*/
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#define MAXQ  20        /* Maximum number of test questions */


int readrow(int *buf, int nq){
  int i;
  int v = -1;
  int c;
  int check[MAXQ];
  for(i=0; i<MAXQ; i++) check[i] = 0;
  i = 0;
  while( i<nq ){
    c = getchar();
    if( c==EOF ){
      if( i==0 ) return 0;
      fprintf(stderr,"End of file before end of line.\n");
      exit(1);
    }else if( isspace(c) ){
      if( v>0 && v<=nq ){
        buf[i++] = v;
        check[v-1]++;
      }else if( v>=0 ){
        fprintf(stderr,"Illegal number on input: %d\n",v);
        exit(1);
      }
      if( c=='\n' && i<nq ){
        fprintf(stderr,"Too few number on input line.\n");
        exit(1);
      }
      v = -1;
    }else if( isdigit(c) ){
      if( v<0 )    v = c - '0';
      else         v = v*10 + c - '0';
    }else{
      fprintf(stderr,"Illegal character: %c\n",c);
      exit(1);
    }
  }
  while( c!=EOF && c!='\n' ){
    if( isdigit(c) ){
      fprintf(stderr,"Too many numbers on one input line.\n");
      exit(1);
    }
    c = getchar();
  }
  for(i=0; i<nq; i++){
    if( check[i]!=1 ){
      fprintf(stderr,"The number %d occurs %d times.\n",i+1,check[i]);
      exit(1);
    }
  }
  return 1;
}

setchars(s1, s2, pattern)
char *s1, *s2;
int pattern;
{
	int i;

	for(i = 0 ; pattern ; i++) {
		if (pattern & 1) {
			*s2++ = s1[i];
		}
		pattern = pattern >> 1;
	}
	*s2 = 0;
}
	  

contains(set, subset)
char *set, *subset;
{
	for (;*set && *subset ; set++) {
		if (*set == *subset) {
			subset++;
		}
	}
	return *subset == 0;
}

void main(void){
  int  nq;              /* Number of test questions */
  int  key[MAXQ];       /* The key */
  int  ans[MAXQ];       /* A student's answer */
  char master[MAXQ+1], str[MAXQ+1], attempt[MAXQ+1];
  int  i;             /* Loop counters */
  int max;

  if( scanf("%d\n",&nq)!=1 ){
    fprintf(stderr,"Input file format error.\n");
    exit(1);
  }
  if( nq<2 || nq>MAXQ ){
    fprintf(stderr,"Illegal problem size: %d\n",nq);
    exit(1);
  }
  readrow(key,nq);
  
  for(i=0; i<nq; i++) master[i] = key[i]+'a';
  master[nq] = 0;
  while( readrow(ans,nq) ){
    for(i=0; i<nq; i++) str[i] = ans[i] + 'a';
    str[nq] = 0;
    
    max = 1;
    for(i=0; (i & (1 << nq)) == 0; i++) {
	    setchars(str, attempt, i);
	    if (strlen(attempt) > max && contains(master, attempt) != 0) {
		    max = strlen(attempt);
	    }
    }
    printf("%d\n",max);

  }

  exit(0);
}
