/*
** Chronology exam grading program.
** owen astrachan (i/o adapted from richard hipp's program)
** 1991 November 20
*/
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#define MAXQ  20        /* Maximum number of test questions */


#define CHRONO(x,y,z,w)    ((x-y)*(z-w) > 0 ? 1 : 0)


int readrow(int *buf, int nq){
  int i;
  int v = -1;
  int c;
  int check[MAXQ];
  for(i=0; i<MAXQ; i++) check[i] = 0;
  i = 0;
  while( i<nq ){
    c = getchar();
    if( c==EOF ){
      if( i==0 ) return 0;
      fprintf(stderr,"End of file before end of line.\n");
      exit(1);
    }else if( isspace(c) ){
      if( v>0 && v<=nq ){
        buf[i++] = v;
        check[v-1]++;
      }else if( v>=0 ){
        fprintf(stderr,"Illegal number on input: %d\n",v);
        exit(1);
      }
      if( c=='\n' && i<nq ){
        fprintf(stderr,"Too few number on input line.\n");
        exit(1);
      }
      v = -1;
    }else if( isdigit(c) ){
      if( v<0 )    v = c - '0';
      else         v = v*10 + c - '0';
    }else{
      fprintf(stderr,"Illegal character: %c\n",c);
      exit(1);
    }
  }
  while( c!=EOF && c!='\n' ){
    if( isdigit(c) ){
      fprintf(stderr,"Too many numbers on one input line.\n");
      exit(1);
    }
    c = getchar();
  }
  for(i=0; i<nq; i++){
    if( check[i]!=1 ){
      fprintf(stderr,"The number %d occurs %d times.\n",i+1,check[i]);
      exit(1);
    }
  }
  return 1;
}

void
permute(int *a, int*b, int nq)
{
    int i,j;
    for(i=1;i<=nq;i++){
	for(j=0;j<nq;j++){
	    if (a[j] == i){
		b[i-1] = j+1;
		break;
	    }
	}
    }
}

    
void main(void){
  int  nq;              /* Number of test questions */
  int  key[MAXQ];       /* The key */
  int  ans[MAXQ];       /* A student's answer */
  int  m[MAXQ][MAXQ];
  char master[MAXQ+1], str[MAXQ+1];
  int  i,j,k;             /* Loop counters */
  int temp,max,max1,max2;
  int sum1,sum2,count;

  int ans1[MAXQ];


  sum1 = sum2 = count = 0;
  
  if( scanf("%d\n",&nq)!=1 ){
    fprintf(stderr,"Input file format error.\n");
    exit(1);
  }
  if( nq<2 || nq>MAXQ ){
    fprintf(stderr,"Illegal problem size: %d\n",nq);
    exit(1);
  }
  readrow(key,nq);
  
  for(i=0; i<nq; i++) master[key[i]-1] = 'a'+i;
  master[nq] = 0;
  while( readrow(ans,nq) ){
    permute(ans,ans1,nq);
    for(i=0; i<nq; i++) str[ans[i]-1] = 'a'+i;
    str[nq] = 0;
    
    for(i=0; i<nq; i++) 
        for(j=0; j<nq; j++) {
            m[i][j] = i==j ? 1 : 0;
	}

    for(j=1;j<nq;j++){
	for(i=0;i<nq-j;i++){
	    max = 0;
	    for(k=i;k<i+j;k++){
		if (m[i][k]){
		    temp = key[ans1[i+j]-1] > key[ans1[k]-1] ?
			m[i][k] + 1 : 0;
		    if (temp > max)
			max = temp;		    
		}
	    }
	    m[i][i+j] = max;
	}
    }
    max1 = 0;
    for(i=0;i<nq;i++){
	for(j=i;j<nq;j++){
	    if (m[i][j] > max1)
		max1 = m[i][j];
	}
    }
    
    sum1 += max1;
    

    printf("%d\n",max1);

  }

  exit(0);
}
