program poker;

#include "str.h"

const
   d=false;
   usefile=false;

type
   card=record
      r:integer;
      s:char;
      end;
   cards=array[0..4] of card;

var
   fn:string;
   h,hand,deck:cards;
   best:integer;
   line:string;
   l,p:integer;
   ranks:string;

procedure stop;
begin
writeln;
writeln('Press return...');
readln;
halt;
end;

function bitset(i, j:integer) : boolean;
{ is bit j (in range 0..31) set? }
var
   k : integer;
begin
for k := 0 to j-1 do
   i := i div 2;
bitset := i mod 2 = 1;
end;

procedure ph(h:cards);
var
   i:integer;
begin
for i:=0 to 4 do
   write(ranks[h[i].r+1],h[i].s,' ');
end;

procedure geth(var h:cards);
var
   i:integer;
   c:char;
begin
for i:=0 to 4 do begin
   c:=line[p];
   h[i].r:=pos(c,ranks)-1;
   h[i].s:=line[p+1];
   p:=p+3;
   end;
end;

procedure inp;
begin
readln(line);
p:=1;
l:=length(line);
geth(hand);
geth(deck);
end;

procedure out(v:integer);
begin
case v of
   9:write('straight-flush');
   8:write('four-of-a-kind');
   7:write('full-house');
   6:write('flush');
   5:write('straight');
   4:write('three-of-a-kind');
   3:write('two-pairs');
   2:write('one-pair');
   1:write('highest-card');
   end;
end;

procedure aceh;
var
   i:integer;
begin
for i:=0 to 4 do if h[i].r=0 then h[i].r:=13;
end;

procedure sbr;
var
   k,i,j:integer;
   c:card;
begin
for i:=4 downto 1 do begin
   k:=0;
   for j:=1 to i do
      if h[j].r>h[k].r then
         k:=j;
   c:=h[i];
   h[i]:=h[k];
   h[k]:=c;
   end;
end;

function samesuit(a,b:integer):boolean;
var
   s:char; i:integer; r:boolean;
begin
s:=h[a].s;
r:=true;
for i:=a+1 to b do r:=r and (s=h[i].s);
samesuit:=r;
end;

function inseq(a,b:integer):boolean;
var
   r:boolean; i:integer;
begin
r:=true;
for i:=a to b-1 do r:=r and (h[i].r=h[i+1].r-1);
inseq:=r;
end;

function samerank(a,b:integer):boolean;
var
   rr:integer; i:integer; r:boolean;
begin
rr:=h[a].r;
r:=true;
for i:=a+1 to b do r:=r and (rr=h[i].r);
samerank:=r;
end;

function isSF:boolean;
begin
isSF:=samesuit(0,4) and inseq(0,4);
end;

function is4OAK:boolean;
begin
is4OAK:=samerank(0,3) or samerank(1,4);
end;

function isFH:boolean;
begin
isFH:=(samerank(0,1) and samerank(2,4)) or (samerank(0,2) and samerank(3,4));
end;

function isF:boolean;
begin
isF:=samesuit(0,4);
end;

function isS:boolean;
begin
isS:=inseq(0,4);
end;

function is3OAK:boolean;
begin
is3OAK:=samerank(0,2) or samerank(1,3) or samerank(2,4);
end;

function is2P:boolean;
var
   i,j:integer;
   res:boolean;
begin
res:=false;
for i:=0 to 1 do
   for j:=i+2 to i+3 do
      if samerank(i,i+1) and samerank(j,j+1) then begin
         res:=true;
         end;
is2P:=res;
end;

function is1P:boolean;
var
   i:integer;
   res:boolean;
begin
res := false;
for i:=0 to 3 do
   if samerank(i,i+1) then begin
      res:=true;
      end;
is1P:=res;
end;

procedure check;
var
   v:integer;
begin
if isSF then v:=9
else if is4OAK then v:=8
else if isFH then v:=7
else if isF then v:=6
else if isS then v:=5
else if is3OAK then v:=4
else if is2P then v:=3
else if is1P then v:=2
else v:=1;
if v>best then best:=v;
if d then begin
   ph(h); out(v); write(' ');
   end;
end;

procedure play;
var
   v,i,j,k:integer;
   h2:cards;
begin
while not eof do begin
   inp;
   best:=0;
   for i:=0 to 31 do begin
      if d then write(i:2,' ');
      h2:=hand;
      k:=0;
      for j:=0 to 4 do begin
         if bitset(i,j) then begin
            h2[j]:=deck[k];
            k:=k+1;
            end;
         end;
      h:=h2; sbr; check;
      aceh; sbr; check;
      if d then readln;
      end;
   write('Hand: '); ph(hand); write('Deck: '); ph(deck);
   write('Best hand: ');
   out(best);
   writeln;
   end;
end;

begin
ranks:='A23456789TJQKA';
play;
end.
