PROGRAM TelephoneTangles;  {Problem H - 1990}
CONST namelength = 25;
      tellength = 15;

#include "str.h"

TYPE telno = string;
     name  = string;
     telrec = record
                stdcode : telno;
                place : name;
                cost : integer end;

VAR table : array[0..100] of telrec;
    i,N : integer;
    line : string;
    tn : telno;
    done : Boolean;
    duration : integer;

PROCEDURE GetStdCode;
begin
readln(line); i := 1; tn := '';
while line[i] in ['0'..'9'] do begin
  tn := tn + line[i]; i := i + 1 end;
done := (tn = '000000');
end;

PROCEDURE ReadTable;
VAR i,j : integer;
begin
GetStdCode;
while not done do begin
  N := N + 1;
  with table[N] do begin
    stdcode := tn;
    i := Pos(' ', line)+1; j := Pos('$', line) - i;
    place := Copy(line, i, j);
    while length(place) < namelength do place := place + ' ';
    line := copy(line, Pos('$',line)+1, 25);
    valint(line, cost, i);
    end;
  GetStdCode end;
end;

PROCEDURE SortTable;
VAR i,j : integer;
    x : telrec;

begin
with table[0] do begin
  place := 'Unknown'; while length(place) < namelength do place := place + ' ';
  stdcode := ''; cost := -100 end;
for i := 2 to N do begin
  x := table[i]; j := i-1;
  while length(x.stdcode) < length(table[j].stdcode) do begin
    table[j+1] := table[j]; j := j-1 end;
  table[j+1] := x;
  end;
end;


PROCEDURE ReadNextCall;
var
    temp:string;
begin
readln(line); done := line[1] = '#';
if not done
  then begin
    i := 1; tn := '';
    while line[i] in ['0'..'9'] do begin
      tn := tn + line[i]; i := i + 1 end;
    temp := Copy(line,i,length(line) - i + 1);
    valint(temp, duration, i);
    end;
end;

PROCEDURE ProcessCalls;
VAR i,j : integer;
    std,nbr : telno;
    cost : integer;

begin
ReadNextCall;
while not done do begin
  if tn[1] = '0'
    then begin
      table[0].stdcode := tn; i := N;
      while pos(table[i].stdcode, tn) <> 1 do i := i - 1;
      std := table[i].stdcode; cost := table[i].cost;
      nbr := tn; Delete(nbr, 1, length(std));
      while length(tn) < tellength do tn := tn + ' ';
      for j := 1 to tellength do
         begin
	 if j <= length(tn) then
	     write(tn[j])
	 else
	     write(' ');
	 end;
      write(' ', table[i].place, nbr:tellength-5, duration:5);
      if i <> 0
        then writeln(cost/100:6:2,(cost*duration)/100:7:2)
        else writeln(' ':6, -1.00:7:2); 
      end
    else begin
      write(tn);
      for i := length(tn) to tellength do write(' ');
      writeln('Local', tn:tellength+namelength-10,duration:5,0.00:6:2,0.00:7:2);
      end;
  ReadNextCall end;
end;

begin
N := 0;
ReadTable;
SortTable;
ProcessCalls;
end.
