Program ProblemA (input, output);

Const
   MAX = 8;

#include "str.h"

Var
   line : string;
   seen, best : string;
   best_band, semi, colon, i, p, loop : integer;
   vertex : array ['A'..'Z'] of record
      edges : string;
      match : set of char;
      end;
   first, ch : char;
   test : integer;

Procedure scan (
   used : string;
   var unused : string;
   worst : integer);

   Var
      i, ptr, w : integer;
      temp : string;

   Begin
   if (length (unused) = 1) then
      begin
      ptr := 1;
      while (ptr < length (used)) and not (used [ptr] in vertex [unused [1]].match) do
         inc(ptr);
      if (length (used) - ptr + 1 > worst) then
         w := length (used) - ptr + 1
      else
         w := worst;

      if (w < best_band) or ((w = best_band) and (used + unused < best)) then
         begin
         best_band := w;
         best := used + unused;
         end;
      end
   else
      begin
(*      if (length (used) < test) or (pos (first, used) in [1..test]) then*)
      for i := 1 to length (unused) do
         begin
         (* Find longest band connecting to unused [i] *)
         ptr := 1;
         while (ptr < length (used)) and not (used [ptr] in vertex [unused [i]].match) do
            inc (ptr);
         if (length (used) - ptr + 1 > worst) then
            w := length (used) - ptr + 1
         else
            w := worst;

         if (w < best_band) or ((w = best_band) and (used < best)) then
            begin
            temp := unused;
            delete (temp, i, 1);
            scan (used + unused [i], temp, w);
            end;
         end;
      end;
   End;


Procedure Scream (message : string);

   Begin
   writeln ('****** Problem wuth input data *****');
   writeln (message);
   writeln ('************************************');
   halt;
   End;


procedure add_node (
   let : char;
   connected : string);

   Var
      i : integer;

   Begin
   if (pos (ctos(let), seen) = 0) then
     if length (seen) = max then
        scream ('Too many nodes')
     else
        seen := seen + let;
   with vertex [let] do
      begin
         for i := 1 to length (connected) do
            if (pos (ctos(connected[i]), edges) = 0) then
               begin
               edges := edges + connected [i];
               match := match + [connected [i]];
               end;
      end;
   End;


BEGIN
repeat
   readln (line);
   if (line <> '#') then
      begin
      seen := '';
      for ch := 'A' to 'Z' do
         with vertex [ch] do
         begin
         edges := '';
         match := [];
         end;
      line := line + ';';
      for i := 1 to length (line) do
         if not (line [i] in ['A'..'Z', ';', ':']) then
            scream ('Naughty letter ' + line [i]);

      semi := pos (';', line);
      if (semi = 0) then
         scream ('No nodes in line ' + line);
      while (semi <> 0) do
         begin
         if line [2] <> ':' then
            scream ('Was expecting a colon at pos 2 in ' + line);
         colon := pos (':', line);
         if (colon > semi) or (colon = 0) then
            scream ('Couldn''t find sensible colon in ' + line);
         if colon = semi - 1 then
            scream ('Must have some neighbours if specified! ' + line);
         add_node (line [1], copy (line, colon + 1, semi - colon - 1));
         for i := colon + 1 to semi - 1 do
            add_node (line [i], ctos(line[1]));
         delete (line, 1, semi);
         semi := pos (';', line);
         end;
      if (line <> '') then
         scream ('Lewft over data? ' + line);
      best := 'ZZ';
      best_band := length (seen);
      first := seen [1];
      for i := 1 to length (seen) do
         if seen[i] < first then
            first := seen [i];
      test := (length (seen) + 1) div 2;

      scan ('', seen, 0);
      for i := 1 to length (best) do
         write (best [i], ' ');
      writeln ('-> ', best_band:1);
      end;
   until (line = '#');

close (input);
END.
