PROGRAM Forests;

#include "str.h"

{Third fairly serious attempt to solve Mike's Forest problem}
CONST probname = 'PROBLEM';
      probnumber = 'B';
VAR debugcounter: integer;

CONST gridmax = 100;
      N_points = 1000;  {number of visible points in an octant}
      min_degrees = 0.01;
      pi = 3.1415926535897932385;

TYPE grindex = 0..gridmax;
     pointindex = 0..N_points;
     pointrec = record m_angle, l_angle, r_angle: real end;

VAR diameter, xp, yp : real;
    point : array[pointindex] of pointrec;
    N, gridno : pointindex;
    radius, min_angle, half_angle : real;

FUNCTION ReadData : Boolean;                   forward;
FUNCTION CountOctant(xp,yp : real): integer;   forward;
FUNCTION CountQuadrant(xp,yp : real): integer; forward;
PROCEDURE Solveproblem;                        forward;
PROCEDURE QuickSort(l,r:pointindex);           forward;
PROCEDURE InsertionSort;                       forward;
FUNCTION ArcTan2(Gy, Gx : real): real;         forward;

PROCEDURE MainProg;
begin  {Main}

min_angle := min_degrees * pi / 180.00; half_angle := min_angle/2.00;

while ReadData do
  SolveProblem;

end; {of main procedure}

PROCEDURE Error(s: string);
begin writeln; writeln('Error - ', s); HALT end;

FUNCTION ReadData : Boolean;
begin
readln(diameter, xp, yp);
ReadData := not((diameter = 0) and (xp = 0) and (yp = 0));
radius := diameter/2;
end;  {Read Data}

PROCEDURE SolveProblem;
VAR i : integer;
begin
i :=   CountQuadrant(  xp,   yp)
     + CountQuadrant(1-xp,   yp)
     + CountQuadrant(  xp, 1-yp)
     + CountQuadrant(1-xp, 1-yp);
Writeln(i:1);
end;

FUNCTION CountQuadrant(xp, yp : real): integer;
begin CountQuadrant := CountOctant(xp, yp) + CountOctant(yp, xp) - 1 end;

FUNCTION CountOctant(xp, yp : real): integer;
VAR i,j : integer;
    dx, dy, dy2,
    incx, leftx,
    theta, d_theta,
    delta,
    last_left, right, left : real;
    count, oldcount : integer;
    too_small, visible : Boolean;
    l,r,m : integer;

begin
N := 0; dx :=  -xp; dy := 1.00 - yp; dy2 := dy * dy;
with point[0] do begin
  m_angle := pi / 2.00;
  l_angle := m_angle + min_angle; r_angle := m_angle - min_angle end;
repeat {All trees in first line are visible (to limit of visibility)}
  inc(N); dx := dx + 1.00;
  with point[N] do begin
    m_angle := ArcTan2(dy, dx); delta := ArcTan2(radius, sqrt(dx*dx + dy2));
    l_angle := m_angle + delta; r_angle := m_angle - delta;
    too_small := (delta < half_angle)
              OR (point[N-1].r_angle - l_angle < min_angle) end;
  until too_small;
with point[1] do incx := cos(r_angle)/sin(r_angle);
leftx := xp + dy/incx;
count := N - 1;  {Allow for last 'invisible' tree}
oldcount := 0;
with point[N] do begin
  l_angle := 0.0; m_angle := 0.0; r_angle := 0.0 end;

while count > oldcount do begin
  oldcount := count;
  dy := dy + 1.00; dy2 := dy*dy;
  leftx := leftx + incx; j := trunc(leftx); dx := j - xp;
{Check left end to see if it sticks into visible space}
  theta := ArcTan2(dy, dx); d_theta := ArcTan2(radius, sqrt(dx*dx + dy2));
  with point[1] do
    if theta - d_theta < r_angle
      then r_angle := theta - d_theta;

  too_small := false; m := 1; last_left := theta - d_theta;
  while not too_small do begin
    inc(j); dx := dx + 1.00;
    theta := ArcTan2(dy, dx); d_theta := ArcTan2(radius, sqrt(dx*dx + dy2));
    too_small := d_theta < half_angle;
    if not too_small
      then begin
{Search for theta - table goes from big to small, angles will do likewise}
        while point[m].m_angle >= theta do inc(m); dec(m);
        left := theta + d_theta; right := theta - d_theta;
        visible := last_left - left >= min_angle; last_left := right;
        too_small := not visible;
        if visible then with point[m] do
          if (r_angle - left) < min_angle
            then begin
              if right < r_angle then r_angle := right;
              visible := false end;
        if visible then with point[m+1] do
          if (right - l_angle) < min_angle
            then begin
              if left > l_angle then l_angle := left;
              visible := false end;
        if visible
          then begin
            inc(count); inc(N);
            with point[N] do begin
              m_angle := theta;
              l_angle := theta + d_theta; r_angle := theta - d_theta end;
            end;
        end;  {if not too small}
    end;  {while not too small}
  QuickSort(1, N); InsertionSort;
  end;  {no change in count}
CountOctant := count;
end;  {Count Trees}

PROCEDURE QuickSort(l,r : pointindex);
var i,j : integer;
    x : real;
    t : pointrec;

begin
i := l; j := r;
x := point[(l+r) div 2].m_angle;
repeat
  while point[i].m_angle > x do inc(i);
  while point[j].m_angle < x do dec(j);
  if i <= j
    then begin
      t := point[i]; point[i] := point[j]; point[j] := t;
      inc(i); dec(j) end;
  until i >= j;

if (j - l > 10) then QuickSort(l,j);
if (r - i > 10) then QuickSort(i,r);
end;  {Quick sort by m_angle}

PROCEDURE InsertionSort;
VAR i,j : integer;
    t : pointrec;

begin
point[0].m_angle := 0;
for i := 2 to N do begin
  t := point[i]; j := i - 1;
  while point[j].m_angle < t.m_angle do begin
    point[j+1] := point[j]; dec(j) end;
  point[j+1] := t end;
end;  {Insertion Sort by Angle}

FUNCTION ArcTan2(Gy, Gx : real): real;
VAR q : integer;
    t : real;

begin
if (Gx = 0) and (Gy = 0) then t := 0.0
else begin
  q := 2 * ord(Gy < 0) + ord(Gx < 0);
  if Gx = 0
    then if Gy > 0
      then t := pi/2
      else t := 3 * pi/2 else
  if Gy = 0
    then if Gx > 0
      then t := pi + pi
      else t := pi
  else  {Gx, Gy <> 0}
    begin
      t := arctan(abs(Gy)/abs(Gx));
      case q of
        0: {zero'th quadrant};
        1: t := pi - t;
        3: t := pi + t;
        2: t := 2*pi - t
        end;
      end;
  end; {Gx and Gy <> 0}
ArcTan2:= t;
end;  {ArcTan2}

begin mainprog end.