program extel (input, output);

#include "str.h"

const
  MAX_STRING = 20;
  MAX_REF = 21 ; {MAX_STRING + 1;}

type
  match_ptr = ^match_record;
  match_record = record
      match: integer;
      moves: integer;
      count: integer;
      position: array['s'..'t'] of array[0..MAX_STRING] of integer;
      next: match_ptr;
    end;
  short_string = string;

var
  str: string;
  s, t: short_string;
  match_head: match_ptr;
  best_moves: integer;
  best_ptr: match_ptr;
  cross_ref: array[2..MAX_REF, 2..MAX_REF] of match_ptr;


procedure fatal (message: string);

  begin
  writeln;
  writeln(message);
  halt;
  end;


procedure store_match (sp, tp: integer;
                current: match_ptr);

  var
    ptr: match_ptr;
    old_sp, old_tp: integer;

  begin
  new(ptr);
  if (current = nil) then
    begin
    with ptr^ do
      begin
      count := 0;
      match := 0;
      moves := 0;
      position['s', 1] := 1;
      position['t', 1] := 1;
      end;
    end
  else
    ptr^ := current^;

  with ptr^ do
    begin
    old_sp := position['s', count + 1];
    old_tp := position['t', count + 1];
    if (tp - old_tp > sp - old_sp) then
      moves := moves + (tp - old_tp)
    else
      moves := moves + (sp - old_sp);

    count := count + 1;
    position['s', count] := sp;
    position['t', count] := tp;
    while (sp <= length(s)) AND (tp <= length(t)) AND (s[sp] = t[tp]) do
      begin
      sp := sp + 1;
      tp := tp + 1;
      match := match + 1;
      end;
    position['s', count + 1] := sp;
    position['t', count + 1] := tp;
    next := match_head;
    end;
  if (cross_ref[sp, tp] = nil) then
    begin
    match_head := ptr;
    new(cross_ref[sp, tp]);
    cross_ref[sp, tp]^ := ptr^;
    end
  else if (cross_ref[sp, tp]^.moves > ptr^.moves) then
    begin
    match_head := ptr;
    cross_ref[sp, tp]^ := ptr^;
    end
  else
    dispose(ptr);
  end;


procedure eval (longer: integer;
                var ptr: match_ptr);

  var
    loop, sp, tp: integer;

  begin
  if (longer - ptr^.match < best_moves) and (ptr^.moves < best_moves) then
    begin
    with ptr^ do
      begin
      sp := position['s', count + 1];
      tp := position['t', count + 1];
      if (length(t) - tp > length(s) - sp) then
        moves := moves + (length(t) - tp + 1)
      else
        moves := moves + (length(s) - sp + 1);

      if (moves < best_moves) then
        begin
        if (best_ptr = nil) then
          new(best_ptr);
        best_ptr^ := ptr^;
(* writeln('Best ', best_moves : 1, ' --> ', moves : 1); *)
        best_moves := moves;
        end;
      end;
    end;
  dispose(ptr);
  end;


procedure display (ptr: match_ptr);

  var
    cp, sp, tp, index: integer;

  begin
  sp := 1;
  tp := 1;
  cp := 1;
  index := 1;
  with ptr^ do
    begin
    position['s', count + 1] := length(s) + 1;
    position['t', count + 1] := length(t) + 1;
    end;

  with ptr^ do
    while (sp <= length(s)) or (tp <= length(t)) do
      begin
(* skip the matching bits *)
      if (sp = position['s', index]) and (tp = position['t', index]) then
        begin
        while (sp <= length(s)) AND (tp <= length(t)) AND (s[sp] = t[tp]) do
          begin
          cp := cp + 1;
          sp := sp + 1;
          tp := tp + 1;
          end;
        index := index + 1;
        end;

(* change bits *)
      while (sp < position['s', index]) and (tp < position['t', index]) do
        begin
        write('C', t[tp], cp div 10 : 1, cp mod 10 : 1);
        sp := sp + 1;
        tp := tp + 1;
        cp := cp + 1;
        end;

(* Delete bits *)
      while (sp < position['s', index]) do
        begin
        write('D', s[sp], cp div 10 : 1, cp mod 10 : 1);
        sp := sp + 1;
        end;

(* Add bits *)
      while (tp < position['t', index]) do
        begin
        write('I', t[tp], cp div 10 : 1, cp mod 10 : 1);
        tp := tp + 1;
        cp := cp + 1;
        end;
      end;

  writeln('E');
  end;


procedure method1;

  var
    loop, blank, sp, tp, cp, old_sp, old_tp, longer: integer;
    work: match_ptr;
    count: integer;
    hold: char;

  begin
  blank := pos(' ', str);
  if (blank in [0, 1, length(str)]) then
    fatal('Blank in unexpected position "' + str + '"');
  s := copy(str, 1, blank - 1);
  t := copy(str, blank + 1, length(str) - blank);

  if (length(s) > length(t)) then
    longer := length(s)
  else
    longer := length(t);
  best_moves := longer;
  best_ptr := nil;

(* Find first set of matches *)
  for sp := 1 to length(s) do
    for tp := 1 to length(t) do
      if (s[sp] = t[tp]) then
        if ((sp = 1) OR (tp = 1) OR (s[sp - 1] <> t[tp - 1])) then
          store_match(sp, tp, nil);

  count := 0;
  while (match_head <> nil) do
    begin
    count := count + 1;
    work := match_head;
    match_head := match_head^.next;
    with work^ do
      begin
      old_sp := position['s', count + 1];
      old_tp := position['t', count + 1];
      if (moves + abs((length(s) - old_sp) - (length(t) - old_tp)) < best_moves) then
        for sp := old_sp to length(s) do
          for tp := old_tp to length(t) do
            if (s[sp] = t[tp]) then
              if ((s[sp - 1] <> t[tp - 1]) OR (sp = old_sp) OR (tp = old_tp)) then
                store_match(sp, tp, work);
      end;
    eval(longer, work);
    end;

(*    writeln('Loop: ', count : 1, ', Minimum moves: ', best_moves : 1); *)
  if (best_ptr = nil) then
    begin
    new(best_ptr);
    best_ptr^.count := 0;
    end;
  display(best_ptr);
  dispose(best_ptr);
  end;


procedure init_cross (first: boolean);

  var
    i, j: integer;

  begin
  for i := 2 to MAX_REF do
    for j := 2 to MAX_REF do
      begin
      if not first then
        if (cross_ref[i, j] <> nil) then
          dispose(cross_ref[i, j]);
      cross_ref[i, j] := nil;
      end;
  end;


begin
init_cross(TRUE);
match_head := nil;

readln(str);
while (str <> '#') do
  begin
  init_cross(FALSE);
  if not (length(str) in [3..MAX_STRING * 2 + 1]) then
    fatal('input string unexpected length "' +  str + '"');
  method1;
  readln(str);
  end;
end.

