PROGRAM SomeProg;

#include "str.h"


CONST probchar = 'E';



TYPE  cavename = ' '..'Z';
      cave = record
               next, degree: integer;
               lit: Boolean;
               conn: array[1..26] of cavename
               end;

VAR   debugcounter: integer;
      labyrinth: array[cavename] of cave;
      k, count: integer;
      Minotaur, Theseus, c: cavename;
      trapped: Boolean;

FUNCTION ReadGraph: Boolean;
VAR s: string;
    i: integer;
    c1,c2: char;
    done: Boolean;

PROCEDURE Error(e:string);
begin
  writeln; writeln(s);
  if i > 2 then write(' ':i-2); writeln('^');
  writeln(e); HALT;
end;

FUNCTION GetChar: char; begin GetChar := s[i]; inc(i) end;
PROCEDURE CheckNode(c:char);
begin if not (c in ['A'..'Z']) then Error('Node name expected') end;

PROCEDURE ReadNodes;
begin
c1 := GetChar; CheckNode(c1);
labyrinth[c1].lit := false;
c2 := GetChar; if c2 <> ':' then Error(': expected');
c2 := GetChar;
repeat
  CheckNode(c2); if c2 = c1 then Error('Self trapped');
  with labyrinth[c1] do begin
    inc(next); conn[next] := c2 end;
  c2 := Getchar until c2 in [';', '.'];
done := c2 = '.';
end;  {Read Nodes}

begin  {Read Graph}
readln(s);
if s = '#'
  then ReadGraph := false
else begin
  for c1 := 'A' to 'Z' do
    with labyrinth[c1] do begin
      next := 0; lit := true;
      for i := 1 to 26 do conn[i] := ' ' end;
  ReadGraph := true; i := 1;

  repeat ReadNodes until done;
  for c1 := 'A' to 'Z' do
    with labyrinth[c1] do degree := next;

  repeat c1 := GetChar until c1 <> ' '; CheckNode(c1); Minotaur := c1;
  repeat c1 := GetChar until c1 <> ' '; CheckNode(c1); Theseus := c1;
  repeat c1 := GetChar until c1 <> ' '; k := 0;
  while c1 in ['0'..'9'] do begin
    k := k*10 + (ord(c1) - ord('0')); c1 := GetChar end;
  end;
end; {Read Graph}

PROCEDURE Move;
VAR first, there: cavename;

FUNCTION Safe: Boolean;
begin Safe := (not labyrinth[there].lit and (there <> theseus)) end;
begin
inc(count);
with labyrinth[Minotaur] do begin
  next := 0;
  repeat
    inc(next); there := conn[next];
    until (next = degree) or Safe;
  end;
if Safe
  then begin
    Theseus := Minotaur; Minotaur := there;
    if count mod k = 0
      then begin labyrinth[Theseus].lit := true;
        write(Theseus, ' ') end;
    end
  else trapped := true;
end;

begin  {Main}

while ReadGraph do begin
  count := 0; trapped := false;
  repeat Move until trapped;
  writeln('/', Minotaur);
  end;

end. {of program}
