program patience (input, output);
type
  card_type = record
      face, suit: char;
      value: 1..13;
    end;
  stack = record
      count: integer;
      cards: array[1..13] of card_type;
    end;

var
  deck: array[1..52] of card_type;
  thischar: char;

procedure get_data;
  begin
  read(thischar);
  if eoln then readln;
  while (thischar = ' ') do
    read(thischar);
{**writeln('read_data "',thischar,'"');{**}
  end;

PROCEDURE get_card(var card: card_type);
begin
  with card do begin
    face := thischar;
{**writeln('face = ',face);{**}
    case face of
    'A':
      value := 1;
    '2'..'9':
      value := ord(face) - ord('0');
    'T':
      value := 10;
    'J':
      value := 11;
    'Q':
      value := 12;
    'K':
      value := 13;
    otherwise begin writeln('Funny character ',face);HALT end;{**}
    end;
    get_data;
    suit := thischar;
    get_data;
    end;
  end;


procedure play_clock;
  var
    piles: array[1..13] of stack;
    loop, current, played: integer;
    stock: card_type;

  begin
(* Deal *)
  for loop := 1 to 13 do
    piles[loop].count := 0;
  loop := 0;
  while (loop < 52) do
    begin
    with piles[loop mod 13 + 1] do
      begin
      count := count + 1;
      cards[count] := deck[52 - loop];
      end;
    loop := loop + 1;
    end;

(* Play *)
  current := 13;
  played := 0;
  while (piles[current].count > 0) do
    begin
    played := played + 1;
    with piles[current] do
      begin
      stock := cards[count];
      current := cards[count].value;
      count := count - 1;
      end;
    end;
writeln(played div 10 : 1, played mod 10 : 1, ',', stock.face, stock.suit);
end;


procedure doit;
  var
    loop: integer;

  begin
  read(thischar);
  while (thischar <> '#') do
    begin
    for loop := 1 to 52 do
      get_card(deck[loop]);
    play_clock;
    end;
  end;

begin
doit;
end.
