#include <stdio.h>
#include <time.h>

#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "contest.h"

#define USAGE "Usage: %s [-v] team \"dd/mm/yy hh:mm\"\n"

static char *progname;

        int
main(argc, argv)
        int argc;
        char *argv[];
{
	char *team;
	struct result_list *rs;
	struct tm tm;
	time_t start;
	int solved = 0;
	int minutes = 0;
	int attempted = 0;
	char prob = ' ';
	char path[MAXPATHLEN];
	struct stat buf;
	char *strptime();
	int verbose = 0;
	int expected_version;

	progname = argv[0];
	if (argc < 3) {
		(void) fprintf(stderr, USAGE, progname);
		exit(1);
	}
	if (strcmp(argv[1], "-v") == 0) {
		verbose = 1;
		argc -= 2;
		argv += 2;
	} else {
		argc--; argv++;
	}

	if (argc != 2) {
		(void) fprintf(stderr, USAGE, progname);
		exit(1);
	}

	team = argv[0];
	if (!read_results(team, &rs)) {
		(void) fprintf(stderr, "%s: failed to read result file\n",
			       progname);
		exit(1);
	}

	if (!strptime(argv[1], "%d/%m/%y %T", &tm)) {
		(void) fprintf(stderr, "%s: invalid time %s\n",
			       progname, argv[1]);
		exit(1);
	}
	start = timelocal(&tm);

	if (verbose) {
		(void) printf("Summary for team `%s', contest `%s'\n", team,
			      get_contest_name());
	}
	while (rs) {
		if (prob != extract_problem(rs->program)) {
			expected_version = 1;
			attempted++;
			prob = extract_problem(rs->program);
			if (verbose) {
				(void) printf("\n    Problem %c\n", prob);
			}
		}

		(void) sprintf(path, "%s/%s", get_teamdir(team), rs->program);
		if (stat(path, &buf) == -1) {
			(void) fprintf(stderr, 
				       "%s: stat failure for %s\n",
				       progname, path);
			exit(1);
		}

		if (expected_version != extract_version(rs->program)) {
			(void) fprintf(stderr,
			   "%s: version %d expected; program %s encountered\n",
				       progname, expected_version,
				       rs->program);
		}
		expected_version = extract_version(rs->program) + 1;

		if (verbose) {
			(void) printf("        Attempt %d: %s --- at %s",
				      extract_version(rs->program),
				      error_message(rs->result),
				      ctime(&buf.st_mtime)); 
		}
		if (rs->result == CORRECT) {
			solved++;
			(void) sprintf(path, "%s/%s", get_teamdir(team),
				       rs->program);
			if (stat(path, &buf) == -1) {
				(void) fprintf(stderr, 
					       "%s: stat failure for %s\n",
					       progname, path);
				exit(1);
			}
			minutes += (buf.st_mtime - start) / 60 +
			  (extract_version(rs->program) - 1) * WRONG_PENALTY;
			/*
			 * Skip trailing entries for this problem
			 */
			while (rs->next && prob ==
			       extract_problem(rs->next->program)) {
				(void) fprintf(stderr,
		      "%s: Skipping trailing garbage for team %s problem %c\n",
					       progname, team, prob);
				rs = rs->next;
			}
		}
		rs = rs->next;
	}
	if (verbose) {
		(void)  printf("\n   Solved  Minutes Attempted\n");
	}
	(void) printf("%8d%8d%8d\t%s\n", solved, minutes, attempted, team);

	return 0;
}

