/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/
#include <stdio.h>
#include <fcntl.h>
#include "bb.h"

void moderate()
{
	char fullpath[PATHSIZE],oldpath[PATHSIZE];
	struct folder fold;
	struct Header head;
	char *text;
	char answer[11];
		
	int f_file;
	int tmpindex,tmptext;
	
	sprintf(fullpath,"%s/%s",HOMEPATH,FOLDERFILE);
	if ((f_file=open(fullpath,O_RDWR))<0) 
		{perror(fullpath);exit(-1);}
	while (get_folder_entry(f_file,&fold))
	{
	sprintf(oldpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,MOD_END);
	if (!access(oldpath,00))
	{
		printf("Changing to folder %s\n",fold.name);
		/* move the unmoderated messages to a temporary file */
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,".tmp");
		rename(oldpath,fullpath);
		sprintf(oldpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,MOD_END);
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,".tmp");
		rename(oldpath,fullpath);
		
		/* files containing messages to be approved */
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,".tmp");
		if ((tmpindex=open(fullpath,O_RDONLY))<0) 
			{perror(fullpath);exit(-1);}
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,".tmp");
		if ((tmptext=open(fullpath,O_RDONLY))<0)
			{perror(fullpath);exit(-1);}
		while (get_data(tmpindex,&head))
		{
			int foo;
			text=(char *)malloc(head.size);
			lseek(tmptext,head.datafield,0);
			if ((foo=read(tmptext,text,head.size))<head.size)
			{
				printf("only %d of %d bytes read.\n",foo,head.size);
				return;
			}
			display_article(&head,tmptext);
			printf("[%s] (A)pprove, (L)eave, (S)ave&delete ? (<CR> to delete)",fold.name);
			get_str(answer,10);
			if (stringcmp(answer,"approve",7))
			{
				Lock_File(f_file);
				lseek(f_file,-1*sizeof(struct folder),1);
				fold.last++;
				if (fold.first<=0) fold.first=1;
				write(f_file,&fold,sizeof(fold));
				add_message(&fold,&head,text);
				Unlock_File(f_file);
			}else
			if (stringcmp(answer,"leave",5))
			{
				put_back(&fold,&head,text);
			}else
			if (stringcmp(answer,"save&delete",11))
			{
				store(&fold,&head,text);
			}else
				printf("Deleted.\n");
			free(text);
		}
		printf("End of folder %s\n",fold.name);
		close(tmpindex);
		close(tmptext);
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,".tmp");
		if (unlink(fullpath)) {perror(fullpath);exit(-1);}
		sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,".tmp");
		if (unlink(fullpath)) {perror(fullpath);exit(-1);}
	}
	}
	close(f_file);
}

void put_back(fold, head, text)
struct folder *fold;
struct Header *head;
char *text;
{
	char fullpath[PATHSIZE];
	int newindex,newtext;
	
		/* files to put messages to be approved later */
	sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold->name,INDEX_END,MOD_END);
	if ((newindex=open(fullpath,O_WRONLY|O_APPEND|O_CREAT,0600))<0)
		{perror(fullpath);exit(-1);}
	sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold->name,TEXT_END,MOD_END);
	if ((newtext=open(fullpath,O_WRONLY|O_APPEND|O_CREAT,0600))<0)
		{perror(fullpath);exit(-1);}
	Lock_File(newindex);
	Lock_File(newtext);
	head->datafield=lseek(newtext,0,2);
	head->Ref=0;
	write(newindex,head,sizeof(*head));
	write(newtext,text,head->size);
	Unlock_File(newtext);
	Unlock_File(newindex);
	close(newindex);
	close(newtext);
}

void add_message(fold, head, text)
struct folder *fold;
struct Header *head;
char *text;
{
	char fullpath[PATHSIZE];
	int modindex,modtext;
	
	/* files for general public to read */
	sprintf(fullpath,"%s/%s%s",HOMEPATH,fold->name,INDEX_END);
	if ((modindex=open(fullpath,O_WRONLY|O_APPEND|O_CREAT,0600))<0)
		{perror(fullpath);exit(-1);}
	sprintf(fullpath,"%s/%s%s",HOMEPATH,fold->name,TEXT_END);
	if ((modtext=open(fullpath,O_WRONLY|O_CREAT,0600))<0)
		{perror(fullpath);exit(-1);}
	Lock_File(modindex);
	Lock_File(modtext);
	head->Ref=fold->last;
	head->datafield=lseek(modtext,0,2);
	if (write(modindex,head,sizeof(*head))<0) {perror("mod: writehead");}
	if (write(modtext,text,head->size)<0) {perror("mod: write text");}
	
	Unlock_File(modtext);
	Unlock_File(modindex);
	close(modtext);
	close(modindex);
}

void store(fold, head, text)
struct folder *fold;
struct Header *head;
char *text;
{
	int afile;
	char buff[128];
	char fullpath[PATHSIZE];
	
	sprintf(fullpath,"%s/%s",HOMEPATH,"mod.save");
	if ((afile=open(fullpath,O_WRONLY|O_APPEND|O_CREAT,0600))<0)
		{perror(fullpath);exit(-1);}
	
	Lock_File(afile);
	sprintf(buff,"\nMessage in folder %s\nFrom: %s\nTo: %s\nSubject: %s\nDate: %s",
	        fold->name,head->from,head->to,head->subject,ctime(&head->date));
	write(afile,buff,strlen(buff));
	write(afile,text,head->size+1);
	Unlock_File(afile);
	close(afile);
}
