
/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include "bb.h"
#include <fcntl.h>

void who_add(pid,posn)
int pid;
long posn;
{
	struct who rec;
	int wfile;

	if ((wfile=err_open(makepath(WHOFILE,"",""),O_RDWR|O_CREAT,0600))<0)
		{exit(-1);}
	Lock_File(wfile);
	while(read(wfile,&rec,sizeof(rec))==sizeof(rec))
	{
		if(rec.pid==-1)
		{
			lseek(wfile,(long)-sizeof(rec),1);
			break;
		}
	}
	rec.pid=pid;
	rec.posn=posn;
	Lock_File(wfile);
	write(wfile,&rec,sizeof(rec));
	Unlock_File(wfile);
	close(wfile);
}
	
void who_delete(pid)
int pid;
{
	int fd;
	struct who temp;
	fd=openwhofile(O_RDWR);
	if(fd==-1)
	{
		perror("who");
		exit(1);
	}
	Lock_File(fd);
	while(read(fd,&temp,sizeof(temp))==sizeof(temp))
	{
		if(temp.pid==pid || (kill(temp.pid,0)==-1 && errno==ESRCH))
		{
			lseek(fd,(long)-sizeof(temp),1);
			temp.pid=-1;
			write(fd,&temp,sizeof(temp));
		}
	}
	Unlock_File(fd);
	close(fd);
}
			
void copy(a,b)
char *a, *b;
{
	int af,bf;
	char buff[1024];
	int size;
	
	if ((af=open(a,O_WRONLY|O_CREAT,0600))<0)
		{perror(a);exit(-1);}
	if ((bf=open(b,O_RDONLY))<0)
		{perror(b);exit(-1);}
	
	Lock_File(af);
	while ((size=read(bf,buff,1024)))
	{
		write(af,buff,size);
	}
	Unlock_File(af);
	close(af);
	close(bf);
}

void who_list(wiz)
int wiz;
{
	struct person user;
	struct who w;
	int ufile,wfile;
	char stats[10];
	char chat;
	
	wfile=openwhofile(O_RDONLY);
	ufile=openuserfile(O_RDONLY);

	printf("Current users :\n");
	if (wiz) printf("\nPID    %-*s %-*s  Idle   What...\n",NAMESIZE,"Name",20,"RealName");
	else printf("\n%-*s Idle   What...\n",NAMESIZE,"Name");
	while (read(wfile,&w,sizeof(w)))
	{
		lseek(ufile,w.posn,0);
		read(ufile,&user,sizeof(user));
		show_user_stats(user.status,stats,TRUE);
		if ((u_god(user.status) || s_wizchat(user.special)) && !s_chatoff(user.special))
			chat='*';
		else
			chat=' ';

		if (w.pid!=-1 && kill(w.pid,0)==0)
		{
			if (wiz)
			{
				printf("%-5d %c%-*s %-*s %6s %s\n",w.pid,chat,NAMESIZE,user.name,20,user.realname,itime(time(0)-user.idletime),user.doing);
			}else
			{
				printf("%-*s %6s %s\n",NAMESIZE,user.name,itime(time(0)-user.idletime),user.doing);
			}
		}
	}
	if (!wiz) putchar('\n');
	close(wfile);
	close(ufile);
}

int get_user_pid(name)
char *name;
{
	struct person user;
	struct who w;
	int ufile,wfile;
	int found=0;
	
	wfile=openwhofile(O_RDONLY);
	ufile=openuserfile(O_RDONLY);
	
	while (read(wfile,&w,sizeof(w)))
	{
		lseek(ufile,w.posn,0);
		read(ufile,&user,sizeof(user));
		if ( w.pid!=-1 && stringcmp(user.name,name,8) && kill(w.pid,0)==0)
		{
			if (!u_reg(user.status))
			{
				found=-1;
			}else
			if (u_mesg(user.status))
			{
				found= -1* ( w.pid );
			}else
			{
				found=w.pid;
			}
		}
	}
	close(wfile);
	close(ufile);
	
	return(found);
}

int get_pid(name)
char *name;
{
	struct person user;
	struct who w;
	int ufile,wfile;
	int found=0;
	
	wfile=openwhofile(O_RDONLY);
	ufile=openuserfile(O_RDONLY);
	
	while (read(wfile,&w,sizeof(w)))
	{
		lseek(ufile,w.posn,0);
		read(ufile,&user,sizeof(user));
		if ( w.pid!=-1 && stringcmp(user.name,name,-1) && kill(w.pid,0)==0)
		{
			found=w.pid;
		}
	}
	close(wfile);
	close(ufile);
	
	return(found);
}

#ifdef RWHO
void rwho_update()
{
	static int setup=0;
	static long t=0;

	if (!setup)
	{
		setup=1;
		rwhocli_setup("->IP ADDRESS<-","->PASSWD<-","Milliways","THE Bulletin Board");
	}
	if (time(0)-t>240)
	{
		t=time(0);
		rwhocli_pingalive();
		rwho_list();
	}
}

void rwho_list()
{
	struct person user;
	struct who w;
	int ufile,wfile;
	
	wfile=openwhofile(O_RDWR);
	ufile=openuserfile(O_RDONLY);
	
	while (read(wfile,&w,sizeof(w))>0)
	{
		if (w.posn!=-1L)
		{
			lseek(ufile,w.posn,0);
			read(ufile,&user,sizeof(user));

			if (w.pid!=-1 && kill(w.pid,0)==0)
			{
				rwhocli_userlogin(user.name,user.name,user.lastlogin);
			}else
			{
				rwhocli_userlogout(user.name);
				w.posn=-1L;
				lseek(wfile,(long)-sizeof(w),1);
				write(wfile,&w,sizeof(w));
			}
		}
	}
	close(wfile);
	close(ufile);
}
#endif

void check_copies(where)
long where;
{
	struct who u;
	int file;
	int count;
	char buff[5];
	
	file=openwhofile(O_RDONLY);

	count=0;
	lseek(file,0L,0);
	while(read(file,&u,sizeof(u))>0)
		if (u.pid>0 && u.posn==where)
			count++;

	if (count==1)
	{
		printf("You are already logged in.\n");
	}else
	if (count>1)
	{
		printf("You are already logged in %d times.\n",count);
	}
	if (count>0)
	{
		printf("Do you want to kill those sessions ?");
		get_str(buff,4);
		if (buff[0]=='y')
		{
			printf("Killing... ");
			lseek(file,0L,0);
			while(read(file,&u,sizeof(u))>0)
				if (u.pid>0 && u.posn==where)
					kill(u.pid,SIGTERM);
			printf("Done.\n");
		}
	}
	close(file);
}

char *itime(t)
unsigned long t;
{
	static char out[7];

	if (t>=3600) sprintf(out,"%2dh%2dm",t/3600,(t%3600)/60);
	else
	if (t>=60) sprintf(out,"%2dm%2ds",t/60,t%60);
	else
	sprintf(out,"%5ds",t);
	return(out);
}
