#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ipx.h>
#include <linux/if.h>
#include <stdio.h>
#include <asm/byteorder.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>

#define PROCNETIPXITF "/proc/net/ipx_interface"

int skfd;

void ipxitf_print()
{
  FILE *fp;
  int ch;

  fp = fopen(PROCNETIPXITF, "r");
  while ((ch = getc(fp)) != EOF)
    putchar(ch);
  fclose(fp);
}

void usage()
{
  fprintf(stderr, "Usage: ipxitf\n");
  fprintf(stderr, "Usage: ipxitf del network interface frame\n");
  exit(-1);
}

int ascii2hex(int ch)
{
  if ('0' <= ch && ch <= '9') return(ch - '0');
  if ('a' <= ch && ch <= 'f') return(ch - 'a' + 10);
  if ('A' <= ch && ch <= 'F') return(ch - 'A' + 10);
  return(-1);
}

int asc2frame(char *frame)
{
  if (!strcmp("ethernet_ii", frame))
    return(IPX_FRAME_ETHERII);
  else if (!strcmp("snap", frame))
    return(IPX_FRAME_SNAP);
  else if (!strcmp("802.2", frame))
    return(IPX_FRAME_8022);
  else if (!strcmp("802.3", frame))
    return(IPX_FRAME_8023);
  else
    return(0);
}

unsigned long gethex(char *s)
{
  unsigned long hex = 0;
  while (*s)
    {
      hex = hex * 0x10 + ascii2hex(*s);
      s++;
    }
  return(hex);
}

void ipxitf_add(char **args)
{
  struct sockaddr_ipx ipxname;
  struct ifreq intrequest;
  char val = 1;

  ipxname.sipx_network = htonl(gethex(*args++));
  strcpy(intrequest.ifr_name, *args++);
  ipxname.sipx_type = asc2frame(*args++);
  ipxname.sipx_port = 0;
  ipxname.sipx_family = AF_IPX;
  memset(&ipxname.sipx_node, 0, sizeof(ipxname.sipx_node));
  ipxname.sipx_special = 0;
  ipxname.sipx_action = IPX_CRTITF;
  
  memcpy(&intrequest.ifr_addr, &ipxname, sizeof(ipxname));
  if (ioctl(skfd, SIOCSIFADDR, &intrequest) < 0)
    perror("setting up address");   
  ioctl(skfd, SIOCAIPXPRISLT, &val);
}

void ipxitf_del(char **args)
{
  struct sockaddr_ipx ipxname;
  struct ifreq intrequest;

  if (!*args) usage();
  ipxname.sipx_network = htonl(gethex(*args++));
  if (!*args) usage();
  strcpy(intrequest.ifr_name, *args++);
  if (!*args) usage();
  ipxname.sipx_type = asc2frame(*args++);
  ipxname.sipx_port = 0;
  ipxname.sipx_family = AF_IPX;
  memset(&ipxname.sipx_node, 0, sizeof(ipxname.sipx_node));
  ipxname.sipx_special = 0;
  ipxname.sipx_action = IPX_DLTITF;
  
  memcpy(&intrequest.ifr_addr, &ipxname, sizeof(ipxname));
  if (ioctl(skfd, SIOCSIFADDR, &intrequest) < 0)
    perror("setting up address");   

}

main(int argc, char **argv)
{
  if (*++argv == NULL)
    {
      ipxitf_print();
      exit(0);
    }

  if (strcmp(*argv,"add") && strcmp(*argv,"del"))
    usage();

  skfd = socket(AF_IPX, SOCK_DGRAM, 0);
  if (skfd < 0)
    {
      perror("socket");
      exit(-1);
    }

  if (!strcmp(*argv,"add"))
    ipxitf_add(++argv);
  else
    ipxitf_del(++argv);

  close(skfd);
}
