/*
 * $Id: sap.h,v 1.1 1995/01/05 09:14:58 root Exp $
 */
#include "ipxroute.h"

#ifndef SAPDUMP_FILE
#define SAPDUMP_FILE	"/var/ipx/services"
#endif

#define SAP_REQ		1
#define SAP_RESP	2
#define SAP_NEAR_REQ	3
#define SAP_NEAR_RESP	4
#define MAX_SAP_INFO	7
#define SAP_ANY		0xffff

#define OBJ_ID_LEN	48

typedef struct _SAPReqEnt {
  unsigned short type;
  unsigned char  name[OBJ_ID_LEN];
  unsigned char  network[4];
  unsigned char  node[6];
  unsigned short socket;
  unsigned short hops;
} SAPReqEnt;

typedef struct _SAPInfo {
  unsigned short type;
  unsigned char  name[OBJ_ID_LEN];
  unsigned long  network;
  unsigned char  node[6];
  unsigned short socket;
  unsigned short hops;
  unsigned long  snetwork;
  unsigned long  age;
  struct _SAPInfo *next;
} SAPInfo;

#ifdef DEBUG
void dump_sap(SAPInfo *p);
#endif

void read_sap(int sock,IPXRouteEnt *rtes);
void age_sap(void) ;
void maxhop_sap(void);
void broadcast_sap(SAPInfo *saps);
SAPInfo *findUniqueService(SAPReqEnt *sap,SAPInfo *sap_table);
SAPInfo *deleteService(SAPInfo *,SAPInfo *sap_table);
SAPInfo *addService(SAPReqEnt *sap,SAPInfo *,unsigned long,IPXRouteEnt *rp);
void send_sapinfo(SAPInfo *saps,unsigned long net);
void process_sapreq(struct sockaddr_ipx *,int);
void process_nearreq(struct sockaddr_ipx *,int,IPXRouteEnt *rtes);
void dump_saptab(void);

extern SAPInfo *sap_table;

#define UPKT_LONG(s1) ((s1[0]<<24)+(s1[1]<<16)+(s1[2]<<8)+s1[3])
