/*
 * help.c
 *
 * Some error printing routines.
 * 
 * Copyright by Hannu Savolainen 1993
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */
#include <stdio.h>
#include <errno.h>

void describe_error(void)
{
	switch (errno)
	{
	case ENXIO:
	case ENODEV:
		fprintf(stderr,	"The device file was found in /dev but\n"
				"there is no driver for it in the kernel.\n"
				"\n"
				"There is several possible reasons:\n"
				"- The sound driver is not present\n"
				"  in the kernel you are currently running.\n"
				"- The driver is in the kernel but there is\n"
				"  no soundcard on your system.\n"
				"- Configuration of the sound driver doesn't\n"
				"  match the hardware.\n"
				"\n"
				"Try cat /dev/sndstat for further info.\n");
		break;

	case ENOSPC:
		fprintf(stderr,	"The soundcard driver was not installed\n"
				"properly. The sound_mem_init() routine\n"
				"was not called during the boot procedure.\n");
		break;

	case ENOENT:
		fprintf(stderr,	"The device file is missing from /dev.\n"
				"Run the script at the end of file\n"
				"sound/linux/Readme (distributed with\n"
				"the sound driver.\n");
		break;

	default: ;
	}
}
