.TH LPANAL 1Csound "7 Feb 1991"
.SH NAME
lpanal - linear predictive analysis and pitch tracking, adapted for Csound.
.SH SYNTAX
.B lpanal 
[flags] soundfilname lpcfilname
.SH DESCRIPTION
.I lpanal
performs linear predictive analysis and pitch tracking on monaural 16bit
fixed point soundfiles, to produce a time-ordered sequence of frames of
control information suitable for Csound resynthesis.  Analysis is conditioned
by the control flags below.  A space is optional between the flag and its value.
.TP 14
-b<begin>
beginning time (in seconds) of the audio segment to be analyzed.
The default is 0.0.
.TP 14
-d<duration>
Duration (in seconds) of the audio segment to be analyzed.  The default
of 0.0 means to the end of the file.
.TP 14
-p<npoles>
Number of poles for analysis.  Default is 34 poles, which is also 
the maximum.
.TP 14
-i<hopsize> 
Hop size in samples between analysis frames.  This determines the number of
frames per second (srate / hopsize) in the output control file.  The analysis
framesize is hopesize * 2 samples.  The default value is 200.
.TP 14
-C<string>
Text for the comment field of the lpfile header.  The default is the null string.
.TP 14
-P<mincps>
Lowest frequency (in cps) of pitch tracking.  -P0 means no pitch tracking.
.TP 14
-Q<maxpitch>
Highest frequency (in cps) of pitch tracking.  The narrower the pitch range,
the more accurate the pitch estimate.
.TP 14
-v<verbosity>
Level of terminal information during analysis.  0 = none, 1 = verbose, 2 = debug.
The default is 0.
.PP
"soundfilname" should be a monaural soundfile of 16-bit linear samples,
currently with an IRCAM soundfile header.  If the name does not begin with '.'
or '/', the file is expected in the directory indicated by the environment
variable SFDIR.  Output is directed to "outfilname" in the current or
specified directory.

.SH DIAGNOSTICS
Unrecognized commandline options to 
.I lpanal
will produce a helpful usage message.
.SH AUTHORS
Paul Lansky at Princeton, modified for MIT Csound by dwf, bv, and dll.
Compact version by dpwe, modified by bv.
.SH BUGS
Currently reads only Ircam-format soundfiles.


