/*
**	PBEND -- Generate Pitch Bend change message
**	psl 2/87
*/
#include	<stdio.h>
#include	<midi.h>

#define	MAXAMT		0x3FFF
#define	DEFDELAY	MPU_CLOCK_PERIOD / 2

main(argc, argv)
char	*argv[];
{
	char buf[512], *cp, *ap;
	int i, chan, amt, delay;

	delay = DEFDELAY;
	cp = buf;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-' && argv[i][1] == 'd') {
		delay = atoi(&argv[i][2]);
		continue;
	    }
	    for (ap = argv[i]; *ap && *ap != '='; ap++);
	    if (*ap++ != '=')
		goto syntax;
	    chan = atoi(argv[i]);
	    if (chan < 1 || chan > MIDI_MAX_CHANS)
		goto syntax;
	    amt = atoi(ap);
	    if (amt < 0 || amt > MAXAMT)
		goto syntax;
	    *cp++ = 0;
	    *cp++ = CH_P_BEND | (chan - 1);
	    *cp++ = amt & 0x7F;
	    *cp++ = (amt >> 7) & 0x7F;
	}
	if (cp == buf) {
syntax:
	    fprintf(stderr, "Usage: %s [-d#] chan=amt [...]\n", argv[0]);
	    fprintf(stderr, "-d# appends a # clock long pause (%d default)\n",
	     MPU_CLOCK_PERIOD);
	    fprintf(stderr, "-d0 supresses appending any pause\n");
	    fprintf(stderr, "'chan' must be a decimal number 1..%d\n",
	     MIDI_MAX_CHANS);
	    fprintf(stderr, "'amt' must be a decimal number 0..%d\n", MAXAMT);
	    exit(2);
	}
	while (delay >= MPU_CLOCK_PERIOD) {
	    *cp++ = RT_TCIP;
	    delay -= MPU_CLOCK_PERIOD;
	}
	*cp++ = delay;
	*cp++ = RT_TCWME;
	write(1, buf, cp - buf);
	exit(0);
}
