#include <libmidi.h>
#include <libdx7.h>

#define d define
#d u_char	unsigned char
#d u_short	unsigned short
#d error	return MidiError("midi_pc"), -1
#d out(b)	if (midi_out(f,b) == -1) error

send_dx7_pc(f, group, chan, par, data)
	int f;		/* file descriptor to write on */
	u_char group;	/* parameter group # */
	u_char chan;	/* midi channel (0 -> ch[1]) */
	u_char data;	/* parameter data (0-127) */
	u_short	par;	/* parameter number (0-65535) */
/*
 * Send parameter change, return '-1' on error, '0' otherwise.
 * The parameter 'group' number is '0 - 32'
 * (n == 0; Common dx7 voice parameter, g == 2; dx7 function parameter)
 */
{
	out(SX_CMD);
	out(ID_DX7);
	out(DX7_SXSS_PC << 4 | (chan & M_CHAN_MASK));
	out((group | ((par>>14)&0x03)) & M_VAL_MASK);
	out((par>>7) & M_VAL_MASK); /* bits 7 - 13 of parameter */
	out(par & M_VAL_MASK);      /* bits 0 - 6 of parameter */
	out(data & M_VAL_MASK);     /* parameter data */
}
