#include <stdio.h>
#include <sys/types.h>
#include <libmidi.h>
#include <libmpu.h>

/*
** Read a midi command in mpu-401 format from 'f' and put it in 'm'.
** Beware: the 'm->mpu_cmd' field points to static memory;
** save it if you are doing simultaneous 'GetMpuCmd()''s.
*/
MpuCmd *
GetMpuCmd(f, m)
FILE *f;
MpuCmd *m;
{
	u_char *cp;
	int c;
	u_long time = 0;

	if ((c=getc(f)) != EOF) {
		if (c==RT_RESET || c==SX_CMD || c==SX_EOB || c==MPU_DATA_END){
			m->time_tag = RT_TCIP;	/* don't print time_tag */
			ungetc(c, f);
		} else if (c==RT_TCIP){
			time += MPU_CLOCK_PERIOD;
			m->time_tag = c;	/* don't print time_tag */
			ungetc(c, f);
		} else if (c < MPU_CLOCK_PERIOD) {
			time += c;
			m->time_tag = c;
		/**** this next is wrong; it's not an RT_TCIP, but a MPU_NO_OP!
			if ((c=getc(f)) == EOF) return NULL;
			if (c==RT_TCIP) time += MPU_CLOCK_PERIOD;
			ungetc(c, f);
		****/
		}
		m->mpu_time = time;
		if ((cp=midi_cmd_in(f))) m->mpu_cmd = cp;
		m->arg_cnt = midi_cmd_in_arg_cnt();
		m->cmd_type = midi_cmd_in_cmd_type();
		m->cmd_cont = m->cmd_type==RT_TCWME? 0 : midi_cmd_in_cont();
		return m;
	}
	return NULL;
}
