#include	"cs.h"                            /*                AIFF.C    */
#include	"soundio.h"
#include	"aiff.h"
#include	"sfheader.h"
#include	<math.h>

#define TRUE    1
#define FALSE   0
#define DEBUG	0

static char     FORM_ID[4] = {'F','O','R','M'};
static char     COMM_ID[4] = {'C','O','M','M'};
static char     MARK_ID[4] = {'M','A','R','K'};
static char     INST_ID[4] = {'I','N','S','T'};
static char     SSND_ID[4] = {'S','S','N','D'};
static char     FORM_TYPE[4] = {'A','I','F','F'};

static FormHdr	    form;
static CommChunk1   comm1;   /* CommonChunk split    */
static CommChunk2   comm2;   /*  to avoid xtra space */
static SoundDataHdr ssnd;

static int sizFormHdr = sizeof(FormHdr);
static int sizCommChunk1 = sizeof(CkHdr) + sizeof(short); /* to avoid long roundup */
static int sizCommChunk2 = sizeof(CommChunk2);
static int sizSoundDataHdr = sizeof(SoundDataHdr);
static int sframe_size;
static int aiffhdrsiz = sizeof(FormHdr)
                      + sizeof(CkHdr) + sizeof(short)
                      + sizeof(CommChunk2)
                      + sizeof(SoundDataHdr);

double  onept = 1.021975; 			/* A440 tuning factor */
double  log10d20 = 0.11512925;			/* for db to ampfac   */

int bytrevhost()
{
#ifndef DOSGCC
    return(*(long *)FORM_ID != 'FORM');
#else
    return(*(long *)FORM_ID != 0x464f524d);
#endif
}

static short benshort(sval)   /* coerce a natural short into a bigendian short */
  register short sval;
{
    char  benchar[2];
    register char *p = benchar;

    *p++ = 0xFF & (sval >> 8);
    *p   = 0xFF & sval;
    return(*(short *)benchar);
}

static long benlong(lval)       /* coerce a natural long into a bigendian long */
  register long lval;
{
    char  benchar[4];
    register char *p = benchar;

    *p++ = 0xFF & (lval >> 24);
    *p++ = 0xFF & (lval >> 16);
    *p++ = 0xFF & (lval >> 8);
    *p   = 0xFF & lval;
    return(*(long *)benchar);
}

short natshort(sval)          /* coerce a bigendian short into a natural short */
  short sval;
{
    unsigned char benchar[2];
    register short natshort;

    *(short *)benchar = sval;
    natshort = benchar[0];
    natshort <<= 8;
    natshort |= benchar[1];
    return(natshort);
}

long natlong(lval)             /* coerce a bigendian long into a natural long */
  long lval;
{
    unsigned char benchar[4];
    register unsigned char *p = benchar;
    register long natlong;

    *(long *)benchar = lval;
    natlong = *p++;
    natlong <<= 8;
    natlong |= *p++;
    natlong <<= 8;
    natlong |= *p++;
    natlong <<= 8;
    natlong |= *p;
    return(natlong);
}

void aiffWriteHdr(fd,sampsize,nchls,sr) /* Write AIFF header at start of file.   */
  int fd;               		/* Called after open, before data writes */
  int sampsize; /* sample size in bytes */
  int nchls;
  double sr;	/* sampling rate */
{
#if DEBUG
	printf("aiffWriteHdr: fd %d sampsize %d nchls %d sr %lf\n",
		fd,sampsize,nchls,sr);
#endif
	sframe_size = sampsize * nchnls;
	form.ckHdr.ckID = *(long *) FORM_ID;
	form.ckHdr.ckSize = 0;  		/* leave for aiffReWriteHdr */
	form.formType = *(long *) FORM_TYPE;
	comm1.ckHdr.ckID = *(long *) COMM_ID;
	comm1.ckHdr.ckSize = benlong((long)sizeof(short) + sizCommChunk2);
	comm1.numChannels = benshort((short)nchls);
        comm2.numSampleFrames = 0;	        /* leave for aiffReWriteHdr */
	comm2.sampleSize = benshort((short)(sampsize * 8));
	double_to_ieee_80(sr,comm2.sampleRate);  /* insert 80-bit srate */
	ssnd.ckHdr.ckID = *(long *) SSND_ID;
	ssnd.ckHdr.ckSize = 0;  		/* leave for aiffReWriteHdr */
	ssnd.offset = 0;
	ssnd.blockSize = 0;

	if ( write(fd, (char *)&form, sizFormHdr) != sizFormHdr
	  || write(fd, (char *)&comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, (char *)&comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, (char *)&ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	    die("error writing AIFF header");
}
             
void aiffReWriteHdr(fd, datasize)  /* Write proper sizes into AIFF header */
  int   fd;                        /*         called before closing file  */
  long  datasize;                  /*         & optionally under -R       */
{
        long endpos = tell(fd);
	long num_sframes, ssnd_size, form_size;

	if (datasize != endpos - aiffhdrsiz)
	    die("inconsistent AIFF sizes");
	num_sframes = datasize / sframe_size;
	ssnd_size = datasize + 2 * sizeof(long);
	form_size = endpos - sizeof(CkHdr);
#if DEBUG
	printf("aiffReWriteHdr: fd %d\n", fd);
	printf("endpos %lx num_sframes %lx ssnd_size %lx form_size %lx\n",
		endpos, num_sframes, ssnd_size, form_size);
#endif
	form.ckHdr.ckSize = benlong(form_size);
	comm2.numSampleFrames = benlong(num_sframes);
	ssnd.ckHdr.ckSize = benlong(ssnd_size);
	if (lseek(fd, 0L, 0))
	    die("seek error while updating AIFF header");
	if ( write(fd, (char *)&form, sizFormHdr) != sizFormHdr
	  || write(fd, (char *)&comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, (char *)&comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, (char *)&ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	    die("error while rewriting AIFF header");
}

int is_aiff_form(firstlong)   /* test a long for aiff form ID                 */
  long firstlong;             /* called by readheader prior to aiffReadHeader */
{
        return (firstlong == *(long *)FORM_ID);
}

typedef struct {
  short markerID;
  long  position;
} MARKER;

void aiffReadHeader(fd,fname,hdr,firstlong,p) /* Read AIFF header, fill hdr, &  */
  int fd;             			      /* postn rd ptr to start of samps */
  char *fname;
  HEADATA *hdr;	/* datablock for passing data back */
  long firstlong;
  SOUNDIN *p;
{
	CkHdr        ckHdr;
        FormHdr      form;
	CommChunk1   comm1;
	CommChunk2   comm2;
	InstrChunk   instr;
	SoundDataHdr ssnd;
	int mark_read = 0, inst_read = 0, loops_read = 0;
	int comm_read = 0, ssnd_read = 0;
	long ssnd_offset, ssnd_pos, pos, ckSize;
	short sampsize, nmarkers = 0, nn;
	MARKER  *markersp, *mp;
	Loop    *ilp;
	AIFFDAT *adp;
	char    *err;
	double  sr, oct;
extern  double  ieee_80_to_double();

	p->filetyp = 0;             /* ensure no bytrevs in sreadin for now */
	if (!is_aiff_form(firstlong))   /* double check it's a form header  */
	    die("bad form for aiffReadHeader");         /* & read remainder */
	sreadin(fd,(char *)&form + sizeof(long),sizeof(FormHdr) - sizeof(long),p);
	if (form.formType != *(long *) FORM_TYPE)
	    die("form header not type aiff");
	hdr->aiffdata = adp = (AIFFDAT *) mcalloc((long)sizeof(AIFFDAT));
	hdr->readlong = FALSE;
	adp->gainfac = 1.;
	while (1) {				     /* read in the next header */
	    if (sreadin(fd,(char *)&ckHdr,sizeof(CkHdr),p) < sizeof(CkHdr))
		break;
	    pos = tell(fd);
	    if (ckHdr.ckID == *(long *) COMM_ID) {    /* CommChunk hdr: rd rem 1 */
		sreadin(fd,(char *)&comm1 + sizeof(CkHdr), sizeof(short), p);
		sreadin(fd,(char *)&comm2, sizCommChunk2, p); /* + all of part 2 */
		sampsize = natshort(comm2.sampleSize);
		if (sampsize <= 8) {    	/* parse CommChunk to hdr format */
		    hdr->format = AE_CHAR;
		    hdr->sampsize = sizeof(char);
		}
		else if (sampsize <= 16) {
		    hdr->format = AE_SHORT;
		    hdr->sampsize = sizeof(short);
		}
		else if (sampsize <= 24)
		    die("AIFF 3-byte samples not supported");
		else {
		    hdr->format = AE_LONG;
		    hdr->sampsize = sizeof(long);
		}
		hdr->nchnls = natshort(comm1.numChannels);
		sr = ieee_80_to_double(comm2.sampleRate); /* decode 80-bit srate */
		hdr->sr = (long) sr;
		comm_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) MARK_ID) { 	/* MarkersChunk: */
	        sreadin(fd,(char *)&nmarkers, sizeof(short), p);
		nmarkers = natshort(nmarkers);
		markersp = (MARKER *) mcalloc((long)sizeof(MARKER) * nmarkers);
		for (nn = nmarkers, mp = markersp; nn--; mp++) {  /* for nmarkrs */
		    u_char psiz, pstring[256];             /* read ID/postn pair */
		    sreadin(fd,(char *)&mp->markerID, sizeof(short), p);
		    sreadin(fd,(char *)&mp->position, sizeof(long), p);
		    sreadin(fd,(char *)&psiz, 1, p);       /* leave unnatural,   */
		    psiz |= 01;                            /*     & skip pstring */
		    sreadin(fd, (char *)pstring, (int)psiz, p);
		}
		mark_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) INST_ID) { 	/* Instr Chunk:  */
	        int subhdrsiz = sizeof(InstrChunk) - sizeof(CkHdr);
	        sreadin(fd,(char *)&instr + sizeof(CkHdr), subhdrsiz, p);
		oct = (instr.baseNote + instr.detune/100.) / 12. + 3.;
		adp->natcps = pow((double)2., oct) * onept;
		adp->gainfac = exp((double)(natshort(instr.gain)) * log10d20);
		inst_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) SSND_ID) { 	/* SoundDataHdr: */
	        int subhdrsiz = sizeof(SoundDataHdr) - sizeof(CkHdr);
	        sreadin(fd,(char *)&ssnd + sizeof(CkHdr), subhdrsiz, p);
		ssnd_offset = natlong(ssnd.offset);
		ssnd_pos = pos + subhdrsiz + ssnd_offset;
		hdr->hdrsize = ssnd_pos;
		hdr->audsize = natlong(ckHdr.ckSize) - subhdrsiz - ssnd_offset;
		hdr->filetyp = TYP_AIFF;
		ssnd_read = TRUE;
	    }
	    if (mark_read && inst_read && !loops_read) {
		ilp = &instr.sustainLoop;
		adp->loopmode1 = natshort(ilp->playMode);
		for (nn = nmarkers, mp = markersp; nn--; mp++) {
		    if (mp->markerID == ilp->beginLoop)
		        adp->begin1 = natlong(mp->position);
		    if (mp->markerID == ilp->endLoop)
		        adp->end1 = natlong(mp->position);
		}
		ilp = &instr.releaseLoop;
		adp->loopmode2 = natshort(ilp->playMode);
		for (nn = nmarkers, mp = markersp; nn--; mp++) {
		    if (mp->markerID == ilp->beginLoop)
		        adp->begin2 = natlong(mp->position);
		    if (mp->markerID == ilp->endLoop)
		        adp->end2 = natlong(mp->position);
		}
		err = NULL;
		if (adp->natcps <= 0.0)
		    err = "baseNote";
		if (adp->loopmode1 < 0 || adp->loopmode1 > 3)
		    err = "sustain loop playMode";
		else if (adp->loopmode1
		  && (adp->begin1 < 0 || adp->begin1 >= adp->end1))
		    err = "sustain loop";
		else if (adp->loopmode2 < 0 || adp->loopmode2 > 3)
		    err = "release loop playMode";
		else if (adp->loopmode2
		  && (adp->begin2 < 0 || adp->begin2 >= adp->end2))
		    err = "release loop";
		if (err != NULL) {
		    printf("INFILE ERROR: illegal %s info in aiff file %s\n",
			   err,fname);
		    hdr->aiffdata = NULL;
		    free((char *)adp);
		}
		free(markersp);
		loops_read = TRUE;
	    }    
				     /* if read CommonChunk,SoundDataHdr,Loops, */
	    if (comm_read && ssnd_read && loops_read)		/*   we're done */
	        break;
	    ckSize = natlong(ckHdr.ckSize); /* else seek past this chunk to nxt */
	    if (ckSize & 1)  ckSize++;      /*      rnded up to even byte bndry */
	    if (lseek(fd, pos + ckSize, 0) != pos + ckSize)
		die("error while seeking past AIFF chunk");
	}

	if ((adp = hdr->aiffdata) == NULL)
	    return;
	printf("%s: AIFF, %ld%s samples", fname,
	    hdr->audsize/hdr->sampsize/hdr->nchnls, hdr->nchnls==1 ?"":" stereo");
	if (inst_read)
	    printf(", baseFrq %4.1f (midi %d), gain %d db",
		   adp->natcps, instr.baseNote, natshort(instr.gain));
	else printf(", no baseFreq or Gain");
	if (loops_read) {
	    printf(", sustnLp: mode %d", adp->loopmode1);
	    if (adp->loopmode1)
	        printf(", %ld to %ld", adp->begin1,adp->end1);
	    printf(", relesLp: mode %d", adp->loopmode2);
	    if (adp->loopmode2)
	        printf(", %ld to %ld", adp->begin2,adp->end2);
	    printf("\n");
	}
	else printf(", no looping\n");
	if (lseek(fd,ssnd_pos,0) != ssnd_pos)
	    die("error seeking to start of sound data");
}
