#include "cs.h"			/*				 MAIN.C	*/
#include "soundio.h"

#ifdef THINK_C
#define main tc_main
#endif

#ifdef __ZTC__
unsigned int _stack = 0xFFF0U;
#endif

static  int	ScotScore = 0, stdinassgn = 0;
static  char	*scorename = NULL;
static  char	*xfilename = NULL;
static  char	*sortedscore = "score.srt";
static  char	*xtractedscore = "score.xtr";
static  char	*playscore = "score.srt";     /* unless we extract */
static  FILE    *scorin, *scorout, *xfile;
static  void    dieu(), usage();
extern	OPARMS	O;
char	*orchname = NULL;  /* used by rdorch */

#define FIND(MSG)   if (*s == '\0')  \
			if (!(--argc) || (s = *++argv) && *s == '-') \
			    dieu(MSG);

main(argc,argv)
 int argc;
 char **argv;
{
	register char c, *s;
	char  outformch, *filnamp, *envoutyp = NULL;
	int   n;
extern  int   getsizformat(), musmon();
extern  char  *getstrformat();
extern  void  hetro(), lpanal(), pvanal(), sndinfo();

#ifdef __ZTC__
#ifdef WITHx87
	extern int _8087;
	if (_8087 == 0)
	    die("this version of Csound requires an 80x87");
#endif
#endif
#ifndef THINK_C
	{
	    char *getenv();
	    if ((envoutyp = getenv("SFOUTYP")) != NULL) {
	        if (strcmp(envoutyp,"AIFF") == 0)
		    O.filetyp = TYP_AIFF;
		else if (strcmp(envoutyp,"WAV") == 0)
		    O.filetyp = TYP_WAV;
		else {
		    sprintf(errmsg,"%s not a recognized SFOUTYP env setting",
			    envoutyp);
		    dieu(errmsg);
		}
	    }
	}
#endif
	O.filnamspace = filnamp = mmalloc((long)1024);
	if (!(--argc))
	    dieu("insufficient arguments");
	do {
	    s = *++argv;
	    if (*s++ == '-')    		      /* read all flags:  */
	        while ((c = *s++) != '\0')
		    switch(c) {
		    case 'U': FIND("no utility name")
		              if (strcmp(s,"hetro") == 0) {
				  printf("util HETRO:\n");
				  hetro(argc,argv);
			      }
		              if (strcmp(s,"lpanal") == 0) {
				  printf("util LPANAL:\n");
				  lpanal(argc,argv);
			      }
		              if (strcmp(s,"pvanal") == 0) {
				  printf("util PVANAL:\n");
				  pvanal(argc,argv);
			      }
		              if (strcmp(s,"sndinfo") == 0) {
				  printf("util SNDINFO:\n");
				  sndinfo(argc,argv);
			      }
		              dies("-U %s not a valid UTIL name",s);
		    case 'C': O.usingcscore = 1;     /* use cscore processing  */
		              break;
		    case 'I': O.initonly = 1; 		/* I-only implies */
		    case 'n': O.sfwrite = 0;  		/* nosound	  */
		              break;
		    case 'i': FIND("no infilename")
		              O.infilename = filnamp;	/* soundin name */
		              while ((*filnamp++ = *s++));  s--;
		              if (strcmp(O.infilename,"stdout") == 0)
				  dieu("-i cannot be stdout");
		              if (strcmp(O.infilename,"stdin") == 0)
#ifdef THINK_C
				  dieu("stdin audio not supported");
#else
		              {
				  if (stdinassgn)
				      dieu("-i: stdin previously assigned");
				  stdinassgn = 1;
			      }
#endif
		              O.sfread = 1;
		              break;
		    case 'o': FIND("no outfilename")
		              O.outfilename = filnamp;		/* soundout name */
		              while ((*filnamp++ = *s++)); s--;
		              if (strcmp(O.outfilename,"stdin") == 0)
				  dieu("-o cannot be stdin");
		              if (strcmp(O.outfilename,"stdout") == 0) {
#ifdef THINK_C
				  dieu("stdout audio not supported");
#else
				  if ((O.stdoutfd = dup(1)) < 0) /* redefine stdout */
				      die("too many open files");
				  dup2(2,1);                /* & send 1's to stderr */
#endif
			      }
		              break;
		    case 'b': FIND("no iobufsamps")
		              sscanf(s,"%d",&O.outbufsamps);/* defaults in musmon.c */
		              O.inbufsamps = O.outbufsamps;
		              while (*++s);
		              break;
		    case 'B': FIND("no hardware bufsamps")
		              sscanf(s,"%d",&O.oMaxLag);/* defaults in rtaudio.c */
		              while (*++s);
		              break;
		    case 'D':
#ifndef THINK_C
		              dieu("-D SoundDesigner files on Mac only");
#endif
		              O.filetyp == TYP_SD2;
		              break;
		    case 'A': if (O.filetyp == TYP_WAV) {
		                  if (envoutyp == NULL) goto outtyp;
				  warning("-A overriding local default WAV out");
			      }
		              O.filetyp = TYP_AIFF;     /* AIFF output request  */
		              break;
		    case 'W': if (O.filetyp == TYP_AIFF) {
		                  if (envoutyp == NULL) goto outtyp;
				  warning("-W overriding local default AIFF out");
			      }
		              O.filetyp = TYP_WAV;      /* WAV output request  */
		              break;
		    case 'h': O.sfheader = 0;           /* skip sfheader  */
		              break;
		    case 'c': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_CHAR;	/* 8-bit char soundfile */
		              break;
		    case 'a': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_ALAW;	/* a-law soundfile */
		              break;
		    case 'u': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_ULAW;	/* mu-law soundfile */
		              break;
		    case 's': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_SHORT;	/* short_int soundfile */
		              break;
		    case 'l': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_LONG;	/* long_int soundfile */
		              break;
		    case 'f': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_FLOAT;	/* float soundfile */
		              break;
		    case 'r': FIND("no sample rate")
		              sscanf(s,"%ld",&O.sr_override);
		              while (*++s);
		              break;
		    case 'k': FIND("no control rate")
		              sscanf(s,"%ld",&O.kr_override);
		              while (*++s);
		              break;
		    case 'v': O.odebug = odebug = 1;	/* verbose otran  */
		              break;
		    case 'm': FIND("no message level")
		              sscanf(s,"%d",&O.msglevel);
		              while (*++s);
		              break;
		    case 'd': O.displays = 0;         	/* no func displays */
		              break;
		    case 'g': O.graphsoff = 1;         	/* don't use graphics */
		              break;
		    case 'S': ScotScore++;
		              break;
		    case 'x': FIND("no xfilename")
		              xfilename = s;  		/* extractfile name */
		              while (*++s);
		              break;
		    case 't': FIND("no tempo value")
		              sscanf(s,"%d",&O.cmdTempo);/* use this tempo ..  */
		              while (*++s);
			      if (O.cmdTempo <= 0) dieu("illegal tempo");
			      O.Beatmode = 1;        /* on uninterpreted Beats */
		              break;
		    case 'L': FIND("no Linein score device_name")
		              O.Linename = filnamp;	/* Linein device name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.Linename,"stdin")) {
				  if (stdinassgn)
				      dieu("-L: stdin previously assigned");
				  stdinassgn = 1;
			      }
	                      O.Linein = 1;
		              break;
		    case 'M': FIND("no midi device_name")
		              O.Midiname = filnamp;	/* Midi device name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.Midiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-M: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      O.Midiin = 1;
		              break;
		    case 'F': FIND("no midifile name")
		              O.FMidiname = filnamp;	/* Midifile name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.FMidiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-F: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      O.FMidiin = 1;          /***************/
		              break;
		    case 'P': FIND("no pedal threshold")
		              sscanf(s,"%d",&O.SusPThresh);
		              while (*++s);
		              break;
		    case 'R': O.rewrt_hdr = 1;
		              break;
		    case 'H': O.heartbeat = 1;
		              break;
		    case 'N': O.ringbell = 1;         	/* notify on completion */
		              break;
		    case 'T': O.termifend = 1;       /* terminate on midifile end */
		              break;
		    default:  sprintf(errmsg,"unknown flag -%c", c);
		              dieu(errmsg);
		    }
	    else {
	        if (orchname == NULL)
		    orchname = --s;
	        else if (scorename == NULL)
		    scorename = --s;
		else dieu("too many arguments");
	    }
	} while (--argc);

	if (O.Linein || O.Midiin || O.FMidiin)
	    O.RTevents = 1;
	if (O.RTevents || O.sfread)
	    O.ksensing = 1;
	if (!O.outformat)                       /* if no audioformat yet  */
	    O.outformat = AE_SHORT;             /*  default to short_ints */
	O.outsampsiz = getsizformat(O.outformat);
	O.informat = O.outformat; /* informat defaults; resettable by readinheader */
	O.insampsiz = O.outsampsiz;
	if (O.filetyp == TYP_AIFF) {
	    if (!O.sfheader)
	        dieu("can't write AIFF soundfile with no header");
	    if (O.outformat == AE_ALAW || O.outformat == AE_ULAW
	      || O.outformat == AE_FLOAT) {
	        sprintf(errmsg,"AIFF does not support %s encoding",
		     getstrformat(O.outformat));
		dieu(errmsg);
	    }
	}
	if (O.filetyp == TYP_WAV) {
	    if (!O.sfheader)
	        dieu("can't write WAV soundfile with no header");
	    if (O.outformat == AE_ALAW || O.outformat == AE_ULAW
	      || O.outformat == AE_FLOAT) {
	        sprintf(errmsg,"WAV does not support %s encoding",
		     getstrformat(O.outformat));
		dieu(errmsg);
	    }
	}
	if (O.rewrt_hdr && !O.sfheader)
	    dieu("can't rewrite header if no header requested");
	if (O.sr_override || O.kr_override) {
	    long ksmpsover;
	    if (!O.sr_override || !O.kr_override)
	        dieu("srate and krate overrides must occur jointly");
	    ksmpsover = O.sr_override / O.kr_override;
	    if (ksmpsover * O.kr_override != O.sr_override)
	        dieu("command-line srate / krate not an integer");
	}
	if (orchname == NULL)
	    dieu("no orchestra name");
	else fprintf(stderr,"orchname:  %s\n", orchname);
	if (scorename != NULL)
	    fprintf(stderr,"scorename: %s\n", scorename);
	if (xfilename != NULL)
	    fprintf(stderr,"xfilename: %s\n", xfilename);
#ifdef SYS5
	{
	  static  char  buf[80];
	  VMSG(setvbuf(stdout,buf,_IOLBF,80);)
	}
#else
#ifndef THINK_C
	VMSG(setlinebuf(stdout);)
#endif
#endif
	if (scorename == NULL) {
	    if (O.RTevents) {
	        fprintf(stderr,"realtime performance using dummy numeric scorefile\n");
		goto perf;
	    }
	    else scorename = "score.srt";
	}
	if (ScotScore) {                          /* if score in Scot format  */
	    if (!(scorin = fopen(scorename, "r")))
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen("score", "w")))
	        die("cannot open scotout score for writing");
	    fprintf(stderr,"translating Scot score ...\n");
	    scot(scorin, scorout, scorename);      /*    do Scot translation  */
	    fclose(scorin);
	    fclose(scorout);
	    scorename = "score";                   /*    and use this "score" */
	}
	if ((n = strlen(scorename)) > 4            /* if score ?.srt or ?.xtr */
	  && (!strcmp(scorename+n-4,".srt")
	      || !strcmp(scorename+n-4,".xtr"))) {
	    fprintf(stderr,"using previous %s\n",scorename);
	    playscore = sortedscore = scorename;            /*   use that one */
	}
	else {
	    if (!(scorin = fopen(scorename, "r")))          /* else sort it   */
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen(sortedscore, "w")))
	        dies("cannot open %s for writing", sortedscore);
	    fprintf(stderr,"sorting score ...\n");
	    scsort(scorin, scorout);
	    fclose(scorin);
	    fclose(scorout);
	}
	if (xfilename != NULL) {                        /* optionally extract */
	    if (!strcmp(scorename,"score.xtr"))
	        dies("cannot extract %s, name conflict",scorename);
	    if (!(xfile = fopen(xfilename, "r")))
	        dies("cannot open extract file %s", xfilename);
	    if (!(scorin = fopen(sortedscore, "r")))
	        dies("cannot reopen %s", sortedscore);
	    if (!(scorout = fopen(xtractedscore, "w")))
	        dies("cannot open %s for writing", xtractedscore);
	    fprintf(stderr,"  ... extracting ...\n");
	    scxtract(scorin, scorout, xfile);
	    fclose(scorin);
	    fclose(scorout);
	    playscore = xtractedscore;
	}	    
	fprintf(stderr,"\t... done\n");

	s = playscore;
	O.playscore = filnamp;
	while ((*filnamp++ = *s++));	/* copy sorted score name */

perf:	O.filnamsize = filnamp - O.filnamspace;
	otran();		/* read orcfile, setup desblks & spaces     */
	return musmon();        /* load current orch and play current score */



outtyp: dieu("output soundfile cannot be both AIFF and WAV");

outform: sprintf(errmsg,"sound output format cannot be both -%c and -%c",
		outformch, c);
	dieu(errmsg);
}

static void dieu(s)
 char *s;
{
        fprintf(stderr,"Csound Command ERROR:\t%s\n",s);
	usage();
}

static void usage()
{
fprintf(stderr,"Usage:\tcsound [-flags] orchfile scorefile\n");
fprintf(stderr, "Legal flags are:\n");
fprintf(stderr,"-U unam\trun utility program unam\n");
fprintf(stderr,"-C\tuse Cscore processing of scorefile\n");
fprintf(stderr,"-I\tI-time only orch run\n");
fprintf(stderr,"-n\tno sound onto disk\n");
fprintf(stderr,"-i fnam\tsound input filename\n");
fprintf(stderr,"-o fnam\tsound output filename\n");
fprintf(stderr,"-b N\tsample frames (or -kprds) per software sound I/O buffer\n");
fprintf(stderr,"-B N\tsamples per hardware sound I/O buffer\n");
fprintf(stderr,"-A\tcreate an AIFF format output soundfile\n");
fprintf(stderr,"-W\tcreate a WAV format output soundfile\n");
fprintf(stderr,"-h\tno header on output soundfile\n");
fprintf(stderr,"-c\t8-bit signed_char sound samples\n");
fprintf(stderr,"-a\talaw sound samples\n");
fprintf(stderr,"-u\tulaw sound samples\n");
fprintf(stderr,"-s\tshort_int sound samples\n");
fprintf(stderr,"-l\tlong_int sound samples\n");
fprintf(stderr,"-f\tfloat sound samples\n");
fprintf(stderr,"-r N\torchestra srate override\n");
fprintf(stderr,"-k N\torchestra krate override\n");
fprintf(stderr,"-v\tverbose orch translation\n");
fprintf(stderr,"-m N\ttty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings\n");
fprintf(stderr,"-d\tsuppress all displays\n");
fprintf(stderr,"-g\tsuppress graphics, use ascii displays\n");
fprintf(stderr,"-S\tscore is in Scot format\n");
fprintf(stderr,"-x fnam\textract from score.srt using extract file 'fnam'\n");
fprintf(stderr,"-t N\tuse uninterpreted beats of the score, initially at tempo N\n");
fprintf(stderr,"-L dnam\tread Line-oriented realtime score events from device 'dnam'\n");
fprintf(stderr,"-M dnam\tread MIDI realtime events from device 'dnam'\n");
fprintf(stderr,"-F fnam\tread MIDIfile event stream from file 'fnam'\n");
fprintf(stderr,"-P N\tMIDI sustain pedal threshold (0 - 128)\n");
fprintf(stderr,"-R\tcontinually rewrite header while writing soundfile (WAV/AIFF)\n");
fprintf(stderr,"-H\tprint a heartbeat character at each soundfile write\n");
fprintf(stderr,"-N\tnotify (ring the bell) when score or miditrack is done\n");
fprintf(stderr,"-T\tterminate the performance when miditrack is done\n");
fprintf(stderr,"flag defaults: csound -s -otest -b%d -B%d -m7 -P128\n",
	IOBUFSAMPS, IODACSAMPS);
        exit(1);
}
