
#include "cs.h"			/*				OLOAD.C		*/
#include "oload.h"

INSTRTXT *instrtxtp[MAXINSNO+1], instxtanchor;
short	*argoffspace;
float	*pool = NULL;

OPARMS	O = {0,0, 0,1,1,0, 0,0, 0,0, 0,0, 1,0,7, 0,0,0, 0,0,0,0, 0,0,128 };

static  float    *gbloffbas;

float	esr = DFLT_SR, ekr = DFLT_KR, ensmps = DFLT_KSMPS;
int	nchnls = DFLT_NCHNLS, ksmps = DFLT_KSMPS;

float	pi = 3.1415927, twopi = 6.2831853, tpidsr, mpidsr, mtpdsr, pid100;
float	hfkprd, *spin, *spout;
float	sicvt, kicvt, fmaxlen = MAXLEN;
float	dv32768, loscal, onedsr, onedkr;
int	nspin, nspout, spoutactive, pnum();
int	odebug = 0;

extern	void	cpsoctinit(), reverbinit(), sssfinit();
extern	OENTRY	opcodlst[];

#if CHKING
#include "chkin.c"
#endif

void oload()
{
	long   nn, combinedsize, gblabeg, lclabeg;
	float  *combinedspc, *gblspace, *fp1, *fp2;
	INSTRTXT *ip;
	OPTXT *optxt;

#if CHKING
	chkin();
#endif
	odebug = O.odebug;
	ip = instxtanchor.nxtinstxt;		/* for instr 0 optxts:  */
	optxt = (OPTXT *) ip;
	while ((optxt = optxt->nxtop) !=  NULL) {
	    TEXT  *ttp = &optxt->t;
	    ARGOFFS *inoffp, *outoffp;
	    int opnum = ttp->opnum;
	    if (opnum == ENDIN) break;
	    if (opnum == LABEL) continue;
	    outoffp = ttp->outoffs;			/* use unexpanded ndxes */
	    inoffp = ttp->inoffs;			/* to find sr.. assigns */
	    if (outoffp->count == 1 && inoffp->count == 1) {
	        short rindex = outoffp->indx[0] - O.poolcount;
		float conval = pool[inoffp->indx[0] - 1];
		switch(rindex) {
		case 1:  esr = conval;  break;		/* & use those values */
		case 2:  ekr = conval;  break;		/*  to set params now */
		case 3:  ksmps = ensmps = conval;  break;
		case 4:  nchnls = conval;  break;
		default: break;
		}
	    }
	}
	VMSG( printf("esr = %7.1f, ekr = %7.1f, ksmps = %d, nchnls = %d\n",
		   esr ,ekr, ksmps, nchnls); )
	if (O.sr_override) {		/* if command-line overrides, apply now */
	    esr = O.sr_override;
	    ekr = O.kr_override;
	    ksmps = ensmps = O.sr_override / O.kr_override;
	    printf("sample rate overrides: esr = %7.1f, ekr = %7.1f, ksmps = %d\n",
		   esr, ekr, ksmps);
	}
	combinedsize = (O.poolcount + O.gblfixed + O.gblacount * ksmps)
	  * sizeof(float);
	combinedspc = (float *)mcalloc((long)combinedsize);
	for (fp1 = pool, fp2 = combinedspc, nn = O.poolcount; nn--; )
	    *fp2++ = *fp1++;			/* copy pool into combined space */
	free((char *)pool);
	pool = combinedspc;
	gblspace = pool + O.poolcount;
	gblspace[0] = esr;			/*   & enter	*/
	gblspace[1] = ekr;			/*   rsvd word	*/
	gblspace[2] = ensmps;			/*   curr vals  */
	gblspace[3] = nchnls;
	gbloffbas = pool - 1;

	gblabeg = O.poolcount + O.gblfixed + 1;
	ip = &instxtanchor;
	while ((ip = ip->nxtinstxt) != NULL) {		/* EXPAND NDX for A Cells */
	    optxt = (OPTXT *) ip;			/*   (and set localen)    */
	    lclabeg = ip->pmax + ip->lclfixed + 1;
	    VMSG( printf("lclabeg %d\n",lclabeg); )
	    ip->localen = (ip->lclfixed + ip->lclacnt*ksmps) * sizeof(float);
	    while ((optxt = optxt->nxtop) !=  NULL) {
	        TEXT *ttp = &optxt->t;
		ARGOFFS *aoffp;
		long  n, indx, posndx;
		short *ndxp;
		int opnum = ttp->opnum;
		if (opnum == ENDIN) break;
		if (opnum == LABEL) continue;
		aoffp = ttp->outoffs;
		for (n=aoffp->count, ndxp=aoffp->indx; n--; ndxp++) {
		    if ((indx = *ndxp) > gblabeg)
		        indx = gblabeg + (indx - gblabeg) * ksmps;
		    else if (indx <= 0 && (posndx = -indx) > lclabeg
			     && indx >= LABELIM)
		        indx = -(lclabeg + (posndx - lclabeg) * ksmps);
		    else if (indx > 0 && indx <= 3 && O.sr_override
			     && ip == instxtanchor.nxtinstxt)  /* for instr 0 */
		        indx += 3;    /* deflect any old sr,kr,ksmps targets */
		    else continue;
		    if ((short)indx != indx)
		        die("indexing overflow error");
		    *ndxp = (short)indx;
		}
		aoffp = ttp->inoffs;
		for (n=aoffp->count, ndxp=aoffp->indx; n--; ndxp++) {
		    if ((indx = *ndxp) > gblabeg)
		        indx = gblabeg + (indx - gblabeg) * ksmps;
		    else if (indx <= 0 && (posndx = -indx) > lclabeg
			     && indx >= LABELIM)
		        indx = -(lclabeg + (posndx - lclabeg) * ksmps);
		    else continue;
		    if ((short)indx != indx)
		        die("indexing overflow error");
		    *ndxp = (short)indx;
		}
	    }
#ifdef THINK_C
	    STasks();                           /* on Mac, allow system events */
#endif
	}

	if ((nn = init0()) > 0)				/* run instr 0 inits */
	    die("header init errors");
	if (gblspace[0]/gblspace[1] != gblspace[2])	/* & chk consistency */
	    die("inconsistent sr, kr, ksmps");		/*   one more time   */
	tpidsr = twopi / esr;				/* now set internal  */
	mtpdsr = -tpidsr;				/*    consts	     */
	mpidsr = -pi / esr;
	pid100 = pi / 100.;
	sicvt = fmaxlen / esr;
	kicvt = fmaxlen / ekr;
	hfkprd = .5 / ekr;
	onedsr = 1. / esr;
	onedkr = 1. / ekr;
	dv32768 = 1. / 32768.;
	loscal = 1. / LOFACT;
	cpsoctinit();
	reverbinit();
	sssfinit();
	nspin = nspout = ksmps * nchnls;		/* alloc spin & spout  */
	spin =  (float *) mcalloc((long)nspout*sizeof(float));
	spout = (float *) mcalloc((long)nspout*sizeof(float));
}

 INSDS *
instance(insno)			/* create instance of an instr template	*/
 int insno;			/*   allocates and sets up all pntrs	*/
{
	INSTRTXT *tp;
	INSDS	*ip, *prvip;
	OPTXT	*optxt;
	OPDS	*opds, *prvids, *prvpds, *prvlds;
	OENTRY	*ep;
	LBLBLK  *lopds[NLABELS], **lopdsp = lopds;
	LARGNO	larg[NGOTOS], *largp = larg;
	int	n, pextent, opnum, reqd;
	char	*nxtopds, *opdslim;
	float	**argpp, *fltp,	*lclbas, *lcloffbas;
	ARGOFFS *aoffp;
	short	indx, *ndxp;

	tp = instrtxtp[insno];
	pextent = sizeof(INSDS) + tp->pextrab;		/* alloc new space,  */
	ip = (INSDS *) mcalloc((long)pextent + tp->localen + tp->opdstot);
	if ((prvip = tp->instance) == NULL)
	    tp->instance = ip;				/*    and add to     */
	else {
	    while (prvip->nxtinstance != NULL)		/*    txt instance   */
		prvip = prvip->nxtinstance;		/*    chain	     */
	    prvip->nxtinstance = ip;
	    ip->prvinstance = prvip;
	}
	lcloffbas = &ip->p0;
	lclbas = (float *)((char *)ip + pextent);	/* split local space */
	nxtopds = (char *)lclbas + tp->localen;
	opdslim = nxtopds + tp->opdstot;
	VMSG( printf("instr %d allocated at %lx\n\tlclbas %lx, opds %lx\n",
				insno,ip,lclbas,nxtopds); )
	optxt = (OPTXT *)tp;
	prvids = prvpds = (OPDS *)ip;
	while ((optxt = optxt->nxtop) != NULL) {     /* for each op in instr */
	    register TEXT *ttp = &optxt->t;
	    if ((opnum = ttp->opnum) == ENDIN)		/*  (until ENDIN)  */
		break;
	    ep = &opcodlst[opnum];			/* for all ops:     */
	    opds = (OPDS *) nxtopds;			/*   take reqd opds */
	    nxtopds += ep->dsblksiz;
	    VMSG( printf("op %d (%s) allocated at %lx\n",
			opnum,ep->opname,opds); )
	    opds->optext = optxt;			/* set common headata */
	    opds->insdshead = ip;
	    if (opnum == LABEL) {			/* LABEL:	*/
		register LBLBLK	*lblbp = (LBLBLK *) opds;
		lblbp->prvi = prvids;			/*    save i/p links */
		lblbp->prvp = prvpds;
		*lopdsp++ = lblbp;			/*    log the lbl bp */
		continue;				/*    for later refs */
	    }
	    if (!ep->thread) {				/* thread 1 OR 2:  */
		if (ttp->pftype == 'b') {
		    prvids = prvids->nxti = opds;
		    opds->iopadr = ep->iopadr;
		}
		else {
		    prvpds = prvpds->nxtp = opds;
		    opds->opadr = ep->kopadr;
		}
		goto args;
	    }
	    if (ep->thread & 01) {			/* thread 1:	    */
		prvids = prvids->nxti = opds;		/* link into ichain */
		opds->iopadr = ep->iopadr;		/*   & set exec adr */
		if (opds->iopadr == NULL)
		    die("null iopadr");
	    }
	    if (n = ep->thread & 06) {			/* thread 2 OR 4:   */
		prvpds = prvpds->nxtp = opds;		/* link into pchain */
		if (!(n & 04)
		  || ttp->pftype == 'k' && ep->kopadr != NULL)
		    opds->opadr = ep->kopadr;		/*	krate or    */
		else opds->opadr = ep->aopadr;		/*	arate	    */
		VMSG( printf("opadr = %lx\n",opds->opadr); )
		if (opds->opadr == NULL)
		    die("null opadr");
	    }
      args: argpp = (float **)((char *)opds + sizeof(OPDS));
	    VMSG( printf("argptrs:"); )
	    aoffp = ttp->outoffs;		/* for outarg codes: */
	    reqd = strlen(ep->outypes);
	    for (n=aoffp->count, ndxp=aoffp->indx; n--; reqd--) {
		if ((indx = *ndxp++) > 0)
		    fltp = gbloffbas + indx;	/* cvt index to lcl/gbl adr */
		else fltp = lcloffbas - indx;
		VMSG( printf("\t%lx", fltp); )
		*argpp++ = fltp;
	    }
	    while (reqd--) {     		/* if more outypes, pad */
		VMSG( printf("\tPADOUT"); )
		*argpp++ = NULL;
	    }
	    aoffp = ttp->inoffs;		/* for inarg codes: */
	    for (n=aoffp->count, ndxp=aoffp->indx; n--; ) {
	        if ((indx = *ndxp++) < LABELIM) {
		    VMSG( printf("\t***lbl"); )
		    largp->lblno = indx - MINSHORT;  /* if label ref, defer */
		    largp->argpp = argpp++;
		    largp++;
		}
		else {
		    if (indx > 0)
		        fltp = gbloffbas + indx; /* else cvt ndx to lcl/gbl */
		    else fltp = lcloffbas - indx;
		    VMSG( printf("\t%lx", fltp); )
		    *argpp++ = fltp;
		}
	    }
	    VMSG( putchar('\n'); )
	}
	if (nxtopds != opdslim) die("inconsistent opds total");
	while (--largp >= larg)
	    *largp->argpp = (float *) lopds[largp->lblno]; /* now label refs */
	return(ip);
}

int pnum(s)			/* check a char string for pnum format	*/
 register char *s;		/*   and return the pnum ( >= 0 )	*/
{				/* else return -1			*/
	int	n;

	if (*s == 'p' || *s == 'P')
		if (sscanf(++s, "%d", &n))
			return(n);
	return(-1);
}

