#include <stdio.h>
#include <ctype.h>
#include <midi.h>

FILE *sopen();

/*
** ADTOBB/BBTOAD -- Convert ascii decimal to binary bytes or vice-versa
**	psl 10/88
*/
main(argc,argv)
char *argv[];
{
	char *cp, *np;
	int i;
	FILE *fp;

	for (cp = np = argv[0]; *cp; )
	    if (*cp++ == '/')
		np = cp;
	fp = (FILE *) 0;
	for (i = 1; i < argc; i++) {
	    if (fp = sopen(argv[i], "r")) {
		if (*np == 'a')
		    atob(fp, stdout);
		else
		    btoa(fp, stdout);
		sclose(fp);
	    } else {
		fprintf(stderr, "%s: ", argv[0]);
		perror(argv[i]);
		fp = (FILE *) -1;
	    }
	}
	if (fp == (FILE *) 0) {
	    if (*np == 'a')
		atob(stdin,stdout);
	    else
		btoa(stdin,stdout);
	}
}

#define	ISDEC(x)	('0'<=(x)&&(x)<='9')
#define	DECOF(x)	((x)-'0')
#define	BASE		10

/*
** Read ascii decimal numbers from ifp and write binary bytes to ofp.
** The ascii decimal format is simply whitespace-separated decimal numbers.
** Only the characters 0-9, <SP>, <TAB>, <LF>, and ';' are legal.
** All characters on a line following a ';' are ignored.
*/
atob(ifp, ofp)
FILE *ifp, *ofp;
{
	char *cp, buf[512];
	int digits, value;

	while (fgets(buf, sizeof buf, ifp)) {
	    digits = value = 0;
	    for (cp = buf; *cp; cp++) {
		if (ISDEC(*cp)) {
		    digits++;
		    value = value * BASE + DECOF(*cp);
		} else {
		    if (*cp <= ' ' || *cp == ';') {
			if (digits) {
			    putc(value, ofp);
			    digits = value = 0;
			}
			if (*cp == ';')
			    break;
		    }
		}
	    }
	}
}

/*
** Read binary bytes from ifp and write ascii decimal numbers to ofp.
** The ascii decimal format is simply 3-digit decimal.
** Numbers are separated by a single space and 16 are put on each line.
*/
btoa(ifp, ofp)
FILE *ifp, *ofp;
{
	int c, i;

	for (i = 1; (c = getc(ifp)) != EOF; i++)
	    fprintf(ofp,"%3d%s", c & 0xff, (i & 0xF)? " " : "\n");
	if ((i & 0xF) != 1)
	    fprintf(ofp, "\n");
}
