
%/* We store the data in XDR form in the database. So we could
%   generate the most important functions with help of rpcgen. */

%/* Versionsnumber: */
%#define XDB_VERSION 0
%#define XDB_VER_STRING "XDB Version 0"

%/* Which xdb (XDR Database) */
enum xdb_type {
   XDB_FILE = 0,
   XDB_LOG  = 1
};

%/* This is the header for all database files. */
struct xdb_header {
   string   identifier<>;      /* XDB version string */
   uint32_t vers;              /* XDB version stamp */
   bool     log_present;       /* XDB log file exists */
   xdb_type type;              /* file type: file or log */
   uint32_t header_size;       /* Size of header -> start of first entry */
};

%/* What should we do with the log entry ? Add or delete. */
enum xdb_logaction {
   LOG_ADD = 0,
   LOG_DELETE = 1,
   LOG_IGNORE = 2
};

struct xdb_logentry {
   xdb_logaction action;       /* Delete or add ? */
   uint32_t hashkey;           /* hashkey for faster compare */
   string table_name <>;       /* Name of Table */
   string table_path <>;       /* Path to table file */
};
