/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nis_db.h"
#include "db_private.h"

bool_t
__nisdb_xdr_attr (XDR *xdrs, nis_attr *objp)
{
  if (!xdr_string (xdrs, &objp->zattr_ndx, ~0))
    return FALSE;
  if (!xdr_bytes (xdrs, (char **)&objp->zattr_val.zattr_val_val,
		  (u_int *)&objp->zattr_val.zattr_val_len, ~0))
    return FALSE;
  return TRUE;
}

static bool_t
_xdr_entry_col (XDR *xdrs, entry_col *objp)
{
  if (!xdr_u_int (xdrs, &objp->ec_flags))
    return FALSE;
  if (!xdr_bytes (xdrs, (char **) &objp->ec_value.ec_value_val,
                  (u_int *) &objp->ec_value.ec_value_len, ~0))
    return FALSE;
  return TRUE;
}

bool_t
__nisdb_xdr_entry_obj (XDR *xdrs, entry_obj *objp)
{
  if (!xdr_string (xdrs, &objp->en_type, ~0))
    return FALSE;
  if (!xdr_array (xdrs, (char **) &objp->en_cols.en_cols_val,
                  (u_int *) &objp->en_cols.en_cols_len, ~0,
                  sizeof (entry_col), (xdrproc_t) _xdr_entry_col))
    return FALSE;
  return TRUE;
}
static bool_t
_xdr_table_col (XDR *xdrs, table_col *objp)
{
  if (!xdr_string (xdrs, &objp->tc_name, 64))
    return FALSE;
  if (!xdr_u_int (xdrs, &objp->tc_flags))
    return FALSE;
  if (!xdr_u_int (xdrs, &objp->tc_rights))
    return FALSE;
  return TRUE;
}

bool_t
__nisdb_xdr_table_obj (XDR *xdrs, table_obj *objp)
{
  if (!xdr_string (xdrs, &objp->ta_type, 64))
    return FALSE;
  if (!xdr_int (xdrs, &objp->ta_maxcol))
    return FALSE;
  if (!xdr_u_char (xdrs, &objp->ta_sep))
    return FALSE;
  if (!xdr_array (xdrs, (char **) &objp->ta_cols.ta_cols_val,
                  (u_int *) &objp->ta_cols.ta_cols_len, ~0,
                  sizeof (table_col), (xdrproc_t) _xdr_table_col))
    return FALSE;
  if (!xdr_string (xdrs, &objp->ta_path, ~0))
    return FALSE;
  return TRUE;
}
