#! /bin/perl -w
#
# add a new directory to Sun's NIS+ Nameservice
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $opt="";
if ($ARGV[0] =~ /^-.*/) {
	$opt = shift @ARGV;
}
my $DIR = $ARGV[1];
my $MASTER = $ARGV[0];
my %R;
my $RETSTR;

print "nis_mkdir.pl @ARGV\n";
if (!defined($DIR) || !defined($MASTER)) {
	usage();
}

%R = Nisplus::check_domainname($DIR);
if ($R{"RET"}) {
	print STDERR $R{"TEXT"};
	exit 1;
}

$MASTER = Nisplus::absname($MASTER);
%R = Nisplus::check_server($MASTER);
 if ($R{"RET"}) { 
        print STDERR $R{"TEXT"}; 
        exit 1; 
 } 


print `nismkdir $opt $MASTER $DIR`;

my $parent = Nisplus::strip_first($DIR);
print `nisping $parent`;
exit $R{"RET"};
	

sub usage {
	print STDERR "usage: $0 domainname master\n";
	exit 1;
}

sub usage_rootdomain {
	print STDERR "usage: $0 domainname master netpassword\n";
	exit 1;
}
