#include <pwd.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "pwdutils.h"

#ifdef CRACKLIB_USE
	/* ok, we're using the crack library */
#ifndef CRACKLIB_DICTPATH
#define CRACKLIB_DICTPATH "/usr/local/lib/pw_dict"
#endif
#endif

#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')

char *
getoldpwd (struct passwd *pwd)
{
  static char oldpwd[20];

  strncpy (oldpwd, getpass ("Enter old password: "), sizeof (oldpwd) - 1);
  if (strncmp (pwd->pw_passwd, crypt (oldpwd, pwd->pw_passwd), 13))
    {
      fprintf (stderr, "Wrong password.\n");
      exit (1);
    }
  return oldpwd;
}

char *
getnewpwd (struct passwd *pwd)
{
#ifdef CRACKLIB_USE
  char *error_msg;
#endif /* CRACKLIB_USE */
  char *pwdstr = NULL, *cryptstr;
  char pwdstr1[10];
  char salt[2];
  uid_t gotuid;
  time_t tm;

  gotuid = getuid ();

redo_it:
  pwdstr = getpass ("Enter new password: ");
  if (pwdstr[0] == '\0' && gotuid != 0)
    {
      printf ("Password not changed.\n");
      exit (1);
    }
#ifdef CRACKLIB_USE
#ifdef DEBUG
  printf ("Using password crack library.\n");
  printf ("Using dictionary file: %s\n", CRACKLIB_DICTPATH);
#endif /* DEBUG */
  error_msg = FascistCheck (pwdstr, CRACKLIB_DICTPATH);
  if (error_msg)
    {
      printf ("Not a valid password: %s.\n", error_msg);
      goto redo_it;
    }
#else
#ifdef DEBUG
  printf ("Using internal password check functions.\n");
#endif /* DEBUG */
  if (verifypassword (pwd, pwdstr, gotuid) != 1)
    {
      goto redo_it;
    }
#endif /* CRACKLIB_USE */

  strncpy (pwdstr1, pwdstr, 9);
  pwdstr = getpass ("Re-type new password: ");

  if (strncmp (pwdstr, pwdstr1, 8))
    {
      printf ("You misspelled it. Password not changed.\n");
      exit (1);
    }

  time (&tm);
  salt[0] = bin_to_ascii (tm & 0x3f);
  salt[1] = bin_to_ascii ((tm >> 6) & 0x3f);
  cryptstr = crypt (pwdstr, salt);

  if (pwdstr[0] == 0)
    cryptstr = "";

  return cryptstr;

}

int 
verifypassword (struct passwd *pwd, char *pwdstr, uid_t gotuid)
{
  /* this function will verify the user's password 
   * for some silly things.  If we're using cracklib, then
   * this function is unused. -- MJD
   */
  /* return values: 0 = not ok, 1 = ok */

  char *p, *q;
  int ucase, lcase, other, r;

  if ((strlen (pwdstr) < 6) && gotuid)
    {
      printf ("The password must have at least 6 characters.\n");
      return 0;
    }

  other = ucase = lcase = 0;
  for (p = pwdstr; *p; p++)
    {
      ucase = ucase || isupper (*p);
      lcase = lcase || islower (*p);
      other = other || !isalpha (*p);
    }

  if ((!ucase || !lcase) && !other && gotuid)
    {
      printf ("The password must have both upper and lowercase ");
      printf ("letters, or non-letters.\n");
      return 0;
    }

  if (pwd->pw_passwd[0]
      && !strncmp (pwd->pw_passwd, crypt (pwdstr, pwd->pw_passwd), 13)
      && gotuid)
    {
      printf ("You cannot reuse the old password.\n");
      return 0;
    }

  r = 0;
  for (p = pwdstr, q = pwd->pw_name; *q && *p; q++, p++)
    {
      if (tolower (*p) != tolower (*q))
	{
	  r = 1;
	  break;
	}
    }

  for (p = pwdstr + strlen (pwdstr) - 1, q = pwd->pw_name;
       *q && p >= pwdstr; q++, p--)
    {
      if (tolower (*p) != tolower (*q))
	{
	  r += 2;
	  break;
	}
    }

  if (gotuid && r != 3)
    {
      printf ("Please don't use something like your username as password.\n");
      return 0;
    }
  return 1;			/* OK */
}
