/*
 * Types of land range from 0 to 100
 * 100 is very wet (deep see), and 0 is very dry (desert).
 */

/*
 * Give a random value from the seed, in the range 0 - 99.
 */

private int special_random(int seed1, int seed2) {
    int tmp;

    tmp = seed1 * 113 + seed2 * 511;
    if (tmp < 0)
	tmp = -tmp;
    return tmp % 100;
}

/*
 * Compute sin() of a value.
 * sin(100) == sin(0).
 */
int *curve;
private int sin(int val) {
    int ind;

    if (curve == 0)
	curve = ({ 0, 20, 40, 60, 80, 99, 99, 80, 60, 40, 20, 0 });
    ind = val * sizeof(curve) / 100 % sizeof(curve);
    if (ind < 0)
	ind += sizeof(curve);
    return curve[ind];
}
    
private int terrain_type(int x, int y) {
    return sin(x)*4/10 + sin(y)*4/10 + special_random(x, y)*2/10;
}

private string describe_terrain(int type) {
    string *desc;

    write("Terrain: " + type + "\n");
    if (desc == 0)
	desc = ({
	    "deadly desert",
	    "dry desert",
	    "dry step",
	    "step",
	    "step with bushes",
	    "small trees",
	    "groups of trees",
	    "forest",
	    "deep forest",
	    "marshes",
	    "watery area",
	    "sea",
	    "deep water",
	});
    type = type * sizeof(desc) / 100;
    return desc[type];
}

string get_terrain_string(int x, int y) {
    return describe_terrain(terrain_type(x, y));
}
