! ----------------------------------------------------------------------------
!  GRAMMAR:  Grammar table entries for the standard verbs library.
!
!  Supplied for use with Inform 5
!
!  The "meta-verbs", commands to the game rather than in the game, come first.
! ----------------------------------------------------------------------------
!  Grammar relating to "remove" improved, "in"/"out" added, "set to" - 14/4/94
!  ParseNumber stub added - 15/4
!  "consult" and "look up" added - 23/4
!  "give" grammar altered to single nouns only - 5/5
! ----------------------------------------------------------------------------

Verb meta "score"
                *                                -> Score;
Verb meta "fullscore" "full"
                *                                -> FullScore;
Verb meta "q" "quit" "die"
                *                                -> Quit;
Verb meta "restore"
                *                                -> Restore;
Verb meta "restart"
                *                                -> Restart;
Verb meta "verify"
                *                                -> Verify;
Verb meta "save"
                *                                -> Save;
Verb meta "script"
                *                                -> ScriptOn
                * "off"                          -> ScriptOff
                * "on"                           -> ScriptOn;
Verb meta "noscript"
                *                                -> ScriptOff;
Verb meta "superbrief" "short"
                *                                -> LMode3;
Verb meta "verbose" "long"
                *                                -> LMode2;
Verb meta "brief" "normal"
                *                                -> LMode1;

! ----------------------------------------------------------------------------
!  And now the game verbs.
! ----------------------------------------------------------------------------

Verb "take" "get" "pick" "lift"
                * "out"                          -> Exit
                * multi                          -> Take
                * multiinside "from" noun        -> Remove
                * "in" noun                      -> Enter
                * multiinside "off" noun         -> Remove
                * "off" held                     -> Disrobe
                * "inventory"                    -> Inv;
Verb "stand"
                *                                -> Exit
                * "up"                           -> Exit;
Verb "remove"
                * held                           -> Disrobe
                * multi                          -> Take
                * multiinside "from" noun        -> Remove;
Verb "shed" "doff" "disrobe"
                * held                           -> Disrobe; 
Verb "wear" "don"
                * held                           -> Wear;
Verb "put"
                * multiexcept "in" noun          -> Insert
                * multiexcept "into" noun        -> Insert
                * multiexcept "on" noun          -> PutOn
                * multiexcept "onto" noun        -> PutOn
                * "on" held                      -> Wear
                * "down" multiheld               -> Drop
                * multiheld "down"               -> Drop;
Verb "insert"
                * multiexcept "in" noun          -> Insert
                * multiexcept "into" noun        -> Insert;
Verb "empty"
                * noun                           -> Empty
                * "out" noun                     -> Empty
                * noun "out"                     -> Empty
                * noun "to" noun                 -> EmptyT
                * noun "into" noun               -> EmptyT
                * noun "on" noun                 -> EmptyT
                * noun "onto" noun               -> EmptyT;
Verb "transfer"
                * noun "to" noun                 -> Transfer;
Verb "drop" "throw" "discard"
                * multiheld                      -> Drop
                * multiexcept "in" noun          -> Insert
                * multiexcept "into" noun        -> Insert
                * multiexcept "on" noun          -> PutOn
                * multiexcept "onto" noun        -> PutOn
                * multiexcept "down" noun        -> Insert
                * held "at" noun                 -> ThrowAt
                * held "against" noun            -> ThrowAt;
Verb "give" "pay" "offer" "feed"
                * creature held                  -> GiveR
                * held "to" creature             -> Give
                * "over" held "to" creature      -> Give;
Verb "go" "walk" "run" "leave"
                *                                -> VagueGo
                * noun                           -> Go
                * "through" noun                 -> Enter;
Verb "inventory" "inv" "i"
                *                                -> Inv;
Verb "look" "l"
                *                                -> Look
                * "at" noun                      -> Examine
                * "inside" noun                  -> Search
                * "in" noun                      -> Search
                * "under" noun                   -> LookUnder
                * "through" noun                 -> Search
                * "up" special                   -> Consult;
Verb "consult"  * noun "about" special           -> Consult;
Verb "open" "unwrap" "uncover" "undo"
                * noun                           -> Open
                * noun "with" held               -> Unlock;
Verb "close" "shut" "cover"
                * noun                           -> Close;
Verb "enter" "cross"
                *                                -> GoIn
                * noun                           -> Enter;
Verb "in" "inside"
                *                                -> GoIn;
Verb "exit" "out" "outside"
                *                                -> Exit;
Verb "examine" "x" "read" "watch" "describe" "check"
                * noun                           -> Examine;
Verb "yes" "y"
                *                                -> Yes;
Verb "no"
                *                                -> No;
Verb "sorry"
                *                                -> Sorry;
Verb "shit" "fuck" "damn" "sod"
                *                                -> Strong
                * special                        -> Strong;
Verb "bother" "curses" "drat" "darn"
                *                                -> Mild
                * special                        -> Mild;
Verb "search"
                * noun                           -> Search;
Verb "wave"
                *                                -> WaveHands
                * noun                           -> Wave;
Verb "set" "adjust"
                * noun                           -> Set
                * noun "to" special              -> SetTo;
Verb "pull" "drag"
                * noun                           -> Pull;
Verb "push" "move" "shift" "clear" "press"
                * noun                           -> Push
                * noun noun                      -> PushDir
                * noun "to" noun                 -> Transfer;
Verb "turn" "rotate" "twist" "unscrew" "screw"
                * noun                           -> Turn
                * noun "on"                      -> Switchon
                * noun "off"                     -> Switchoff
                * "on" noun                      -> Switchon
                * "off" noun                     -> Switchoff;
Verb "switch"
                * noun                           -> Switchon
                * noun "on"                      -> Switchon
                * noun "off"                     -> Switchoff
                * "on" noun                      -> Switchon
                * "off" noun                     -> Switchoff;
Verb "lock"
                * noun "with" held               -> Lock;
Verb "unlock"
                * noun "with" held               -> Unlock;
Verb "attack" "break" "smash" "hit" "fight" "wreck"
     "crack" "destroy" "murder" "kill" "torture"
                * noun                           -> Attack;
Verb "wait" "z"
                *                                -> Wait;
Verb "answer" "say" "shout" "speak"
                * special "to" creature          -> Answer;
Verb "ask"
                * creature "about" special       -> Ask;
Verb "eat"
                * held                           -> Eat;
Verb "sleep" "nap"
                *                                -> Sleep;
Verb "peel"
                * noun                           -> Take
                * "off" noun                     -> Take;
Verb "sing"
                *                                -> Sing;
Verb "climb" "scale"
                * noun                           -> Climb;
Verb "buy" "purchase"
                * special                        -> Buy;
Verb "squeeze" "squash"
                * noun                           -> Squeeze;
Verb "swim" "dive"
                *                                -> Swim;
Verb "swing"
                * noun                           -> Swing
                * "on" noun                      -> Swing;
Verb "blow"
                * held                           -> Blow;
Verb "pray"
                *                                -> Pray;
Verb "wake" "awake" "awaken"
                *                                -> Wake
                * "up"                           -> Wake
                * creature                       -> WakeOther
                * "up" creature                  -> WakeOther;
Verb "kiss" "embrace" "hug"
                * creature                       -> Kiss;
Verb "think"
                *                                -> Think;
Verb "smell" "sniff"
                *                                -> Smell
                * noun                           -> Smell;
Verb "hear" "listen"
                *                                -> Listen
                * noun                           -> Listen
                * "to" noun                      -> Listen;
Verb "taste"
                *                                -> Taste;
Verb "touch" "fondle" "feel" "grope"
                *                                -> Touch
                * noun                           -> TouchThing;
Verb "rub" "shine" "polish"
                * noun                           -> Rub;
Verb "tie" "attach" "fasten" "fix"
                * noun                           -> Tie
                * noun "to" noun                 -> Tie;
Verb "burn" "light"
                * noun                           -> Burn
                * noun "with" held               -> Burn;
Verb "drink" "swallow" "sip"
                * noun                           -> Drink;
Verb "fill"
                * noun                           -> Fill;
Verb "cut" "slice" "prune" "chop"
                * noun                           -> Cut;
Verb "jump" "skip" "hop"
                *                                -> Jump
                * "over" noun                    -> JumpOver;

! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------

#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub PrintRank       1;
#Stub PrintTaskName   1;
#Stub ParseNumber     2;
