/*		   ACK-3D ( Animation Construction Kit 3D )		      */
/* User routines      */
/* Author: Lary Myers */

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>
#include "ack3d.h"
#include "ackext.h"

typedef struct {
    unsigned	char	UseMouse;
    unsigned	char	UseFlash;
    unsigned	char	CenterRow;
    unsigned	char	SkyColor;
    unsigned	char	FloorColor;
    unsigned	char	FlashColor;
    unsigned	char	DoorSpeed;
		int	StartX;
		int	StartY;
		int	StartAngle;
		int	StartLevel;
		char	*MasterFile;
} INITENGINE;

typedef struct {
	    int	    xPlayer;
	    int	    yPlayer;
	    int	    PlayerAngle;
	    int	    MapPosn;
unsigned    int	    cbCondition;
unsigned    int	    Condition;
	    int	    (*cbFnc)(void);
} PLAYER;

#define CB_LEFTMOUSE	0x8000
#define CB_RIGHTMOUSE	0x4000
#define CB_PREDRAW	0x2000
#define CB_POSTDRAW	0x1000
#define CB_PREDOOR	0x0800
#define CB_POSTDOOR	0x0400
#define CB_MOVESQUARE	0x0200
#define CB_UPSQUARE	0x0100
#define CB_DOWNSQUARE	0x0080
#define CB_GOALSQUARE	0x0040
#define CB_HITWALL	0x0020
#define CB_HITOBJECT	0x0010


static	unsigned char	DoFlash;


/****************************************************************************
**									   **
****************************************************************************/
int InitializeEngine(INITENGINE *ie)
{

DoFlash	     = ie->UseFlash;
TopColor     = SkyColor = ie->SkyColor;
BottomColor  = FloorColor = ie->FloorColor;
FlashColor   = ie->FlashColor;
CenterRow    = ie->CenterRow;
if (CenterRow < 100 || CenterRow > 160)
    CenterRow = 120;

MaxObjects   = 0;
DoorSpeed    = ie->DoorSpeed;
if (!DoorSpeed)
    DoorSpeed = DEFAULT_DOOR_SPEED;

StartX	     = ie->StartX;
StartY	     = ie->StartY;
StartAngle   = ie->StartAngle;
CurrentLevel = ie->StartLevel;

if (BuildTables())
    return(-1);

if (ReadMasterFile(ie->MasterFile))
    return(-2);

if (ReadMapFile())
    return(-3);

BuildXYgrid();

TopColor    = SkyColor;
BottomColor = FloorColor;
xPlayer	    = StartX;
yPlayer	    = StartY;
PlayerAngle = StartAngle;
CosAngle    = CosTable[PlayerAngle];
SinAngle    = SinTable[PlayerAngle];

ObjList[0].Sides  = 0;
ObjList[0].VidRow = CenterRow;

if (ie->UseMouse)
    InitializeMouse();


keyBoardInit();
oldvec=getvect(KEYBD);
setvect(KEYBD,myInt);

graphinit();

PageNum = 1;
usepage(PageNum);

LoadPalette(PalFile);
NoWalls = 0;

return(0);
}


