
proc CreatePrefsDlg {} {
    global texturedir txfile txname default
    toplevel .prefsdlg
    wm minsize .prefsdlg 410 270
    wm geometry .prefsdlg 410x270
    wm title .prefsdlg Defaults
    frame .prefsdlg.top
    frame .prefsdlg.param
    frame .prefsdlg.middle
    frame .prefsdlg.middle.left
    frame .prefsdlg.middle.middle
    frame .prefsdlg.middle.right
    frame .prefsdlg.bot

    label .prefsdlg.top.flabel -text "fore region:"
    entry .prefsdlg.top.fentry -width 5 -textvariable default(freg)
    label .prefsdlg.top.blabel -text "back region:"
    entry .prefsdlg.top.bentry -width 5 -textvariable default(breg)
    label .prefsdlg.param.xlabel -text "xscale:"
    entry .prefsdlg.param.xentry -width 5 -textvariable default(xscale)
    label .prefsdlg.param.ylabel -text "yscale:"
    entry .prefsdlg.param.yentry -width 5 -textvariable default(yscale)
    label .prefsdlg.param.xplabel -text "xphase:"
    entry .prefsdlg.param.xpentry -width 5 -textvariable default(xphase)
    label .prefsdlg.param.yplabel -text "yphase:"
    entry .prefsdlg.param.ypentry -width 5 -textvariable default(yphase)
    pack .prefsdlg.top.flabel .prefsdlg.top.fentry \
	.prefsdlg.top.blabel .prefsdlg.top.bentry -side left
    pack .prefsdlg.param.xlabel .prefsdlg.param.xentry \
	.prefsdlg.param.ylabel .prefsdlg.param.yentry \
	.prefsdlg.param.xplabel .prefsdlg.param.xpentry \
	.prefsdlg.param.yplabel .prefsdlg.param.ypentry \
	-side left
    pack .prefsdlg.top .prefsdlg.param -side top

    listbox .prefsdlg.middle.left.box -geometry 10x10 \
	-yscrollcommand ".prefsdlg.middle.left.scroll set" \
	-relief sunken -exportselection false
    scrollbar .prefsdlg.middle.left.scroll -orient vertical \
	-command ".prefsdlg.middle.left.box yview" \
	-relief sunken

    listbox .prefsdlg.middle.middle.box -geometry 15x10 \
	-yscrollcommand ".prefsdlg.middle.middle.scroll set" \
	-relief sunken -exportselection false
    scrollbar .prefsdlg.middle.middle.scroll -orient vertical \
	-command ".prefsdlg.middle.middle.box yview" \
	-relief sunken

    listbox .prefsdlg.middle.right.box -geometry 15x10 \
	-yscrollcommand ".prefsdlg.middle.right.scroll set" \
	-relief sunken -exportselection false
    scrollbar .prefsdlg.middle.right.scroll -orient vertical \
	-command ".prefsdlg.middle.right.box yview" \
	-relief sunken

    button .prefsdlg.bot.b2 -text Close \
	-command { wm withdraw .prefsdlg }

    pack .prefsdlg.bot.b2

    pack .prefsdlg.middle.left.box -side left -expand yes -fill both
    pack .prefsdlg.middle.left.scroll -side right -fill y

    pack .prefsdlg.middle.middle.box -side left -expand yes -fill both
    pack .prefsdlg.middle.middle.scroll -side right -fill y

    pack .prefsdlg.middle.right.box -side left -expand yes -fill both
    pack .prefsdlg.middle.right.scroll -side right -fill y

    pack .prefsdlg.middle.left .prefsdlg.middle.middle .prefsdlg.middle.right \
	-side left -expand yes -fill both

    pack .prefsdlg.middle -side top -expand yes -fill both
    pack .prefsdlg.bot -side top
    tk_listboxSingleSelect \
	.prefsdlg.middle.left .prefsdlg.middle.middle .prefsdlg.middle.right
    bind .prefsdlg.middle.left.box <1> "SelectTexture %W %y"
    bind .prefsdlg.middle.middle.box <1> "SelectFRegion %W %y"
    bind .prefsdlg.middle.right.box <1> "SelectBRegion %W %y"
    wm withdraw .prefsdlg
}

proc UpdateRegions { } {
    global region rindex
    .prefsdlg.middle.middle.box delete 0 end
    .prefsdlg.middle.right.box delete 0 end
    if {[info exists region]} {
	for { set i 0 } { $i<$rindex } { incr i } {
	    .prefsdlg.middle.middle.box insert end $region($i)
	    .prefsdlg.middle.right.box insert end $region($i)
	}
    }
    
}

proc SelectTexture  { w y } {
    global default
    $w select from [$w nearest $y]
    set default(texture) [$w get [$w curselection]]
    echo $default(texture)
}

proc SelectFRegion  { w y } {
    global default
    $w select from [$w nearest $y]
    set default(freg) [$w curselection]
    echo $default(freg)
}

proc SelectBRegion  { w y } {
    global default
    $w select from [$w nearest $y]
    set default(breg) [$w curselection]
    echo $default(breg)
}
