/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


typedef struct {
     int rgb_cube_size;
     long *color_lookup;
} Palette_info;

typedef struct {
     int width, height;
     Palette_info palette;
} Graphics_info;

typedef int8 DevicePixel;


extern Graphics_info *init_graphics(int width, int height, Boolean blocky);
extern void end_graphics(void);
extern void update_screen(Framebuffer *fb);
extern Pixel *get_framebuffer_memory(int width, int height);
