#include "cs.h"			/*				OTRAN.C		*/
#include "oload.h"

static	NAME	*gblnames, *gblnxtslot, *gblnamlim;
static	NAME	*lclnames, *lclnxtslot, *lclnamlim;
static	ARGLST	*nullist;
static	ARGOFFS	*nulloffs;
static  short   lclkcnt, lcldcnt, lclwcnt, lclfixed;
static	short	lclnxtkcnt, lclnxtdcnt, lclnxtwcnt, lclnxtacnt;
static	short	gblnxtkcnt = 0, gblnxtacnt = 0, gblfixed, gblacount;
static	short	*nxtargoffp, *argofflim, lclpmax;
static	char	*strargspace, *strargptr;
static	long	poolcount, strargsize = 0, argoffsize;
static	float	tran_sr = DFLT_SR;
static	float	tran_kr = DFLT_KR;
static	float	tran_ksmps = DFLT_KSMPS;
	int	tran_nchnls = DFLT_NCHNLS;  /* used by rdorch  */
static	int	displop1, displop2, displop3, displop4;

extern	float	*pool;
extern	short	*argoffspace;
extern	OPARMS	O;

static	int	gexist(), gbloffndx(), lcloffndx(), constndx();
static	void	insprep(), lgbuild(), txtcpy(), gblnamset();
static	short	plgndx();
static  NAME    *lclnamset();
void	putop(), putstrg();

extern	INSTRTXT *instrtxtp[], instxtanchor;
extern	void	rdorchfile();
extern	int	getopnum();
extern	OENTRY	opcodlst[];

#define KTYPE   1
#define DTYPE   2
#define WTYPE   3
#define ATYPE   4
#define Dfloats (sizeof(DOWNDAT)/sizeof(float))
#define Wfloats (sizeof(SPECDAT)/sizeof(float))

#if CHKING
#include "chkout.c"
#endif

void otran()
{
	TEXT	*tp, *getoptxt();
register INSTRTXT *ip;
	 INSTRTXT *prvinstxt = &instxtanchor;
register OPTXT	*bp, *prvbp;
	ARGLST	*alp;
	char	*s;
register long	pmax, nn;
	long	n, opdstot, count, sumcount, instxtcount, optxtcount;
	float	*fp1, *fp2;
	
	gblnames = (NAME *)mmalloc((long)(GNAMES*sizeof(NAME)));
	lclnames = (NAME *)mmalloc((long)(LNAMES*sizeof(NAME)));
	gblnamlim = gblnames + GNAMES;
	lclnamlim = lclnames + LNAMES;
	gblnxtslot = gblnames;

	gblnamset("sr");		/* enter global reserved words */
	gblnamset("kr");
	gblnamset("ksmps");
	gblnamset("nchnls");
	gblnamset("$sr");		/* incl command-line overrides */
	gblnamset("$kr");
	gblnamset("$ksmps");

	displop1 = getopnum("print");	/* opnums that need "signal name" */
	displop2 = getopnum("display");
	displop3 = getopnum("dispfft");
	displop4 = getopnum("specdisp");

	rdorchfile();				/* go read orch file	*/
	while ((tp = getoptxt()) != NULL) {	/*   then for each opcode: */
	    int opnum = tp->opnum;
	    switch(opnum) {
	    case INSTR:
		ip = (INSTRTXT *) mcalloc((long)sizeof(INSTRTXT));
		prvinstxt = prvinstxt->nxtinstxt = ip;
		txtcpy((char *)&ip->t,(char *)tp);
		prvbp = (OPTXT *) ip;		/* begin an optxt chain */
		alp = ip->t.inlist;
		if (sscanf(alp->arg[0], "%ld", &n) && n) 
		    putop(&ip->t);		/* print, except i0 */ 
		for (nn = alp->count; nn>0; ) {
		    s = alp->arg[--nn];	/* log all insnos */
		    if (!(sscanf(s, "%ld", &n))
		      || n < 0 || n > MAXINSNO) {
			synterr("illegal instr number");
			continue;
		    }
		    if (instrtxtp[n] != NULL) {
			sprintf(errmsg,"instr %d redefined",n);
			synterr(errmsg);
		    }
		    instrtxtp[n] = ip;
		}
		lclnxtslot = lclnames;		/* clear lcl namlist */
		lclnxtkcnt = lclnxtdcnt = 0;	/*   for rebuilding  */
		lclnxtwcnt = lclnxtacnt = 0;
		opdstot = 0;
		pmax = 3;			/* set minimum pflds */
		break;
	    case ENDIN:
		bp = (OPTXT *) mcalloc((long)sizeof(OPTXT));
		txtcpy((char *)&bp->t, (char *)tp);
		prvbp->nxtop = bp;
		bp->nxtop = NULL;	/* terminate the optxt chain */
		VMSG( { putop(&bp->t);
			printf("pmax %d, kcnt %d, dcnt %d, wcnt %d, acnt %d\n",
			   pmax,lclnxtkcnt,lclnxtdcnt,lclnxtwcnt,lclnxtacnt); } )
		ip->pmax = pmax;
		ip->pextrab = ((n = pmax-3) > 0) ? n*sizeof(float) : 0;
		ip->lclkcnt = lclnxtkcnt;
		ip->lcldcnt = lclnxtdcnt;
		ip->lclwcnt = lclnxtwcnt;
		ip->lclacnt = lclnxtacnt;
		ip->lclfixed = lclnxtkcnt + lclnxtdcnt * Dfloats
					  + lclnxtwcnt * Wfloats;
		ip->opdstot = opdstot;		/* store total opds reqd */
		break;
	    default:
		bp = (OPTXT *) mcalloc((long)sizeof(OPTXT));
		txtcpy((char *)&bp->t,(char *)tp);
		prvbp = prvbp->nxtop = bp;	/* link into optxt chain */
		opdstot += opcodlst[opnum].dsblksiz;    /* sum opds's */
		VMSG( putop(&bp->t); )
		if (opnum == displop1)			/* display op arg ? */
		    for (alp=bp->t.inlist, nn=alp->count; nn>0; ) {
		        s = alp->arg[--nn];
		        strargsize += strlen(s) +  1;	/* sum the chars */
		    }
		if (opnum == displop2 || opnum == displop3 || opnum == displop4) {
		    alp=bp->t.inlist;
		    s = alp->arg[0];
		    strargsize += strlen(s) + 1;
		}
		for (alp=bp->t.inlist, nn=alp->count; nn>0; ) {
		    s = alp->arg[--nn];
		    if (*s == '"') {			/* "string" arg ? */
		        strargsize += strlen(s) - 1;	/* sum real chars */
		        continue;
		    }
		    if ((n = pnum(s)) >= 0)
			{ if (n > pmax)  pmax = n; }
		    else lgbuild(s);
		}
		for (alp=bp->t.outlist, nn=alp->count; nn>0; ) {
		    s = alp->arg[--nn];
		    if ((n = pnum(s)) >= 0)
			{ if (n > pmax)  pmax = n; }
		    else lgbuild(s);
		    if (!nn && *bp->t.opcod == 'r'		/* rsvd glbal = n ? */
		      && strcmp(bp->t.opcod,"r=") == 0) {	/*  (assume const)  */
			float constval = pool[constndx(bp->t.inlist->arg[0])];
		        if (strcmp(s,"sr") == 0)
			    tran_sr = constval;		/* modify otran defaults */
			else if (strcmp(s,"kr") == 0)
			    tran_kr = constval;
			else if (strcmp(s,"ksmps") == 0)
			    tran_ksmps = constval;
			else if (strcmp(s,"nchnls") == 0)
			    tran_nchnls = constval;
		    }
		}
		break;
	    }
	}

	if (tran_sr / tran_kr != tran_ksmps)
	    synterr("inconsistent sr, kr, ksmps");

	ip = instxtanchor.nxtinstxt;
	bp = (OPTXT *) ip;
	while ((bp = bp->nxtop) != NULL) {	/* chk instr 0 for illegal perfs */
	    int thread, opnum = bp->t.opnum;
	    if (opnum == ENDIN) break;
	    if (opnum == LABEL) continue;
	    if ((thread = opcodlst[opnum].thread) & 06
	      || !thread && bp->t.pftype != 'b')
		synterr("perf-pass statements illegal in header blk");
	}
	if (synterrcnt) {
	    printf("%d syntax errors in orchestra.  compilation invalid\n",
			synterrcnt);
	    exit(1);
	}
	VMSG(printf("poolcount = %d, strargsize = %d\n", poolcount,strargsize); )
	VMSG( { int n; float *p;
		printf("pool:");
		for (n = poolcount, p = pool; n--; p++)
		    printf("\t%g", *p);
	        printf("\n");  } )
	gblfixed = gblnxtkcnt;
	gblacount = gblnxtacnt;

	if (strargsize) {
	    strargspace = mcalloc((long)strargsize);
	    strargptr = strargspace;
	}
	ip = &instxtanchor;
	for (sumcount = 0; (ip = ip->nxtinstxt) != NULL; ) {/* for each instxt */
	    register OPTXT *optxt = (OPTXT *) ip;
	    register int optxtcount = 0;
	    while ((optxt = optxt->nxtop) != NULL) {	/* for each op in instr  */
	        register TEXT *ttp = &optxt->t;
		optxtcount += 1;
		if (ttp->opnum == ENDIN) break;		/*    (until ENDIN)      */
	        if ((count = ttp->inlist->count))
		    sumcount += count +1;		/* count the non-nullist */
		if ((count = ttp->outlist->count))	/* slots in all arglists */
		    sumcount += count +1;
	    }
	    ip->optxtcount = optxtcount;		/* optxts in this instxt */
	}
	argoffsize = (sumcount + 1) * sizeof(short);	/* alloc all plus 1 null */
	argoffspace = (short *) mmalloc((long)argoffsize);   /* as argoff shorts */
	nxtargoffp = argoffspace;
	nulloffs = (ARGOFFS *) argoffspace;    		/* setup the null argoff */
	*nxtargoffp++ = 0;
	argofflim = nxtargoffp + sumcount;
	ip = &instxtanchor;
	while ((ip = ip->nxtinstxt) != NULL)		/* add all other entries */
	    insprep(ip);				/*   as combined offsets */
	VMSG( { short *p = argoffspace;
		printf("argoff array:\n");
		do printf("\t%d", *p++);
		while (p < argofflim);
		printf("\n");	} )
	if (nxtargoffp != argofflim)
	    die("inconsistent argoff sumcount");
	if (strargsize && strargptr != strargspace + strargsize)
	    die("inconsistent strarg sizecount");

	ip = &instxtanchor;			/* set the OPARMS values */
	instxtcount = optxtcount = 0;
	while ((ip = ip->nxtinstxt) != NULL) {
	    instxtcount += 1;
	    optxtcount += ip->optxtcount;
	}
	O.instxtcount = instxtcount;
	O.optxtsize = instxtcount * sizeof(INSTRTXT)
	  + optxtcount * sizeof(OPTXT);
	O.poolcount = poolcount;
	O.gblfixed = gblnxtkcnt;
	O.gblacount = gblnxtacnt;
	O.argoffsize = argoffsize;
	O.argoffspace = (char *)argoffspace;
	O.strargsize = strargsize;
	O.strargspace = strargspace;

#if CHKING
	chkout();
#endif
}

static void insprep(tp)		/* prep an instr template for efficient allocs	*/
 INSTRTXT *tp;			/* repl arg refs by offset ndx to lcl/gbl space */
{
	OPTXT	*optxt;
	OENTRY	*ep;
	int	n, opnum, inreqd;
	char	**argp;
	char	*labels[NLABELS], **lblsp = labels;
	LBLARG	larg[NGOTOS], *largp = larg;
	ARGLST	*outlist, *inlist;
	ARGOFFS *outoffs, *inoffs;
	short	indx, *ndxp;

	lclkcnt = tp->lclkcnt;
	lcldcnt = tp->lcldcnt;
	lclwcnt = tp->lclwcnt;
	lclfixed = tp->lclfixed;
	lclnxtslot = lclnames;				/* clear lcl namlist */
	lclnxtkcnt = lclnxtdcnt = 0;			/*   for rebuilding  */
	lclnxtwcnt = lclnxtacnt = 0;
	lclpmax = tp->pmax;				/* set pmax for plgndx */
	ndxp = nxtargoffp;
	optxt = (OPTXT *)tp;
	while ((optxt = optxt->nxtop) != NULL) {	/* for each op in instr */
	    register TEXT *ttp = &optxt->t;
	    if ((opnum = ttp->opnum) == ENDIN)		/*  (until ENDIN)  */
		break;
	    if (opnum == LABEL) {
		if (lblsp - labels >= NLABELS)
		    die("LABELS list is full");
	        *lblsp++ = ttp->opcod;
		continue;
	    }
	    ep = &opcodlst[opnum];
	    VMSG( printf("%s argndxs:", ep->opname); )
	    if ((outlist = ttp->outlist) == nullist || !outlist->count)
		ttp->outoffs = nulloffs;
	    else {
		ttp->outoffs = outoffs = (ARGOFFS *) ndxp;
		outoffs->count = n = outlist->count;
		argp = outlist->arg;			/* get outarg indices */
		ndxp = outoffs->indx;
		while (n--) {
		    *ndxp++ = indx = plgndx(*argp++);
		    VMSG( printf("\t%d",indx); )
		}
	    }
	    if ((inlist = ttp->inlist) == nullist || !inlist->count)
		ttp->inoffs = nulloffs;
	    else {
		ttp->inoffs = inoffs = (ARGOFFS *) ndxp;
		inoffs->count = inlist->count;
		if (opnum == displop1) {		/* display op arg ? */
		    optxt->t.strarg = strargptr;
		    for (n=0; n < inlist->count; n++ ) {
		        char *s = inlist->arg[n];
		        do *strargptr++ = *s;		/*   copy all args  */
			while (*s++);
		    }
		}
		else if (opnum==displop2 || opnum==displop3 || opnum==displop4) {
		    char *s = inlist->arg[0];
		    optxt->t.strarg = strargptr;
		    do *strargptr++ = *s;		/*   or just the 1st */
		    while (*s++);
		}
		inreqd = strlen(ep->intypes);
		argp = inlist->arg;			/* get inarg indices */
		ndxp = inoffs->indx;
		for (n=0; n < inlist->count; n++, argp++, ndxp++) {
		    if (n < inreqd && ep->intypes[n] == 'l') {
			if (largp - larg >= NGOTOS)
			    die("GOTOS list is full");
			VMSG( printf("\t***lbl"); )     /* if arg is label,  */
			largp->lbltxt = *argp;
			largp->ndxp = ndxp;		/*  defer till later */
			largp++;
		    }
		    else {
			char *s = *argp;
			if (*s == '"') {		/* string argument:  */
			    optxt->t.strarg = strargptr;/*  save strargs ptr */
			    s++;
			    do {
			        register char c = *s++;
#ifdef THINK_C
			        if (c == '/')		/*  on Mac subst ':' */
				    c = ':';
#endif
			        *strargptr++ = c;	/*  copy w/o quotes  */
			    } while (*s != '"');
			    *strargptr++ = '\0';	/*  terminate string */
			    indx = 1;   		/*  cod=1st pool val */
			}
			else indx = plgndx(s);		/* else normal index */
			VMSG( printf("\t%d",indx); )
			*ndxp = indx;
		    }
		}
	    }
	    VMSG( putchar('\n'); )
	}
   nxt:	while (--largp >= larg) {			/* resolve the lbl refs */
	    char *s = largp->lbltxt;
	    char **lp;
	    for (lp = labels; lp < lblsp; lp++)
	        if (strcmp(s, *lp) == 0) {
		    *largp->ndxp = lp - labels + MINSHORT;
		    goto nxt;
		}
	    dies("target label '%s' not found", s);
	}
	nxtargoffp = ndxp;
#ifdef THINK_C
	STasks();                           /* on Mac, allow system events */
#endif
}

static void lgbuild(s)		/* build pool of floating const values	*/
 char *s;			/* build lcl/gbl list of ds names, offsets */
{				/*   (no need to save the returned values) */
	register char c;

	if (((c = *s) >= '0' && c <= '9')
	  || c == '.' || c == '-' || c == '+')
		constndx(s);
	else if (!(lgexist(s))) {
		if (c == 'g' || c == '#' && *(s+1) == 'g')
			gblnamset(s);
		else lclnamset(s);
	}
}

static short plgndx(s)	/* get storage ndx of const, pnum, lcl or gbl argument */
 char *s;		/* const/gbl indexes are positiv+1, pnum/lcl negativ-1 */
{			/* called only after poolcount & lclpmax are finalized */
	register char	c;
	short	n, indx;

	if (((c = *s) >= '0' && c <= '9')
	  || c == '.' || c == '-' || c == '+')
		indx = constndx(s) + 1;
	else if ((n = pnum(s)) >= 0)
		indx = - n;
	else if (c == 'g' || c == '#' && *(s+1) == 'g' || gexist(s))
		indx = poolcount + 1 + gbloffndx(s);
	else indx = - (lclpmax + 1 + lcloffndx(s));
	return(indx);
}

static int constndx(s)		/* get storage ndx of float const value	*/
 register char *s;		/* builds value pool on 1st occurrence	*/
{				/* final poolcount used in plgndx above  */
	float	newval;		/* pool may be moved w. ndx still valid */
	long	n;
register float	*fp;
register int	c;
register long   ival = 0L, iscale = 1L;
register char	*str = s;

	if (pool == NULL) {
	    pool = (float *)mmalloc((long)NCONSTS * sizeof(float));
	    *pool = SSTRCOD;
	    poolcount = 1;
	}
	while (*s == '-') { iscale = -iscale; s++; }	/* simulate scanf:  */
	while (*s == '+') s++;
	while (*s == '0') s++;
	while ((c = *s++) != '\0') {		/* collect the digits,	*/
	    if (c == '0')
		ival *= 10;
	    else if (c > '0' && c <= '9') {
		ival *= 10;
		ival += c;
		ival -= '0';
	    }
	    else if (c == '.') break;
	    else goto flerror;
	}
	if (c != '\0')
	    while ((c = *s++) != '\0') {
		if (c < '0' || c > '9')		
		    goto flerror;
		ival *= 10;
		ival += c;
		ival -= '0';
		iscale *= 10;
	    }
	newval = (float)ival / iscale;		/* & scale to float val	*/
	for (fp=pool,n=poolcount; n--; fp++)	/* now search constpool */
	    if (newval == *fp)			/* if val is there	*/
		return(fp - pool);		/*    return w. index	*/
	if (++poolcount > NCONSTS)
	    die("flconst pool is full");
	*fp = newval;				/* else enter newval	*/
	return(fp - pool);			/*   and return new ndx */

flerror:sprintf(errmsg,"numeric syntax '%s'",str);
	synterr(errmsg);
	return(0);
}

static void gblnamset(s)	/* builds namelist & type counts for gbl names */
 char *s;			
{
register NAME	*np;

	for (np=gblnames; np<gblnxtslot; np++)  /* search gbl namelist: */
	    if (strcmp(s,np->namep) == 0)	/* if name is there	*/
		return;				/*    return    	*/
	np->namep = s;				/* else record newname	*/
	if (*s == '#')	s++;
	if (*s == 'g')	s++;
	if (*s == 'a') {			/*   and its type-count */
		np->type = ATYPE;
		np->count = gblnxtacnt++;
	}
	else {
		np->type = KTYPE;
		np->count = gblnxtkcnt++;
	}
	if (++gblnxtslot >= gblnamlim)		/* chk for full table	*/
		die("gbl namelist is full");
}

static NAME *lclnamset(s)/* builds namelist & type counts for lcl names  */
 char *s;		/*   called by otran for each instr for lcl cnts */
{			/*   lists then redone by insprep via lcloffndx  */
register NAME	*np;

	for (np=lclnames; np<lclnxtslot; np++)  /* search lcl namelist: */
	    if (strcmp(s,np->namep) == 0)	/* if name is there	*/
		return(np);			/*    return ptr	*/
	np->namep = s;				/* else record newname	*/
	if (*s == '#')	s++;
	switch(*s) {				/*   and its type-count */
	  case 'd': np->type = DTYPE; np->count = lclnxtdcnt++; break;
	  case 'w': np->type = WTYPE; np->count = lclnxtwcnt++; break;
	  case 'a': np->type = ATYPE; np->count = lclnxtacnt++; break;
	  default:  np->type = KTYPE; np->count = lclnxtkcnt++; break;
	}
	if (++lclnxtslot >= lclnamlim)		/* chk for full table	*/
		die("lcl namelist is full");
	return(np);
}

static int gbloffndx(s)	/* get named offset index into gbl dspace	*/
 char *s;		/* called only after otran and gblfixed valid   */
{
register NAME	*np;
int indx;

	for (np=gblnames; np<gblnxtslot; np++)  /* search gbl namelist: */
	    if (strcmp(s,np->namep) == 0) {	/* if name is there	*/
	        if (np->type == ATYPE)
		    indx = gblfixed + np->count;
		else indx = np->count;  	/*    return w. index	*/
		return(indx);
	    }
	die("unexpected global name");		/* else complain	*/
}

static int lcloffndx(s)	/* get named offset index into instr lcl dspace */
 char *s;		/* calld by insprep aftr lclcnts,lclfixed valid */
{
register NAME	*np = lclnamset(s);		/* rebuild the table	*/
int indx;

	switch(np->type) {    			/* use cnts to calc ndx */
	  case KTYPE:  indx = np->count;  break;
	  case DTYPE:  indx = lclkcnt + np->count * Dfloats;  break;
	  case WTYPE:  indx = lclkcnt + lcldcnt * Dfloats
				       + np->count * Wfloats;  break;
	  case ATYPE:  indx = lclfixed + np->count;  break;
	  default:     die("unknown nametype");  break;
	}
	return(indx);			/*   and rtn this offset */
}

static int gexist(s)		/* tests whether variable name exists	*/
 char *s;			/*	in gbl namelist			*/
{
register NAME	*np;

	for (np = gblnames; np < gblnxtslot; np++) /* search gbl namelist: */
		if (strcmp(s,np->namep) == 0)	/* if name is there	*/
			return(1);		/*	return 1	*/
	return(0);				/* else return 0	*/
}

int lgexist(s)			/* tests whether variable name exists	*/
 char *s;			/*	in gbl or lcl namelist		*/
{
register NAME	*np;

	for (np = gblnames; np < gblnxtslot; np++) /* search gbl namelist: */
		if (strcmp(s,np->namep) == 0)	/* if name is there	*/
			return(1);		/*	return 1	*/
	for (np = lclnames; np < lclnxtslot; np++) /* search lcl namelist: */
		if (strcmp(s,np->namep) == 0)	/* if name is there	*/
			return(1);		/*	return 1	*/
	return(0);				/* cannot find, return 0 */
}

static void txtcpy(s,t)
 char *s, *t;
{
	int n = sizeof(TEXT);
	while (n--)
		*s++ = *t++;
}

void putop(tp)
 TEXT *tp;
{
	register int n, nn;

	if (n = tp->outlist->count) {
		nn = 0;
		while (n--)
			putstrg(tp->outlist->arg[nn++]);
	}
	else putchar('\t');
	putstrg(tp->opcod);
	if (n = tp->inlist->count) {
		nn = 0;
		while (n--)
			putstrg(tp->inlist->arg[nn++]);
	}
	putchar('\n');
}

void putstrg(cp)
 char *cp;
{
	while (*cp)
		putchar(*cp++);
	putchar('\t');
}

