#include "cs.h"			/*	       		SOUNDIO.C	*/
#include "soundio.h"

static  char	*sfoutname;     		    /* soundout filename    */
static	char	*inbuf,    *outbuf;   		    /* contin sndio buffers */
static	char	*chinbufp, *choutbufp;		    /* char  pntr to above  */
static	short	*shinbufp, *shoutbufp;		    /* short pntr	    */
static	long	*llinbufp, *lloutbufp;		    /* long  pntr	    */
static	float	*flinbufp, *floutbufp;		    /* float pntr	    */
static	unsigned inbufrem,  outbufrem;       	    /* in monosamps (see openin,iotranset) */
static	unsigned inbufsiz,  outbufsiz;   	    /* alloc in sfopenin/out     */
static	int	isfd, isfopen = 0, infilend = 0;    /* (real set in sfopenin)    */
static	int	osfd, osfopen = 0;      	    /* (real set in sfopenout)   */
static	int	pipdevin = 0, pipdevout = 0;	    /* mod by sfopenin,sfopenout */
static	float	fzero = 0.;
	long	nrecs = 0;
extern	float	*spin, *spout, maxamp[], *maxampend;
extern  long	rngcnt[];
extern	short	rngflg, multichan;
extern	int	nspin, nspout, nchnls, ksmps;
extern  HEADATA *readheader();
extern  short   ulaw_decode[];
extern	OPARMS	O;

static  SOUNDIN *p;    /* to be passed via sreadin() */
static	int	(*audrecv)(), audread();
static	void	(*audtran)(), audwrite(), audwrtrev2(), audwrtrev4();
extern  void    bytrev2(), bytrev4(), rewriteheader();
extern	int	openin(), openout(), bytrevhost(), getsizformat();
extern  char    *getstrformat(), *retfilnam;
#ifdef RTAUDIO
extern	int	rtrecord();
extern	void	rtplay(), rtclose(), recopen(), playopen();
#define DEVAUDIO 0x7fff		/* unique fd for rtaudio  */
#endif

void (*spinrecv)(), (*spoutran)(), (*nzerotran)();
static void charrecv(),  alawrecv(), ulawrecv(), shortrecv(),longrecv(), floatrecv();
static void chartran(),  alawtran(), ulawtran(), shortran(), longtran(), floatran();
static void czerotran(), azerotran(),uzerotran(),szerotran(),lzerotran(),fzerotran();

void iotranset()   /* direct recv & tran calls to the right audio formatter  */
{                  /*                            & init its audio_io bufptr  */
        switch(O.informat) {
	case AE_CHAR:  spinrecv = charrecv;
	               chinbufp = inbuf;
	               break;
	case AE_ALAW:  spinrecv = alawrecv;
	               chinbufp = inbuf;
	               break;
	case AE_ULAW:  spinrecv = ulawrecv;
	               chinbufp = inbuf;
	               break;
	case AE_SHORT: spinrecv = shortrecv;
	               shinbufp = (short *)inbuf;
	               break;
	case AE_LONG:  spinrecv = longrecv;
	               llinbufp = (long  *)inbuf;
	               break;
	case AE_FLOAT: spinrecv = floatrecv;
	               flinbufp = (float *)inbuf;
	               break;
	default: die("unknown audio_in format");
	}

        switch(O.outformat) {
	case AE_CHAR:  spoutran = chartran;
	               nzerotran = czerotran;
	               choutbufp = outbuf;
	               break;
	case AE_ALAW:  spoutran = alawtran;
		       nzerotran = azerotran;
	               choutbufp = outbuf;
	               break;
	case AE_ULAW:  spoutran = ulawtran;
		       nzerotran = uzerotran;
	               choutbufp = outbuf;
	               break;
	case AE_SHORT: spoutran = shortran;
		       nzerotran = szerotran;
	               shoutbufp = (short *)outbuf;
	               break;
	case AE_LONG:  spoutran = longtran;
		       nzerotran = lzerotran;
	               lloutbufp = (long  *)outbuf;
	               break;
	case AE_FLOAT: spoutran = floatran;
		       nzerotran = fzerotran;
	               floutbufp = (float *)outbuf;
	               break;
	default: die("unknown audio_out format");
	}
}

void sndwrterr(nret, nput)      	/* report soundfile write(osfd) error	*/
 unsigned nret, nput;                   /* called after chk of write() bytecnt  */
{
        void sfcloseout();
	printf("soundfile write returned bytecount of %d, not %d\n",nret,nput);
	printf("closing the file ...\n");
	outbufrem = O.outbufsamps;       /* consider buf is flushed */
	sfcloseout();                    /* & try to close the file */
	die("\t... closed\n");
}

static int audread(inbuf,nbytes)        /* diskfile read option for audrecv's */
 char *inbuf;                           /*     assigned during sfopenin()     */
 int  nbytes;
{
        return(sreadin(isfd,inbuf,nbytes,p));
}

static void audwrite(outbuf, nbytes)    /* diskfile write option for audtran's */
 char *outbuf;                          /*      assigned during sfopenout()    */
 int  nbytes;
{
        int n;
	if ((n = write(osfd, outbuf, nbytes)) < nbytes)
	    sndwrterr(n, nbytes);
	nrecs++;
	if (O.rewrt_hdr)
	    rewriteheader(osfd, (long)nrecs*outbufsiz);
	if (O.heartbeat)
	    putc('.', stdout);
}

static void audwrtrev2(outbuf, nbytes)    /* diskfile write option for audtran's */
 char *outbuf;                            /*      assigned during sfopenout()    */
 int  nbytes;
{
        bytrev2(outbuf, nbytes);    /* rev bytes in shorts  */
	audwrite(outbuf, nbytes);   /*   & send the data    */
}

static void audwrtrev4(outbuf, nbytes)    /* diskfile write option for audtran's */
 char *outbuf;                            /*      assigned during sfopenout()    */
 int  nbytes;
{
        bytrev4(outbuf, nbytes);    /* rev bytes in longs   */
	audwrite(outbuf, nbytes);   /*   & send the data    */
}

void sfopenin()					/* init for continuous soundin */
{						/*    called only if -i flag   */
        register HEADATA *hdr;
        register char	 *sfname;
        long     n, readlong = 0;

	if (p == NULL)
	    p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
        if (O.infilename != NULL && strcmp(O.infilename,"stdin") == 0) {
	    sfname = O.infilename;
	    isfd = 0;                      /* get sound from stdin if requested */
	    pipdevin = 1;
	}
#ifdef RTAUDIO
        else if (O.infilename != NULL && (strcmp(O.infilename,"devaudio") == 0
                                     || strcmp(O.infilename,"adc") == 0)) {
	    sfname = O.infilename;
	    recopen(nchnls,O.insampsiz,esr,2);	/* open devaudio for input */
	    audrecv = rtrecord;			/*  & redirect audio gets  */
	    isfd = DEVAUDIO;			/* dummy file descriptor */
	    pipdevin   = 1;			/* no backward seeks !   */
	    goto inset; 			/* no header processing  */
        }
#endif
	else {                              /* else build filename and open that */
	    if ((isfd = openin(O.infilename)) < 0)
		dies("isfinit: cannot open %s", retfilnam);
	    sfname = retfilnam;
	}
	p->filetyp = 0;                    /* initially non-typed for readheader */
	if ((hdr = readheader(isfd,sfname,p)) != NULL   /* if headerblk returned */
	  && !(readlong = hdr->readlong)) {             /* & hadn't readin audio */
	    if (hdr->sr != (long)esr) {   	        /*    chk the hdr codes  */
		sprintf(errmsg,"audio_in %s has sr = %ld, orch sr = %ld",
			sfname, hdr->sr, (long)esr);
		warning(errmsg);
	    }
	    if (hdr->nchnls != nchnls) {
	        sprintf(errmsg,"audio_in %s has %ld chnls, orch %d chnls",
			sfname, hdr->nchnls, nchnls);
		die(errmsg);
	    }
	    O.insampsiz = hdr->sampsize;                /*    & cpy header vals  */
	    O.informat = hdr->format;
	    p->filetyp = hdr->filetyp;           
	    p->audrem = hdr->audsize;
	}
	else {                                          /* no header:  defaults  */
	    sprintf(errmsg,"%s has no soundfile header, assuming %s",
		    sfname, getstrformat(O.outformat) );
            warning(errmsg);
	    p->filetyp = 0;                             /*  (see also soundin.c) */
	    p->audrem = -1;
	}
	if (p->filetyp == TYP_AIFF && bytrevhost()
	 || p->filetyp == TYP_WAV && !bytrevhost()) {
	    if (O.informat == AE_SHORT)        /* if audio_in needs byte rev */
	        p->bytrev = bytrev2;           /*    set on sample size      */
	    else if (O.informat == AE_LONG)
	        p->bytrev = bytrev4;
	    else p->bytrev = NULL;
	    printf("opening %s infile %s, with%s bytrev\n",
		   p->filetyp == TYP_AIFF ? "AIFF" : "WAV",
		   sfname, p->bytrev == NULL ? " no" : "");
	}
	else p->bytrev = NULL;
	audrecv = audread; 			/* will use standard audio gets  */

inset:	inbufsiz = (unsigned)O.inbufsamps * O.insampsiz;/* calc inbufsize reqd   */
	inbuf = mcalloc((long)inbufsiz);                /* alloc inbuf space     */
	printf("reading %d-byte blks of %s from %s %s\n",
	       inbufsiz, getstrformat(O.informat), sfname,
	       p->filetyp == TYP_AIFF ? "(AIFF)" :
	       p->filetyp == TYP_WAV ? "(WAV)" : "");
	isfopen = 1;
	if (readlong) {                                 /*     & fill it from    */
	    *(long *)inbuf = hdr->firstlong;
	    n = sreadin(isfd, inbuf+sizeof(long), inbufsiz-sizeof(long), p);
	    n += sizeof(long);
	}
	else n = audrecv(inbuf, inbufsiz);              /*     file or devaudio  */
	inbufrem = n / O.insampsiz;                     /* datasiz in monosamps  */
}

void sfopenout()				/* init for sound out       */
{						/* (not called if nosound)  */
extern  void    writeheader();

        if (O.outfilename == NULL)  O.outfilename = "test";
        if (strcmp(O.outfilename,"stdout") == 0) {
	    sfoutname = O.outfilename;
	    osfd = O.stdoutfd;              /* send sound to stdout if requested */
	    pipdevout = 1;
	}    
#ifdef RTAUDIO
        else if (strcmp(O.outfilename,"devaudio") == 0
              || strcmp(O.outfilename,"dac") == 0) {
	    sfoutname = O.outfilename;
	    playopen(nchnls, O.outsampsiz, esr, 2);	/* open devaudio for out */
	    audtran = rtplay;				/* & redirect audio puts */
	    osfd = DEVAUDIO;				/* dummy file descriptor */
	    pipdevout = 1;				/* no backward seeks !   */
	    goto outset;				/* no header needed      */
        }
#endif
	else {
	    if ((osfd = openout(O.outfilename, 3)) < 0)   /* else open sfdir or cwd */
		dies("sfinit: cannot open %s", retfilnam);
	    sfoutname = mmalloc((long)strlen(retfilnam)+1);
	    strcpy(sfoutname, retfilnam);               /*   & preserve the name  */
	    if (strcmp(sfoutname, "/dev/audio") == 0) {
	/*	ioctl(   );   */
	        pipdevout = 1;
	    }
	}
#ifdef THINK_C
	AddMacHeader(sfoutname,nchnls,esr,O.outsampsiz);  /* set Mac resource */
	SetMacCreator(sfoutname);                /*   set creator & file type */
#endif
        if (O.sfheader)   	
	    writeheader(osfd, sfoutname);	/* write header as required     */
        if (O.filetyp == TYP_AIFF && bytrevhost()
	 || O.filetyp == TYP_WAV && !bytrevhost()) {
	    if (O.outformat == AE_SHORT)        /* if audio out needs byte rev  */
	        audtran = audwrtrev2;           /*   redirect the audio puts    */
	    else if (O.outformat == AE_LONG)
	        audtran = audwrtrev4;
	    else audtran = audwrite;
	}
	else audtran = audwrite; 		/* else use standard audio puts */

outset: outbufsiz = (unsigned)O.outbufsamps * O.outsampsiz;/* calc outbuf size  */
        outbuf = mmalloc((long)outbufsiz);                 /*  & alloc bufspace */
        printf("writing %d-byte blks of %s to %s %s\n",
	       outbufsiz, getstrformat(O.outformat), sfoutname,
	       O.filetyp == TYP_AIFF ? "(AIFF)" :
	       O.filetyp == TYP_WAV ? "(WAV)" : "");
	osfopen = 1;
	outbufrem = O.outbufsamps;
}

void sfnopenout()
{
	printf("not writing to sound disk\n");
        outbufrem = O.outbufsamps;          /* init counter, though not writing */
}

void sfclosein()
{
	if (!isfopen) return;
#ifdef RTAUDIO
	if (isfd == DEVAUDIO) {
	    if (!osfopen || osfd != DEVAUDIO)
	        rtclose();     /* close only if not open for output too */
	}	    
        else
#endif
	  close(isfd);
	isfopen = 0;
}

void sfcloseout()
{
        int	nb;

	if (!osfopen) return;
	if ((nb = (O.outbufsamps-outbufrem) * O.outsampsiz) > 0)/* flush outbuffer */
		audtran(outbuf, nb);
#ifdef RTAUDIO
        if (osfd == DEVAUDIO) {
	    if (!isfopen || isfd != DEVAUDIO)
	        rtclose();     /* close only if not open for input too */
	    goto report;
	}
#endif
        if (O.sfheader && !pipdevout) {           /* if header, & backward seeks ok */
	    unsigned datasize = nb ? (nrecs-1)*outbufsiz + nb : nrecs*outbufsiz;
	    rewriteheader(osfd, datasize);                             /*  rewrite  */
	}
#ifndef SFSUN41
        if (!pipdevout)
#endif
	        close(osfd);
report:	printf("%ld %d-byte soundblks of %s written to %s %s\n",
	       nrecs, outbufsiz, getstrformat(O.outformat), sfoutname,
	       O.filetyp == TYP_AIFF ? "(AIFF)" :
	       O.filetyp == TYP_WAV ? "(WAV)" : "");
	osfopen = 0;
}

static void shortran()			/* fix spout vals and put in outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register long   longsmp, *rngp;
register int	n, spoutrem;
	float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;

nchk:	if ((n = spoutrem) > outbufrem)	/* if nspout remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	outbufrem -= n;
	do {
		if ((longsmp = *sp) >= 0) {		/* +ive samp:	*/
			if (*sp > *maxampp)		/*  maxamp this seg  */
				*maxampp = *sp;
			if (longsmp > 32767) {		/* out of range?     */
				longsmp = 32767;	/*   clip and report */
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		else {					/* ditto -ive samp */
			if ((absamp = -*sp) > *maxampp)
				*maxampp = absamp;
			if (longsmp < -32768) {
				longsmp = -32768;
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		if (osfopen)
			*shoutbufp++ = (short) longsmp;
		if (multichan && ++maxampp >= maxampend)
			maxampp = maxamp;
		sp++;
	} while (--n);
	if (!outbufrem) {
		if (osfopen) {
			audtran(outbuf,outbufsiz);
			shoutbufp = (short *) outbuf;
		}
		outbufrem = O.outbufsamps;
		if (spoutrem) goto nchk;
	}
}

static void chartran()			/* same as above, but 8-bit char output */
{					/*   sends HI-ORDER 8 bits of shortsamp */
register float	*sp, *maxampp;
register long   longsmp, *rngp;
register int	n, spoutrem;
	float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;

nchk:	if ((n = spoutrem) > outbufrem)	/* if nspout remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	outbufrem -= n;
	do {
		if ((longsmp = *sp) >= 0)		/* +ive samp:	*/
			if (*sp > *maxampp) {		/*  maxamp this seg  */
				*maxampp = *sp;
			if (longsmp > 32767) {		/* out of range?     */
				longsmp = 32767;	/*   clip and report */
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		else {					/* ditto -ive samp */
			if ((absamp = -*sp) > *maxampp)
				*maxampp = absamp;
			if (longsmp < -32768) {
				longsmp = -32768;
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		if (osfopen)
			*choutbufp++ = longsmp >> 8;
		if (multichan && ++maxampp >= maxampend)
			maxampp = maxamp;
		sp++;
	} while (--n);
	if (!outbufrem) {
		if (osfopen) {
			audtran(outbuf,outbufsiz);
			choutbufp = outbuf;
		}
		outbufrem = O.outbufsamps;
		if (spoutrem) goto nchk;
	}
}

static void alawtran()
{ die("alaw not yet implemented"); }

#define MUCLIP  32635
#define BIAS    0x84
#define MUZERO  0x02
#define ZEROTRAP 

static void ulawtran()			/* ulaw-encode spout vals & put in outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register long   longsmp, *rngp;
register int	n, spoutrem, sign;
extern  char    exp_lut[];               /* mulaw encoding table */

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;

nchk:	if ((n = spoutrem) > outbufrem)	/* if nspout remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	outbufrem -= n;
	do {
		if ((longsmp = *sp) < 0) {		/* if sample negative	*/
		        sign = 0x80;
			longsmp = - longsmp;		/*  make abs, save sign	*/
		}
		else sign = 0;
		if (longsmp > *maxampp)         	/* save maxamp this seg  */
			*maxampp = longsmp;
		if (longsmp > MUCLIP) { 		/* out of range?     */
			longsmp = MUCLIP;       	/*   clip and report */
			rngp = rngcnt + (maxampp - maxamp);
			(*rngp)++;
			rngflg = 1;
		}
		if (osfopen) {
			int sample, exponent, mantissa, ulawbyte;
			sample = longsmp + BIAS;
			exponent = exp_lut[( sample >> 8 ) & 0x7F];
			mantissa = ( sample >> (exponent+3) ) & 0x0F;
			ulawbyte = ~ (sign | (exponent << 4) | mantissa );
#ifdef ZEROTRAP
			if (ulawbyte == 0) ulawbyte = MUZERO;    /* optional CCITT trap */
#endif
			*choutbufp++ = ulawbyte;
		}
		if (multichan && ++maxampp >= maxampend)
			maxampp = maxamp;
		sp++;
	} while (--n);
	if (!outbufrem) {
		if (osfopen) {
			audtran(outbuf,outbufsiz);
			choutbufp = outbuf;
		}
		outbufrem = O.outbufsamps;
		if (spoutrem) goto nchk;
	}
}

static void longtran()			/* send long_int spout vals to outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register int	n, spoutrem;
register float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;

nchk:	if ((n = spoutrem) > outbufrem)	/* if nspout remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	outbufrem -= n;
	do {
		if ((absamp = *sp) < 0.)
			absamp = -absamp;
		if (absamp > *maxampp)  	/*  maxamp this seg  */
			*maxampp = absamp;
		if (osfopen)
			*lloutbufp++ = (long) *sp;
		if (multichan && ++maxampp >= maxampend)
			maxampp = maxamp;
		sp++;
	} while (--n);
	if (!outbufrem) {
		if (osfopen) {
			audtran(outbuf,outbufsiz);
			lloutbufp = (long *) outbuf;
		}
		outbufrem = O.outbufsamps;
		if (spoutrem) goto nchk;
	}
}

static void floatran()			/* send float spout vals to outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register int	n, spoutrem;
register float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;

nchk:	if ((n = spoutrem) > outbufrem)	/* if nspout remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	outbufrem -= n;
	do {
		if ((absamp = *sp) < 0.)
			absamp = -absamp;
		if (absamp > *maxampp)  	/*  maxamp this seg  */
			*maxampp = absamp;
		if (osfopen)
			*floutbufp++ = *sp;
		if (multichan && ++maxampp >= maxampend)
			maxampp = maxamp;
		sp++;
	} while (--n);
	if (!outbufrem) {
		if (osfopen) {
			audtran(outbuf,outbufsiz);
			floutbufp = (float *) outbuf;
		}
		outbufrem = O.outbufsamps;
		if (spoutrem) goto nchk;
	}
}

static void szerotran(kcnt)	/* copy kcnt zerospouts to short soundbuf, */
 long kcnt;			/*	sending buffer whenever full	 */
{
register long	n, smpsrem, clearcnt = 0;

	if (!osfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > outbufrem)	/* if smps remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	outbufrem -= n;
	if (clearcnt < O.outbufsamps) {
		clearcnt += n;		/* clear buf only till clean */
		do *shoutbufp++ = (short) 0;
		while (--n);
	}
	else shoutbufp += n;
	if (!outbufrem) {
		audtran(outbuf,outbufsiz);
		shoutbufp = (short *) outbuf;
		outbufrem = O.outbufsamps;
		if (smpsrem) goto nchk;
	}
}

static void czerotran(kcnt)	/* copy kcnt zerospouts to (signed) char soundbuf, */
 long kcnt;			/*	sending buffer whenever full	 */
{
register long	n, smpsrem, clearcnt = 0;

	if (!osfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > outbufrem)	/* if smps remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	outbufrem -= n;
	if (clearcnt < O.outbufsamps) {
		clearcnt += n;		/* clear buf only till clean */
		do *choutbufp++ = 0x00;
		while (--n);
	}
	else choutbufp += n;
	if (!outbufrem) {
		audtran(outbuf,outbufsiz);
		choutbufp = outbuf;
		outbufrem = O.outbufsamps;
		if (smpsrem) goto nchk;
	}
}

static void azerotran(kcnt) { die("alaw not yet implemented"); }

static void uzerotran(kcnt)	/* copy kcnt zerospouts to ulaw soundbuf, */
 long kcnt;			/*	sending buffer whenever full	 */
{
register long	n, smpsrem, clearcnt = 0;

	if (!osfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > outbufrem)	/* if smps remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	outbufrem -= n;
	if (clearcnt < O.outbufsamps) {
		clearcnt += n;		/* clear buf only till clean */
		do *choutbufp++ = 0xFF; /* no signal is 0xFF in mulaw */
		while (--n);
	}
	else choutbufp += n;
	if (!outbufrem) {
		audtran(outbuf,outbufsiz);
		choutbufp = outbuf;
		outbufrem = O.outbufsamps;
		if (smpsrem) goto nchk;
	}
}

static void lzerotran(kcnt)	/* copy kcnt zerospouts to long_int soundbuf, */
 long kcnt;			/*	sending buffer whenever full	 */
{
register long	n, smpsrem, clearcnt = 0;

	if (!osfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > outbufrem)	/* if smps remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	outbufrem -= n;
	if (clearcnt < O.outbufsamps) {
		clearcnt += n;		/* clear buf only till clean */
		do *lloutbufp++ = 0L;
		while (--n);
	}
	else lloutbufp += n;
	if (!outbufrem) {
		audtran(outbuf,outbufsiz);
		lloutbufp = (long *) outbuf;
		outbufrem = O.outbufsamps;
		if (smpsrem) goto nchk;
	}
}

static void fzerotran(kcnt)	/* copy kcnt zerospouts to float soundbuf, */
 long kcnt;			/*	sending buffer whenever full	 */
{
register long	n, smpsrem, clearcnt = 0;

	if (!osfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > outbufrem)	/* if smps remaining > buf rem, */
		n = outbufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	outbufrem -= n;
	if (clearcnt < O.outbufsamps) {
		clearcnt += n;		/* clear buf only till clean */
		do *floutbufp++ = fzero;
		while (--n);
	}
	else floutbufp += n;
	if (!outbufrem) {
		audtran(outbuf,outbufsiz);
		floutbufp = (float *) outbuf;
		outbufrem = O.outbufsamps;
		if (smpsrem) goto nchk;
	}
}

static void clrspin1(r,spinrem)      /* clear remainder of spinbuf to zeros */
 register float *r;                  /* called only once, at EOF   */
 register int spinrem;
{
	infilend = 1;                        /* 1st filend pass:   */
	while (spinrem--)                    /*   clear spin rem   */
		*r++ = fzero;
}

static void clrspin2()             /* clear spinbuf to zeros   */
{                                  /* called only once, at EOF */
        register float *r = spin;
        register int n = nspin;
        infilend = 2;                        /* at 2nd filend pass  */
	do *r++ = fzero;                     /*   clr whole spinbuf */
	while (--n);
	printf("end of audio_in file\n");
}

static void charrecv()              /* get spin values from char inbuf */
{
        register float *r = spin;
	register int   n, spinrem = nspin;

	if (infilend == 2) return;
	if (!inbufrem)  goto echk;
nchk:   if ((n = spinrem) > inbufrem)   /* if nspin remaining > buf rem,  */
            n = inbufrem;               /*       prepare to get in parts  */
	spinrem -= n;
	inbufrem -= n;
	do *r++ = (float) ( (short)*chinbufp++ << 8 );
	while (--n);
	if (!inbufrem) {
echk:	    if (!infilend) {
		if ((n = audrecv(inbuf, inbufsiz)) != 0) {
		    chinbufp = inbuf;
		    inbufrem = n / sizeof(char);
		    if (spinrem) goto nchk;
		} else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
	    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
	}
}

static void alawrecv() { die("alaw audio_in not yet implemented"); }

static void ulawrecv()              /* get spin values from ulaw inbuf */
{
        register float *r = spin;
	register int   n, spinrem = nspin;

	if (infilend == 2) return;
	if (!inbufrem)  goto echk;
nchk:   if ((n = spinrem) > inbufrem)   /* if nspin remaining > buf rem,  */
            n = inbufrem;               /*       prepare to get in parts  */
	spinrem -= n;
	inbufrem -= n;
	do *r++ = (float) ulaw_decode[*(unsigned char *)chinbufp++];
	while (--n);
	if (!inbufrem) {
echk:	    if (!infilend) {
		if ((n = audrecv(inbuf, inbufsiz)) != 0) {
		    chinbufp = inbuf;
		    inbufrem = n / sizeof(char);
		    if (spinrem) goto nchk;
		} else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
	    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
	}
}

static void shortrecv()              /* get spin values from short_int inbuf */
{
        register float *r = spin;
	register int   n, spinrem = nspin;

	if (infilend == 2) return;
	if (!inbufrem)  goto echk;
nchk:   if ((n = spinrem) > inbufrem)   /* if nspin remaining > buf rem,  */
	    n = inbufrem;               /*       prepare to get in parts  */
	spinrem -= n;
	inbufrem -= n;
	do *r++ = (float) *shinbufp++;
	while (--n);
	if (!inbufrem) {
echk:	    if (!infilend) {
	        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
		    shinbufp = (short *) inbuf;
		    inbufrem = n / sizeof(short);
		    if (spinrem) goto nchk;
		} else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
	    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
	}
}

static void longrecv()              /* get spin values from long_int inbuf */
{
        register float *r = spin;
	register int   n, spinrem = nspin;

	if (infilend == 2) return;
	if (!inbufrem)  goto echk;
nchk:   if ((n = spinrem) > inbufrem)   /* if nspin remaining > buf rem,  */
            n = inbufrem;               /*       prepare to get in parts  */
	spinrem -= n;
	inbufrem -= n;
	do *r++ = (float) *llinbufp++;
	while (--n);
	if (!inbufrem) {
echk:	    if (!infilend) {
		if ((n = audrecv(inbuf, inbufsiz)) != 0) {
		    llinbufp = (long *) inbuf;
		    inbufrem = n / sizeof(long);
		    if (spinrem) goto nchk;
		} else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
	    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
	}
}

static void floatrecv()              /* get spin values from float inbuf */
{
        register float *r = spin;
	register int   n, spinrem = nspin;

	if (infilend == 2) return;
	if (!inbufrem)  goto echk;
nchk:   if ((n = spinrem) > inbufrem)   /* if nspin remaining > buf rem,  */
            n = inbufrem;               /*       prepare to get in parts  */
	spinrem -= n;
	inbufrem -= n;
	do *r++ = *flinbufp++;
	while (--n);
	if (!inbufrem) {
echk:	    if (!infilend) {
		if ((n = audrecv(inbuf, inbufsiz)) != 0) {
		    flinbufp = (float *) inbuf;
		    inbufrem = n / sizeof(float);
		    if (spinrem) goto nchk;
		} else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
	    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
	}
}

