#include "cs.h"			/*				FGENS.C		*/
#include "soundio.h"
#include "window.h"
#include <math.h>

#define	FMAX	200
#define	GENMAX	19

typedef	void	(*GEN)();

static void	gen01(), gen02(), gen03(), gen04(), gen05();
static void	gen06(), gen07(), gen08(), gen09(), gen10();
static void	gen11(), gen12(), gen13(), gen14(), gen15(), gn1314();
static void	gen17(), gen19();

static	FUNC	*flist[FMAX+1], *ftp;
static	GEN	gensub[GENMAX+1] = { NULL, gen01, gen02, gen03, gen04, gen05,
					   gen06, gen07, gen08, gen09, gen10,
					   gen11, gen12, gen13, gen14, gen15,
					   NULL,  gen17, NULL,  gen19 };
static	EVTBLK	*e;

static	double	tpdlen, tpd360 = 0.017453293;
static	int	fno, guardreq, nargs, fterrcnt;
static	long	flen, flenp1, lenmask;
static  void    fterror(), ftresdisp(), ftalloc();

#define	FTERR(s)	{fterror(s);  return;}

void fgens(evtblkp)			/* create ftable using evtblk data */
 EVTBLK	*evtblkp;
{
	long	ltest, lobits, lomod, genum;

	e = evtblkp;
	fterrcnt = 0;
	if ((fno = (int)e->p[1]) < 0) {			/* fno < 0: remove */
		if ((fno = -fno) > FMAX)
			FTERR("illegal ftable number")
		if ((ftp = flist[fno]) == NULL)
			FTERR("ftable does not exist")
		flist[fno] = NULL;
		free((char *)ftp);
		printf("ftable %d now deleted\n",fno);
		return;
	}
	if (!fno)				/* fno = 0, return	*/
		return;
	if (fno > FMAX)
		FTERR("illegal ftable number")
	if ((nargs = e->pcnt - 4) <= 0)		/* chk minimum arg count */
		FTERR("insufficient gen arguments")
	if ((genum = e->p[4]) < 0)
		genum = -genum;
	if (!genum || genum > GENMAX)		/*   & legal gen number */
		FTERR("illegal gen number")
	if ((flen = e->p[3])) {			/* if user flen	given       */
	    guardreq = flen & 01;		/*   set guard request flg  */
	    flen &= -2;				/*   flen now w/o guardpt   */
	    flenp1 = flen + 1;			/*   & flenp1 with guardpt  */
	    if (flen <= 0 || flen > MAXLEN)
		FTERR("illegal table length")
	    for (ltest=flen,lobits=0; (ltest & MAXLEN) == 0; lobits++,ltest<<=1);
	    if (ltest != MAXLEN)		/*   flen must be power-of-2 */
		FTERR("illegal table length")
	    lenmask = flen-1;
	    ftalloc();				/*   alloc ftable space now */
	    ftp->flen = flen;
	    ftp->lenmask = lenmask;  		/*   init hdr w powof2 data */
	    ftp->lobits = lobits;
	    lomod = MAXLEN / flen;
	    ftp->lomask = lomod - 1;
	    ftp->lodiv = 1./((float)lomod);	/*    & other useful vals    */
	    tpdlen = twopi / flen;
	    ftp->nchnls = 1;                    /*    presume mono for now   */
	    ftp->flenfrms = flen;
	}
	else if (genum != 1)                    /* else defer alloc to gen01 */
	    FTERR("deferred size for GEN01 only")
	printf("ftable %d:\n", fno);
	(*gensub[genum])();			/* call gen subroutine	*/
	if (!fterrcnt)
	    ftresdisp();			/* rescale and display */
}

static void needsiz(maxend)
 register long maxend;
{
        register long nxtpow;
	maxend -= 1; nxtpow = 2;
	while (maxend >>= 1)
	    nxtpow <<= 1;
	printf("non-deferred ftable %d needs size %ld\n", (int)fno, nxtpow);
}

static void gen01()		/* read ftable values from a sound file */
{				/* stops reading when table is full	*/
static	ARGLST	arglst = {0};		/* OUTCOUNT--not applicable yet */
static	OPTXT	optxt;			/* create dummy optext	*/
register SOUNDIN *p;			/*   for sndgetset	*/
register float	*fp;
register long	nlocs, n, audformat;
        LOOPDAT *ldp;
extern  short   ulaw_decode[];
extern  int     sndgetset();
	SOUNDIN	tmpspace;		/* create temporary opds */
        int     fd, truncmsg = 0;

	if (nargs < 3)
		FTERR("insufficient args")
	optxt.t.outlist = &arglst;      /* point to dummy OUTCOUNT */
	p = &tmpspace;
	p->h.optext = &optxt;
	p->ifilno = &e->p[5];
	p->iskptim = &e->p[6];
	p->iformat = &e->p[7];
	p->strarg = e->strarg;
	if (!flen)
		printf("deferred alloc\n");
	if (!(fd = sndgetset(p))) 		/* sndinset to open the file */
		FTERR (errmsg)
	if (p->endfile) {
	        printf("GEN01 early end-of-file\n");
		goto gn1rtn;
	}
	if (!flen) {                            /* deferred ftalloc requestd: */
	    if ((flen = p->minflen) <= 0)       /*   get minsize from soundin */
		FTERR ("deferred size, but min flen unknown")
	    guardreq = 1;
	    flenp1 = flen;                      /* presum this includes guard */
	    flen -= 1;
	    ftalloc();                          /*   alloc now, and           */
	    ftp->flen = flen;
	    ftp->lenmask = 0;                   /*   mark hdr partly filled   */
	    ftp->nchnls = p->nchnls;
	    ftp->flenfrms = flen / p->nchnls;
	}
	ftp->cvtbas = LOFACT * p->sr / esr;
        if ((ldp = p->loopdata) != NULL) {      /* if file had looping info,  */
	    if (p->sr != esr)                   /*    copy to FUNC struct     */
	        printf("\tloscil access will be adjusted accordingly\n");
	    ftp->cpscvt = ftp->cvtbas / ldp->natcps;
	    ftp->loopmode1 = ldp->loopmode1;
	    ftp->loopmode2 = ldp->loopmode2;
	    ftp->begin1 = ldp->begin1;
	    ftp->begin2 = ldp->begin2;
	    ftp->end1 = ldp->end1;
	    ftp->end2 = ldp->end2;
	    if (ftp->end1 > flen || ftp->end2 > flen) {
	        long maxend;
	        warning("GEN01: aiff file truncated by ftable size");
		if ((maxend = ftp->end1) < ftp->end2)
		    maxend = ftp->end2;
		printf("\tlooping endpoint %ld exceeds ftsize %ld\n",maxend,flen);
		needsiz(maxend);
		truncmsg = 1;
	    }
	}
	else {
	    ftp->cpscvt = 0.;                  /* else no looping possible   */
	    ftp->loopmode1 = 0;
	    ftp->loopmode2 = 0;
	}
	fp = ftp->ftable;
	nlocs = flenp1;
	switch (p->format) {			/* now do simplified soundin */
	    case AE_CHAR: {
		register char *inbufp, *bufend;
		inbufp = p->inbufp;
		bufend = p->bufend;
		while (nlocs--) {
		    *fp++ = (float) ( (short)*inbufp++ << 8 );
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = p->inbuf;
			bufend = p->inbuf + n;
		    }
		}
	    } break;
	    case AE_ULAW: {
		register unsigned char *inbufp, *bufend;
		inbufp = (unsigned char *) p->inbufp;
		bufend = (unsigned char *) p->bufend;
		while (nlocs--) {
		    *fp++ = (float) ulaw_decode[*inbufp++];
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (unsigned char *) p->inbuf;
			bufend = (unsigned char *) (p->inbuf + n);
		    }
		}
	    } break;
	    case AE_SHORT: {
		register short	*inbufp, *bufend;
		inbufp = (short *) p->inbufp;
		bufend = (short *) p->bufend;
		while (nlocs--) {
		    *fp++ = (float) *inbufp++;
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (short *) p->inbuf;
			bufend = (short *) (p->inbuf + n);
		    }
		}
	    } break;
	    case AE_LONG: {
		register long  *inbufp, *bufend;
		inbufp = (long *) p->inbufp;
		bufend = (long *) p->bufend;
		while (nlocs--) {
		    *fp++ = (float) *inbufp++;
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (long *) p->inbuf;
			bufend = (long *) (p->inbuf + n);
		    }
		}
	    } break;
	    case AE_FLOAT: {
		register float	*inbufp, *bufend;
		inbufp = (float *) p->inbufp;
		bufend = (float *) p->bufend;
		while (nlocs--) {
		    *fp++ = *inbufp++;
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (float *) p->inbuf;
			bufend = (float *) (p->inbuf + n);
		    }
		}
	    } break;
	    default: {
	        extern char *getstrformat();
	        sprintf(errmsg,"GEN01 cannot read sformat %s\n",
			     getstrformat((int)p->format));
		fterror(errmsg);
		goto gn1rtn;
	    }
	}
gn1rtn: if (p->audrem > 0 && !truncmsg) {
	    warning("GEN01: aiff file truncated by ftable size");
	    printf("\taudio samps %ld exceeds ftsize %ld\n", p->minflen, flen);
            needsiz(p->minflen);
	}
        ftp->soundend = flenp1 - nlocs;  /* record end of actual sound samps */
        ftp->soundend /= ftp->nchnls;
        while (nlocs--)                  /* if file was shorter than gen blk */
	        *fp++ = 0.;              /*     pad out with zeros           */
        close(fd);
}

static void gen02()		/* read ftable values directly from p-args */
{
register float	*fp = ftp->ftable, *pp = &e->p[5];
register int	nvals = nargs;

	if (nvals > flenp1)
		nvals = flenp1;			/* for all vals up to flen+1 */
	do  *fp++ = *pp++;			/*   copy into ftable	*/
	while (--nvals);
}

static void gen03()
{
	int	ncoefs;
	float	xintvl, xscale;
register int	xloc, nlocs;
register float	*fp = ftp->ftable, x, sum, *coefp, *coef0, *coeflim;

	if ((ncoefs = nargs - 2) <= 0)
		FTERR("no coefs present")
	coef0 = &e->p[7];
	coeflim = coef0 + ncoefs;
	if ((xintvl = e->p[6] - e->p[5]) <= 0)
		FTERR("illegal x interval")
	xscale = xintvl / (float)flen;
	xloc = e->p[5] / xscale;		/* initial xloc	*/
	nlocs = flenp1;
	do {					/* for each loc:	*/
		x = xloc++ * xscale;
		coefp = coeflim;
		sum = *--coefp;			/* init sum to coef(n)	*/
		while (coefp > coef0) {
			sum *= x;		/*  & accum by Horner's rule */
			sum += *--coefp;
		}
		*fp++ = sum;
	} while (--nlocs);
}

static void gen04()
{
register float	*valp, *rvalp, *fp = ftp->ftable;
register int	n, r;
register FUNC	*srcftp;
	float	val, max, maxinv;
	int	srcno, srcpts, ptratio;

	if (nargs < 2)
		FTERR("insufficient args")
	if ((srcno = (int)e->p[5]) <= 0 || srcno > FMAX
	  || (srcftp = flist[srcno]) == NULL)
	  	FTERR("unknown srctable number")
	if (!e->p[6]) {
		srcpts = srcftp->flen;
		valp = &srcftp->ftable[0];
		rvalp = NULL;
	}
	else {
		srcpts = srcftp->flen >>1;
		valp = &srcftp->ftable[srcpts];
		rvalp = valp - 1;
	}
	if ((ptratio = srcpts / flen) < 1)
		FTERR("table size too large")
	if (val = *valp++) {
		if (val < 0.)	val = -val;
		max = val;
		maxinv = 1. / max;
	}
	else {
		max = 0.;
		maxinv = 1.;
	}
	*fp++ = maxinv;
	for (n = flen; n--; ) {
		for (r = ptratio; r--; ) {
			if (val = *valp++) {
				if (val < 0.)	val = -val;
				if (val > max) {
					max = val;
					maxinv = 1. / max;
				}
			}
			if (rvalp != NULL && (val = *rvalp--)) {
				if (val < 0.)	val = -val;
				if (val > max) {
					max = val;
					maxinv = 1. / max;
				}
			}
			*fp++ = maxinv;
		}
	}
	guardreq = 1;			/* disable new guard point */
	e->p[4] = -4.;			/*   and rescaling	   */
}

static void gen05()
{
register int	nsegs, seglen;
register float	*valp, *fp, *finp;
register float	amp1, mult;

	if ((nsegs = (nargs - 1) >> 1) <= 0)	     /* nsegs = nargs-1 /2 */
		return;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	if (*valp == 0) goto gn5er2;
	do {	amp1 = *valp++;
		if (!(seglen = *valp++)) continue;
		if (seglen < 0) goto gn5er1;
		if ((mult = *valp/amp1) <= 0) goto gn5er2;
		mult = pow( (double)mult, (double)1/seglen );
		while (seglen--) {
			*fp++ = amp1;
			amp1 *= mult;
			if (fp > finp) return;
		}
	} while (--nsegs);
	if (fp == finp)			/* if 2**n pnts, add guardpt */
		*fp = amp1;
	return;

gn5er1: fterror("gen call has negative segment size:");
        return;
gn5er2:	fterror("illegal input vals for gen call, beginning:");
}

static void gen07()
{
register int	nsegs, seglen;
register float	*valp, *fp, *finp;
register float	amp1, incr;

	if ((nsegs = (nargs - 1) >> 1) <= 0)	     /* nsegs = nargs-1 /2 */
		return;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	do {	amp1 = *valp++;
		if (!(seglen = *valp++)) continue;
		if (seglen < 0) goto gn7err;
		incr = (*valp - amp1) / seglen;
		while (seglen--) {
			*fp++ = amp1;
			amp1 += incr;
			if (fp > finp) return;
		}
	} while (--nsegs);
	if (fp == finp)			/* if 2**n pnts, add guardpt */
		*fp = amp1;
        return;

gn7err: fterror("gen call has negative segment size:");
}

static void gen06()
{
register float	*segp, *extremp, *inflexp, *segptsp, *fp, *finp;
	float	y, diff2;
register int	pntno, pntinc, nsegs, npts;

	if ((nsegs = (nargs - 1) >>1) < 1)
		FTERR("insufficient args")
	fp = ftp->ftable;
	finp = fp + flen;
	pntinc = 1;
	for (segp = &e->p[3]; nsegs > 0; nsegs--) {
		segp += 2;
		segptsp = segp + 1;
		if ((npts = *segptsp) < 0)
			FTERR("negative segsiz")
		if (pntinc > 0) {
			pntno = 0;
			inflexp = segp + 2;
			extremp = segp;
		}
		else {
			pntno = npts;
			inflexp = segp;
			extremp = segp + 2;
		}
		diff2 = (*inflexp - *extremp) / 2.;
		for ( ; npts > 0 && fp < finp; pntno += pntinc, npts--) {
			y = (float)pntno / *segptsp;
			*fp++ = (3.-y) * y * y * diff2 + *extremp;
		}
		pntinc = -pntinc;
	}
	*fp = *(segp + 2);			/* write last target point */
}

static void gen08()
{
register float	R, x, c3, c2, c1, c0, *fp, *fplim, *valp;
	float	f2, f1, f0, df1, df0, dx01, dx02, dx12, curx;
	float	slope, resd1, resd0;
	int	nsegs, npts;

	if ((nsegs = (nargs - 1) >>1) <= 0)
		FTERR("insufficient args");
	valp = &e->p[5];
	fp = ftp->ftable;
	fplim = fp + flen;
	f0 = *valp++;			/* 1st 3 params give vals at x0, x1  */
	if ((dx01 = *valp++) <= 0.)	/*	and dist between	     */
		FTERR("illegal x interval");
	f1 = *valp++;
	curx = df0 = 0.;		/* init x to origin; slope at x0 = 0 */
	do {				/* for each spline segmnt (x0 to x1) */
	    if (nsegs > 1) {			/* if another seg to follow  */
		if ((dx12 = *valp++) <= 0.)	/*    read its distance	     */
			FTERR("illegal x interval");
		f2 = *valp++;			/*    and the value at x2    */
		dx02 = dx01 + dx12;
		df1 = ( f2*dx01*dx01 + f1*(dx12-dx01)*dx02 - f0*dx12*dx12 )
			/ (dx01*dx02*dx12);
	    }				   /* df1 is slope of parabola at x1 */
	    else df1 = 0.;
	    if ((npts = dx01 - curx) > fplim - fp)
		npts = fplim - fp;
	    if (npts > 0) {			/* for non-trivial segment: */
		slope = (f1 - f0) / dx01;	/*   get slope x0 to x1	    */
		resd0 = df0 - slope;		/*   then residual slope    */
		resd1 = df1 - slope;		/*     at x0 and x1	    */
		c3 = (resd0 + resd1) / (dx01*dx01);
		c2 = - (resd1 + 2.*resd0) / dx01;
		c1 = df0;			/*   and calc cubic coefs   */
		c0 = f0;
		for (x = curx; npts>0; --npts, x += 1.) {
		    R = c3;
		    R *= x;
		    R += c2;	     /* f(x) = ((c3 x + c2) x + c1) x + c0  */
		    R *= x;
		    R += c1;
		    R *= x;
		    R += c0;
		    *fp++ = R;			/* store n pts for this seg */
		}
		curx = x;
	    }
	    curx -= dx01;		/* back up x by length last segment */
	    dx01 = dx12;		/* relocate to the next segment	*/
	    f0 = f1;			/*   by assuming its parameters	*/
	    f1 = f2;
	    df0 = df1;
	}
	while (--nsegs && fp<fplim);	/* loop for remaining segments	*/
	while (fp <= fplim)
	    *fp++ = f0;			/* & repeat the last value	*/
}

static void gen09()
{
register int	hcnt;
register float	*valp, *fp, *finp;
	double	phs, inc, amp;

	if ((hcnt = nargs / 3) <= 0)		/* hcnt = nargs / 3 */
		return;
	valp = &e->p[5];
	finp = &ftp->ftable[flen];
	do	for (inc=(*valp++)*tpdlen, amp=(*valp++),
		     phs=(*valp++)*tpd360, fp=ftp->ftable; fp<=finp; fp++) {
			*fp += sin(phs) * amp;
			if ((phs += inc) >= twopi)
				phs -= twopi;
		}
	while (--hcnt);
}

static void gen10()
{
register long	phs, hcnt;
register float	amp, *fp, *finp;

	if ((hcnt = nargs) <= 0)			/* hcnt is nargs   */
		return;
	finp = &ftp->ftable[flen];
	do if ((amp = e->p[hcnt+4]) != 0)		/* for non-0 amps,  */
		for (phs=0, fp=ftp->ftable; fp<=finp; fp++) {
			*fp += sin(phs*tpdlen) * amp;	/* accum sin pts  */
			phs += hcnt;			/* phsinc is hno   */
			phs &= lenmask;
		}
	while (--hcnt);
}

static void gen11()
{
register float  *fp, *finp;
register long   phs;
	double	x;
	float	denom, r, scale;
	int	n, k;
  
	if (nargs < 1)
		FTERR ("insufficient arguments");
	if ((n = e->p[5]) < 1)
		FTERR ("nh partials < 1");
	k = 1;
	r = 1.;
	if (nargs > 1)
		k = e->p[6];
	if (nargs > 2)
		r = e->p[7];
	fp = ftp->ftable;
	finp = fp + flen;
	if (nargs == 1 || k == 1 && r == 1.) {     /* simple "buzz" case */
		int tnp1;
		float pdlen;

		tnp1 = (n << 1) + 1;
		scale = .5 / n;
		pdlen = tpdlen / 2.;
		for (phs = 0; fp <= finp; phs++) {
			x = phs * pdlen;
			if (!(denom = sin(x)))
				*fp++ = 1.;
			else *fp++ = (sin(tnp1 * x) / denom - 1.) * scale;
		}
	}
	else {                                   /* complex "gbuzz" case */
		float numer, twor, rsqp1, rtn, rtnp1, absr;
		int   km1, kpn, kpnm1;

		km1   = k - 1;
		kpn   = k + n;
		kpnm1 = kpn - 1;
		twor  = r * 2.;
		rsqp1 = r * r + 1.;
		rtn   = pow((double) r, (double) n);
		rtnp1 = rtn * r;
		if ((absr = fabs(r)) > .999 && absr < 1.001)
			scale = 1. / n;
		else scale = (1. - absr) / (1. - fabs(rtn));
		for (phs=0; fp <= finp; phs++) {
			x = phs * tpdlen;
			numer = cos(x*k) - r * cos(x*km1) - rtn * cos(x*kpn)
				+ rtnp1 * cos(x*kpnm1);
			if ((denom = rsqp1 - twor*cos(x)) > .0001
			  || denom < -.0001)
			  	*fp++ = numer / denom * scale;
			else *fp++ = 1.;
		}
	}
}

static void gen12()
{
static double coefs[] = { 3.5156229, 3.0899424, 1.2067492,
			  0.2659732, 0.0360768, 0.0045813 };
register double *coefp, sum, tsquare, evenpowr, *cplim = coefs + 6;
register int    n;
register float	*fp;
register double xscale;

	if (nargs < 1)
		FTERR ("insufficient arguments");
	xscale = (double) e->p[5] / flen / 3.75;
	for (n=0,fp=ftp->ftable; n<=flen; n++) {
	        tsquare = (double) n * xscale;
		tsquare *= tsquare;
		for (sum=evenpowr=1.0, coefp=coefs; coefp<cplim; coefp++) {
			evenpowr *= tsquare;
			sum += *coefp * evenpowr;
	        }
		*fp++ = (float) log(sum);
	}
}

static	float	mxval, mxscal;

static void gen13()
{
	mxval = 2.;
	mxscal = .5;
	gn1314();
}

static void gen14()
{
	mxval = 1.;
	mxscal = 1.;
	gn1314();
}

static void gn1314()
{
register long	nh, nn;
register float	*mp, *mspace, *hp, *oddhp;
	float	xamp, xintvl, scalfac, sum, prvm;

	if ((nh = nargs - 2) <= 0)
		FTERR("insufficient args")
	if ((xintvl = e->p[5]) <= 0)
		FTERR("illegal xint value")
	if ((xamp = e->p[6]) <= 0)
		FTERR("illegal xamp value")
	e->p[5] = -xintvl;
	e->p[6] = xintvl;
        nn = nh * sizeof(float) / 2;	    /* alloc spc for terms 3,5,7,... */
	mp = mspace = (float *)mcalloc(nn);     /* of 1st row of matrix, and */
	for (nn = (nh + 1) >>1; --nn; )		/* form array of non-0 terms */
		*mp++ = mxval = -mxval;		/*  -val, val, -val, val ... */
	scalfac = 2 / xamp;
	hp = &e->p[7];				/* beginning with given h0,  */
	do {
		mp = mspace;
		oddhp = hp;
		sum = *oddhp++;			/* sum = diag(=1) * this h   */
		for (nn = (nh+1) >>1; --nn; ) {
			oddhp++;		/*  + odd terms * h+2,h+4,.. */
			sum += *mp++ * *oddhp++;
		}
		*hp++ = sum * mxscal;		/* repl this h w. coef (sum) */
		mp = mspace;
		prvm = 1;
		for (nn = nh>>1; --nn > 0; mp++)/* calc nxt row matrix terms */
			*mp = prvm = *mp - prvm;
		mxscal *= scalfac;
	} while (--nh);				/* loop til all h's replaced */
	free((char *)mspace);
printf("calling gen03 with");
hp = &e->p[5];
for (nn = nargs; nn--; )
  printf(" %6.2f",*hp++);
putchar('\n');
	gen03();				/* then call gen03 to write */
}

static void gen15()
{
	float	xint, xamp, hsin[PMAX/2], h, angle;
register float	*fp, *cosp, *sinp;
register int	n, nh;
register long	*lp, *lp13;

	if (nargs & 01)
		FTERR("uneven number of args");
	nh = (nargs - 2) >>1;
	fp = &e->p[5];					/* save p5, p6	*/
	xint = *fp++;
	xamp = *fp++;
	for (n = nh, cosp = fp, sinp = hsin; n > 0; n--) {
		h = *fp++;				/* rpl h,angle pairs */
		angle = *fp++ * tpd360;
		*cosp++ = h * cos((double)angle);	/*  with h cos angle */
		*sinp++ = h * sin((double)angle);	/* and save the sine */
	}
	nargs -= nh;
	gen13();					/* call gen13	*/
	if (fterrcnt) return;
	ftresdisp();					/* and display fno   */
	lp13 = (long *)ftp;
	fno++;					/* alloc eq. space for fno+1 */
	ftalloc();
	for (lp = (long *)ftp; lp < (long *)ftp->ftable; )  /* & copy header */
		*lp++ = *lp13++;
	fp = &e->p[5];
	*fp++ = xint;					/* restore p5, p6,   */
	*fp++ = xamp;
	for (n = nh-1, sinp = hsin+1; n > 0; n--)	/* then skip h0*sin  */
		*fp++ = *sinp++;			/* & copy rem hn*sin */
	nargs--;		
	gen14();					/* now draw ftable   */
}

static void gen17()
{
register int	nsegs, ndx, nxtndx;
register float	*valp, *fp, *finp;
register float	val;

	if ((nsegs = nargs >> 1) <= 0)	     /* nsegs = nargs /2 */
	    goto gn17err;
	valp = &e->p[5];
	fp = ftp->ftable;
	finp = fp + flen;
	if ((ndx = *valp++) != 0)
	    goto gn17err;
	while (--nsegs) {
	    val = *valp++;
	    if ((nxtndx = *valp++) <= ndx)
		goto gn17err;
	    do {
	        *fp++ = val;
		if (fp > finp) return;
	    } while (++ndx < nxtndx);
	}
	val = *valp;
	while (fp <= finp)			/* include 2**n + 1 guardpt */
		*fp++ = val;
        return;

gn17err: fterror("gen call has illegal x-ordinate values:");
}

static void gen19()
{
register int	hcnt;
register float	*valp, *fp, *finp;
	double	phs, inc, amp, dc;

	if ((hcnt = nargs / 4) <= 0)		/* hcnt = nargs / 4 */
		return;
	valp = &e->p[5];
	finp = &ftp->ftable[flen];
	do	for (inc=(*valp++)*tpdlen, amp=(*valp++),
		     phs=(*valp++)*tpd360, dc=(*valp++),
		     fp=ftp->ftable; fp<=finp; fp++) {
			*fp += sin(phs) * amp + dc;   /* dc after str scale */
			if ((phs += inc) >= twopi)
				phs -= twopi;
		}
	while (--hcnt);
}

static void fterror(s)
 char *s;
{
	printf("FTERROR, ftable %d: %s\n",fno,s);
	printf("f%3.0f%8.2f%8.2f%8.2f%8.2f ...\n",
		e->p[1],e->p2orig,e->p3orig,e->p[4],e->p[5]);
	fterrcnt++;
}

static void ftresdisp()   /* set guardpt, rescale the function, and display it */
{
register float	*fp, *finp = &ftp->ftable[flen];
register float	abs, maxval;
static	WINDAT	dwindow;

	if (!guardreq)				/* if no guardpt yet, do it */
	  ftp->ftable[flen] = ftp->ftable[0];
	if (e->p[4] > 0.) {			/* if genum positve, rescale */
	  for (fp=ftp->ftable, maxval = 0.0; fp<=finp; ) {
	    if ((abs = *fp++) < 0.)
	      abs = -abs;
	    if (abs > maxval)
	      maxval = abs;
	  }
	  if (maxval != 0. && maxval != 1.)
	    for (fp=ftp->ftable; fp<=finp; fp++)
	      *fp /= maxval;
	}
        sprintf(strmsg,"ftable %d:",fno);
	dispset(&dwindow,ftp->ftable,(long)(flen+guardreq),strmsg,0,"ftable");
	display(&dwindow);
}

static void ftalloc()	/* alloc ftable space for fno (or replace one)  */
{			/*	set ftp to point to that structure	*/
	if ((ftp = flist[fno]) != NULL) {
	    printf("replacing previous ftable %d\n",fno);
	    if (flen != ftp->flen) {    	/* if redraw & diff len, */
		extern INSDS actanchor;
		free((char *)ftp);      	/*   release old space   */
		flist[fno] = NULL;
		if (actanchor.nxtact != NULL) { /*   & chk for danger    */
		    sprintf(errmsg,"ftable %d relocating due to size change\n\
  currently active instruments may find this disturbing", fno);
		    warning(errmsg);
		}
	    }
	    else {				/* else clear it to zero */
	        register float	*fp = ftp->ftable;
		register float	*finp = &ftp->ftable[flen];
		while (fp <= finp)
		    *fp++ = 0;
	    }
	}
	if ((ftp = flist[fno]) == NULL) {	/*   alloc space as reqd */
	    ftp = (FUNC *) mcalloc((long)sizeof(FUNC) + flen*sizeof(float));
	    flist[fno] = ftp;
	}
}

 FUNC *
ftfind(argp)		/* find the ptr to an existing ftable structure */
 float *argp;		/*   called by oscils, etc at init time		*/
{
register int	fno;
register FUNC	*ftp;

	if ((fno = *argp) <= 0 || fno > FMAX || (ftp = flist[fno]) == NULL) {
		sprintf(errmsg, "invalid ftable no. %f", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else if (!ftp->lenmask) {
		sprintf(errmsg, "deferred-size ftable %f illegal here", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else return(ftp);
}

 FUNC *
ftnp2find(argp)		/* find ptr to a deferred-size ftable structure */
 float *argp;		/*   called by loscil at init time		*/
{
register int	fno;
register FUNC	*ftp;

	if ((fno = *argp) <= 0 || fno > FMAX || (ftp = flist[fno]) == NULL) {
		sprintf(errmsg, "invalid ftable no. %f", *argp);
		initerror(errmsg);
		return(NULL);
	}
	else return(ftp);
}
