#include "cs.h"			/*				UGENS7.C	*/
#include "ugens7.h"
#include <math.h>

/* loosely based on code of Michael Clarke, University of Huddersfield */

static float	fzero = 0., fone = 1.;
static	 int	newpulse();

void fofset(p)
 register FOFS	*p;
{
	if ((p->ftp1 = ftfind(p->ifna)) != NULL
	 && (p->ftp2 = ftfind(p->ifnb)) != NULL) {
	    register OVRLAP *ovp, *nxtovp;
	    register long   olaps;
	    p->durtogo = *p->itotdur * esr;
	    if (*p->iphs == fzero)                      /* if fundphs zero,  */
		p->fundphs = MAXLEN;                    /*   trigger new FOF */
	    else p->fundphs = (long)(*p->iphs * fmaxlen) & PMASK;
	    if ((olaps = *p->iolaps) <= 0) {
		initerror("illegal value for iolaps");
		return;
	    }
	    auxalloc((long)olaps * sizeof(OVRLAP), &p->auxch);
	    ovp = &p->basovrlap;
	    nxtovp = (OVRLAP *) p->auxch.auxp;
	    do {
	        ovp->nxtact = NULL;
		ovp->nxtfree = nxtovp;              /* link the ovlap spaces */
		ovp = nxtovp++;
	    } while (--olaps);
	    ovp->nxtact = NULL;
	    ovp->nxtfree = NULL;
	    p->fofcount = -1;
	    p->prvband = fzero;
	    p->expamp = fone;
	    p->prvsmps = 0;
	    p->preamp = fone;
	    p->xincod   = (p->XINCODE & 0x7) ? 1 : 0;
	    p->ampcod	= (p->XINCODE & 0x2) ? 1 : 0;
	    p->fundcod	= (p->XINCODE & 0x1) ? 1 : 0;
	    p->formcod	= (p->XINCODE & 0x4) ? 1 : 0;
	    p->fmtmod	= (*p->ifmode == fzero) ? 0 : 1;
	}
}

void fof(p)
 register FOFS *p;
{
	register OVRLAP *ovp;
	register FUNC	*ftp1,	*ftp2;
	register float	*ar, *amp, *fund, *form;
	register long   nsmps = ksmps, fund_inc, form_inc;

	ar = p->ar;
	amp = p->xamp;
	fund = p->xfund;
	form = p->xform;
	ftp1 = p->ftp1;
	ftp2 = p->ftp2;
	fund_inc = *fund * sicvt;
	form_inc = *form * sicvt;
	do {
	    if (p->fundphs & MAXLEN) {                     /* if phs has wrapped */
		p->fundphs &= PMASK;
		if ((ovp = p->basovrlap.nxtfree) == NULL)
		    perferror("FOF needs more overlaps");
		if (newpulse(p, ovp, amp, fund, form)) {         /* init new fof */
		    ovp->nxtact = p->basovrlap.nxtact;           /* & link into  */
		    p->basovrlap.nxtact = ovp;                   /*   actlist    */
		    p->basovrlap.nxtfree = ovp->nxtfree;
		}
	    }
	    *ar	= fzero;
	    ovp = &p->basovrlap;
	    while (ovp->nxtact != NULL) {	        /* perform cur actlist:  */
	        register float result;
		register OVRLAP *prvact = ovp;
		ovp = ovp->nxtact;                         /*  formant waveform  */
		result = *(ftp1->ftable + (ovp->formphs >> ftp1->lobits) );
		if (p->fmtmod)
		    ovp->formphs += form_inc;             /*   inc phs on mode  */
		else ovp->formphs += ovp->forminc;
		ovp->formphs &= PMASK;
		if (ovp->risphs < MAXLEN) {                /*  formant ris envlp */
		    result *= *(ftp2->ftable + (ovp->risphs >> ftp2->lobits) );
		    ovp->risphs += ovp->risinc;
		}
		if (ovp->timrem <= ovp->dectim) {          /*  formant dec envlp */
		    result *= *(ftp2->ftable + (ovp->decphs >> ftp2->lobits) );
		    if ((ovp->decphs -= ovp->decinc) < 0)
		        ovp->decphs = 0;
		}
		*ar += (result * ovp->curamp);             /*  add wavfrm to out */
		if (--ovp->timrem)                         /*  if fof not expird */
		    ovp->curamp *= ovp->expamp;            /*   apply bw exp dec */
		else {
		    prvact->nxtact = ovp->nxtact;          /*  else rm frm activ */
		    ovp->nxtfree = p->basovrlap.nxtfree;   /*  & ret spc to free */
		    p->basovrlap.nxtfree = ovp;
		    ovp = prvact;
		}
	    }
	    p->fundphs += fund_inc;
	    if (p->xincod) {
	        if (p->ampcod)	  amp++;
		if (p->fundcod)	  fund_inc = *++fund * sicvt;
		if (p->formcod)   form_inc = *++form * sicvt;
	    }
	    p->durtogo--;
	    *ar++;
	} while (--nsmps);
}

static int newpulse(p, ovp, amp, fund, form)
 register FOFS	 *p;
 register OVRLAP *ovp;
 register float  *amp, *fund, *form;
{
	register float	octamp = *amp, oct;
	register long   rismps, newexp = 0;

	if ((ovp->timrem = *p->kdur * esr) > p->durtogo)  /* ringtime    */
	    return(0);
	if ((oct = *p->koct) > fzero) {                   /* octaviation */
	    register long ioct = oct, bitpat = ~(-1 << ioct);
	    if (bitpat & ++p->fofcount)
	        return(0);
	    if ((bitpat += 1) & p->fofcount)
	        octamp *= (fone + ioct - oct);
	}
	if (*fund == fzero)                               /* formant phs */
	    ovp->formphs = 0;
	else ovp->formphs = (long)(p->fundphs * *form / *fund) & PMASK;
	ovp->forminc = *form * sicvt;
	if (*p->kband != p->prvband) {                    /* bw: exp dec */
	    p->prvband = *p->kband;
	    p->expamp = exp(*p->kband * mpidsr);
	    newexp = 1;
	}
	if (*p->kris >= onedsr && *form != fzero) {      /* init fnb ris */
	    ovp->risphs = ovp->formphs / *form / *p->kris;
	    ovp->risinc = sicvt / *p->kris;
	    rismps = MAXLEN / ovp->risinc;
	}
	else {
	    ovp->risphs = MAXLEN;
	    rismps = 0;
	}
	if (newexp || rismps != p->prvsmps) {            /* if new params */
	    if (p->prvsmps = rismps)                     /*   redo preamp */
	        p->preamp = pow(p->expamp, (float)(-rismps));
	    else p->preamp = fone;
	}
	ovp->curamp = octamp * p->preamp;                /* set startamp  */
	ovp->expamp = p->expamp;
	if ((ovp->dectim = *p->kdec * esr) > 0)          /*      fnb dec  */
	    ovp->decinc = sicvt / *p->kdec;
	ovp->decphs = PMASK;
	return(1);
}

