/*	MIRBUT -- Mirage Button Command Codes
**	Send front panel commands to the Ensoniq Mirage via MIDI
**	psl 8/87
*/
#include	<stdio.h>

char	*Mbn[][2]	= {
	"0",		"PROG",
	"1",		0,
	"2",		0,
	"3",		0,
	"4",		0,
	"5",		0,
	"6",		0,
	"7",		0,
	"8",		0,
	"9",		0,
	"ENTER",	"START",
	"CANCEL",	"STOP",
	"PARAM",	0,
	"VALUE",	0,
	"ON",		"UP",
	"OFF",		"DOWN",
	"LOAD UPPER",	"LOADUPPER",
	"LOAD LOWER",	"LOADLOWER",
	"SAMPLE UPPER",	"SAMPLEUPPER",
	"SAMPLE LOWER",	"SAMPLELOWER",
	"REC SEQ",	"RECSEQ",
	"PLAY SEQ",	"PLAYSEQ",
	"LOAD SEQ",	"LOADSEQ",
	"SAVE SEQ",	"SAVESEQ",
	0,		0,
};

main(argc, argv)
char	*argv[];
{
	register int i, j;

	putc(0x00, stdout);
	putc(0xF0, stdout);
	putc(0x0F, stdout);
	putc(0x01, stdout);
	putc(0x01, stdout);
	for (i = 1; i < argc; i++)
	    if ((j = code(argv[i])) >= 0)
		putc(j, stdout);
	putc(0x7F, stdout);	/* end-of-command */
	putc(0xF7, stdout);
	exit(0);
}

code(cp)
char	*cp;
{
	register int i, j, mtch;

	mtch = -1;
	for (i = 0; Mbn[i][0]; i++) {
	    for (j = 0; j < 2 && Mbn[i][j]; j++) {
		if (match(cp, Mbn[i][j])) {
		    if (mtch != -1) {
			fprintf(stderr, "%s is ambiguous\n", cp);
			return(-1);
		    }
		    mtch = i;
		}
	    }
	}
	if (mtch == -1) {
	    fprintf(stderr, "%s is not defined\n", cp);
	    return(-1);
	}
	return(mtch);
}

match(cp, pat)
char	*cp, *pat;
{
	register char c, p;

	while ((c = *cp++) && (p = *pat++))
	    if (c != p && (c < 'a' || c > 'z' || (c & 0xDF) != p))
		return(0);
	return(1);
}
