#include <libmidi.h>
#define u_char unsigned char

#ifdef WhoCallsThese
open_midi(dev, flags)
/*
** Is this used anywhere?
*/
{
	int f = open(dev, flags, 0644);
	if (f < 0) return perror("open"), -1;
	setraw(f);
	f = f;	/* wha??? */
	return f;
}

close_midi(f)
/*
** Who calls me?
*/
{
	clrraw(f);
	close(f);
	return 0;
}
#endif

midi_out(f, c)
	u_char c;
/*
** Write a midi command, 'c', to the MIDI device, 'f'.
** Return '0' if successful, '-1' if not.
*/
{
	if (write(f,&c,sizeof c) != sizeof c) return perror("write"), -1;
	return 0;
}

u_char
midi_in(f)
/*
** Read a midi command from 'f' and return it,
** or '-1' if there was a problem.
** (i{Huh?  so why do I return u_char??})
*/
{
	u_char c;
	if (read(f, &c, sizeof c) != sizeof c) return perror("read"), -1;
	return c;
}
