/*
**	MPU2MIDI -- Turn MPU files into MIDI files (i.e. strip time tags)
**	psl 1/88
*/

#include <stdio.h>
#include <midi.h>
#include <math.h>

#define	MAXCHAN	16
#define	MAXV	8

char	*title	= 0;			/* title of piece */
int	meter1, meter2;			/* time signature of piece */
int	perc	= 0;			/* input is percussion */
long	start[MAXCHAN];			/* starts of notes */
int	curkey[MAXCHAN];		/* keys of notes */
long	last[MAXCHAN];			/* starts of rests */
int	qpb	= MPU_CLOCK_PERIOD;	/* quanta per bar */
int	quant;				/* clocks per quantum */
int	numv	= 1;			/* number of voices to display */
int	voices[MAXCHAN]	= { 1, };	/* associate voices & channels */

syntax(prog)
char	*prog;
{
	fprintf(stderr, "Usage: %s <mpu-file >midi-file\n", prog);
	exit(2);
}

main(argc, argv)
char *argv[];
{
	int i, n, voice, chan;
	FILE *f;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		default:
		    syntax(argv[0]);
		}
	    }
	}
	n = 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] != '-') {
		if ((f = sopen(argv[i], "r")) != NULL) {
		    cvt(f, stdout);
		    sclose(f);
		    n++;
		} else
		    perror(argv[i]);
	    }
	}
	if (n == 0)
	    cvt(stdin, stdout);
}

cvt(ifp, ofp)
FILE	*ifp, *ofp;
{
	int i;
	long now;
	MCMD *mp;

	now = 0L;
	while (mp = getmcmd(ifp, now))
	    if (mp->cmd[0] != RT_TCWME)
		for (i = 0; i < mp->len; i++)
		    fputc(mp->cmd[i], ofp);
}
