#include <midi.h>
#include <sys/ioctl.h>
#include <mpuvar.h>

PutNote(midi, track, pitch, velocity)
/*
** Start a note playing with the given 'pitch' and 'velocity'
** on 'track' ('0-7') on the 'midi' device.
** 'velocity=0' means "note off".
** 'midi' is the file descriptor for the MPU-401 device.
** The note is played instantaneously, and has no time tag.
** This routine uses the 'MPU_WANT_TO_SEND_DATA' feature
** of the MPU-401 to transmit MIDI data independent of
** time schedules (ie, just poke MIDI data down the pipe
** without time tags).  Similar functions could be written
** to transmit program changes, after touch, etc;
** see sec. 5.9 of the MPU-401 manual.
*/
{
	static unsigned char s[4] = {0, CH_KEY_ON, 0, 0};
	s[0] = MPU_WANT_TO_SEND_DATA + track;
	s[2] = (unsigned char) pitch;
	s[3] = (unsigned char) velocity;
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,4);
	MpuSetTrack(midi,track);
}

NoteOn(midi, track, pitch, velocity)
/*
** Start a note with the given 'pitch' and 'velocity'
** playing on 'track' in 'midi' device.
** Calls 'PutNote()', and hence acts outside of MPU-401 real-time.
*/
{
	PutNote(midi,track,pitch,velocity);
}

NoteOff(midi, track, pitch)
/*
** Stop the note with the given 'pitch'.
** See 'NoteOn()'.
*/
{
	PutNote(midi,track,pitch,0);
}
