/* $Id$
   Copyright 1994 TipTop Software
*/
#import <objc/Protocol.h>

@protocol SessionProtocol
- window;
- terminal;
- progressPanel;
- sessionHelper;
- port;

- (BOOL)isMiniaturized;
- (BOOL)isShellSession;
- (const char *)sessionName;
- (const char *)sessionId;
- (const char *)modemType;

- (const char *)phoneNumber;
- setPhoneNumber:(const char *)n;
- do_setPhoneNumber:(const char *)n;

- (const char *)filesDraggedIn;
- (const char *)receiveDirectory;
- (const char *)transferSound;
- (const char *)dialSound;
- (const char *)emulationName;
- close;

- setWindowTitle:(const char *)t;
- do_setWindowTitle:(const char *)t;
- (const char *)windowTitle;

- sendBreak41s:sender;
- dropDTR41s:sender;
- (BOOL)isDCDSet;
- (BOOL)portIsBuffered;

- resetEmulation:sender;

- (BOOL)isToolbarShowing;
- toggleToolbar:sender;

- setToolbar:(const char *)toolbarName;
- do_setToolbar:(const char *)toolbarName;
- (const char *)toolbar;

- (const char *)toolbarsAvailable;

- beginCapture:sender;
- endCapture:sender;
- toggleCapture:sender;
- (BOOL)isCapturing;

- tickleTopInterpreter:sender;
- stopTickleTop:sender;
- (BOOL)isTickling;
- suspendResumeTickleTop:sender;
- flushTickleTopQueue:sender;
- queueTickleTopCode:(const char *)code;
- do_queueTickleTopCode:(const char *)code;
- queueTickleTopCode:(const char *)code at:(int)i;
- do_queueTickleTopCode:(const char *)code at:(int)i;

- dial:sender;
- hangup:sender;
- autoReindex:sender;
- sourceScript:sender;

- (BOOL)isTransferInProgress;
- sendFiles:sender;
- receiveFiles:sender;
- abortTransfer:sender;
- runReceiveDirectoryPanel:sender;
- setReceiveDirectoryPanel:sender; /* use: runReceiveDirectoryPanel: */

- toggleWatch:sender;
- (BOOL)isWatching;

- setColorMode:(BOOL)f;

- newAuxObject:(const char *)className;
- do_newAuxObject:(const char *)className;

- freeAuxObject:o;		/* Do not use this method. */

- (const char *)modemDialCommand;
- setModemDialCommand:(const char *)c;
- do_setModemDialCommand:(const char *)c;

- (const char *)modemInitString;

- sendToTickle:(const char *)buf length:(int)len;
- sendToTickle:(const char *)buf;

- (BOOL)isCurrentSession;


/////////////////////////////////////////////////////////////////////////////
// Session variables:
/////////////////////////////////////////////////////////////////////////////
- setVariable:(const char *)var value:(const char *)val;
- do_setVariable:(const char *)var value:(const char *)val;

- unsetVariable:(const char *)var;
- do_unsetVariable:(const char *)var;

- (const char *)valueFor:(const char *)var;
- (const char *)do_valueFor:(const char *)var;
@end
