/* $Id$
   Copyright 1994 TipTop Software
*/
#import <objc/Protocol.h>

@protocol TipTopAppProtocol
- (const char *)appName;
- (const char *)directory;

- (const char *)do_openSessionWithName:(const char *)n;
- (const char *)openSessionWithName:(const char *)n;

- (BOOL)do_makeSessionId:(const char *)sid execute:(const char *)code;
- (BOOL)makeSessionId:(const char *)sid execute:(const char *)code;

- do_makeSessionId:(const char *)sid perform:(SEL)sel with:obj;
- makeSessionId:(const char *)sid perform:(SEL)sel with:obj;

- do_makeAllSessionsNamed:(const char *)name perform:(SEL)sel with:obj;
- makeAllSessionsNamed:(const char *)name perform:(SEL)sel with:obj;

- (BOOL)do_closeSessionId:(const char *)sid;
- (BOOL)closeSessionId:(const char *)sid;

- (const char *)do_nameForSessionId:(const char *)sid;
- (const char *)nameForSessionId:(const char *)sid;

- (const char *)allSessionIds;

- (const char *)do_sessionsWithName:(const char *)n;
- (const char *)sessionsWithName:(const char *)n;

- (BOOL)sendAction:(SEL)theAction to:theTarget from:sender;
- (BOOL)sendAction:(SEL)sel;

- do_classNamed:(const char *)name;
- classNamed:(const char *)name;

- (const char *)versionName;
@end
